      REAL FUNCTION WAIR( WVAC )
*
* Returns air wavelength given a vacuum wavelength
* Formula for IUE. No change for WVAC .LT. 2000
*
* Input:
*
*   R*4 WVAC   --  vacuum wavelength in angstroms
*
* Output:
*
*   R*4 WAIR   -- air wavelength in angstroms.
*
* TRM @STSCI, IUE image processing information manual version 2.0
*             page 6-15.
*
      REAL WVAC
      REAL*8 C1,C2,C3,FVAC
      DATA C1,C2,C3/1.0002735182,131.4182,2.76249D8/
      IF(WVAC.LT.2000.) THEN
        WAIR = WVAC
      ELSE
        FVAC = C1+(C2+C3/WVAC**2)/WVAC**2
        WAIR = WVAC/FVAC
      END IF
*
      RETURN
      END

      REAL FUNCTION DWAIR( WAIR )
*
* Add to air wavelength to get vacuum wavelength
*
* Input:
*
*   R*4 WAIR   --  air wavelength in angstroms
*
* Output:
*
*   R*4 DWAIR  -- add this to air wavelength to get vacuum wavelength
*                 (returns 0 for WAIR < 2000.)
*
* Jul 1989 Keith Horne @ STScI - data from Allen 1973 p84.
*
      REAL TAB1(91), TAB2(50), WAIR
      DATA TAB1/
     #        0.648, 0.667, 0.687, 0.708, 0.731
     #      , 0.754, 0.777, 0.801, 0.825, 0.850
     #      , 0.875, 0.900, 0.925, 0.950, 0.976
     #      , 1.001, 1.027, 1.053, 1.079, 1.105
     #      , 1.131, 1.157, 1.183, 1.210, 1.236
     #      , 1.262, 1.289, 1.315, 1.342, 1.368
     #      , 1.395, 1.421, 1.448, 1.475, 1.501
     #      , 1.528, 1.555, 1.581, 1.608, 1.635
     #      , 1.662, 1.689, 1.715, 1.742, 1.769
     #      , 1.796, 1.823, 1.850, 1.877, 1.904
     #      , 1.931, 1.957, 1.984, 2.011, 2.038
     #      , 2.065, 2.092, 2.119, 2.146, 2.173
     #      , 2.200, 2.227, 2.254, 2.281, 2.308
     #      , 2.335, 2.362, 2.389, 2.417, 2.444
     #      , 2.471, 2.489, 2.525, 2.552, 2.579
     #      , 2.606, 2.633, 2.660, 2.687, 2.714
     #      , 2.741, 2.769, 2.796, 2.823, 2.850
     #      , 2.877, 2.904, 2.931, 2.958, 2.985
     #      , 3.012/
      DATA TAB2/
     #        2.741, 3.012, 3.284, 3.556, 3.827
     #      , 4.099, 4.371, 4.643, 4.915, 5.188
     #      , 5.460, 5.732, 6.004, 6.276, 6.549
     #      , 6.821, 7.094, 7.366, 7.638, 7.911
     #      , 8.183, 8.455, 8.728, 9.000, 9.273
     #      , 9.545, 9.818, 10.090, 10.363, 10.635
     #      , 10.908, 11.180, 11.453, 11.725, 11.998
     #      , 12.270, 12.543, 12.815, 13.088, 13.360
     #      , 13.633, 13.906, 14.178, 14.451, 14.723
     #      , 14.996, 15.268, 15.540, 15.813, 16.086
     #      /
*
      IF(WAIR.LT.2000.) THEN
        DWAIR = 0.
      ELSE IF(WAIR.LT.11000.) THEN
*
* Interpolate in table 1
*
        NEAR = 1 + NINT( (WAIR-2000.)/100. )
        NEAR = MAX(2, MIN(90, NEAR) )
        WNEAR = 1900. + 100.*REAL(NEAR)
        PART = (WAIR-WNEAR)/ 100.
        IF(PART.GT.0.) THEN
          DWAIR = TAB1(NEAR)*(1.-PART)+TAB1(NEAR+1)*PART
        ELSE
          DWAIR = TAB1(NEAR)*(1.+PART)-TAB1(NEAR-1)*PART
        END IF
      ELSE
*
* interpolate in table 2
*
        NEAR = 1 + NINT( ( WAIR - 10000. ) / 1000. )
        NEAR = MAX(2, MIN(49, NEAR) )
        WNEAR = 9000 + 1000*NEAR
        PART = ( WAIR - WNEAR ) / 1000.
        IF( PART.GT. 0. ) THEN
          DWAIR = TAB2(NEAR)*(1.-PART)+TAB2(NEAR+1)*PART
        ELSE
          DWAIR = TAB2(NEAR)*(1.+PART)-TAB2(NEAR-1)*PART
        END IF
      END IF
*
      RETURN
      END
