      SUBROUTINE SUN(GJD,X,Y,Z,XDOT,YDOT,ZDOT)
C
C  COMPUTES GEOCENTRIC SOLAR POSITION VECTOR IN LIGHT SECONDS
C  AND VELOCITY IN KM/S IN 1950 RECTANGULAR COORDINATES
C  USING FORMULAE IN THE 1978 ALMANAC FOR COMPUTERS.
C  ACCURACY SHOULD EXCEED .05 LIGHT SECONDS AND .02 KM/S
C
C  WRITTEN JAN 1981 BY KEITH HORNE
C
      REAL*8 GJD,GD,LD,JD,VD,CD,ND
      REAL*4 L,N
      DATA DTR/0.0174532925/
C  JULIAN CENTURY
      T=(GJD-2415020.0D0)/36525.
C  PRECESSION IN LONGITUDE FROM 1950
      P=(1.396041+0.000308*(T+0.5))*(T-0.499998)
C  MEAN ANOMALY OF THE SUN
      GD=358.475833D0 + (35999.049750D0 + 0.000150*T)*T
C  MEAN LONGITUDE OF THE SUN
      LD=279.696678D0 + (36000.768920D0 + 0.000303*T)*T - P
C  MEAN ANOMALY OF JUPITER
      JD=225.444651D0 + 3034.906654D0*T
C  MEAN ANOMALY OF VENUS
      VD=212.603219D0 + (58517.803875D0 + 0.001286*T)*T
C  MEAN LONGITUDE OF THE MOON
      CD=270.434164D0 + (481267.883142D0 - 0.001133*T)*T - P
C  LONGITUDE OF THE ASCENDING NODE OF THE MOON'S ORBIT
      ND=259.183275D0 - (1934.142008D0 - 0.002078*T)*T - P
C
C  REMOVE FULL CYCLES AND REDUCE TO SINGLE PRECISION RADIANS
      G=DCYCLE(GD)*DTR
      L=DCYCLE(LD)*DTR
      J=DCYCLE(JD)*DTR
      V=DCYCLE(VD)*DTR
      C=DCYCLE(CD)*DTR
      N=DCYCLE(ND)*DTR
C
C  COMPUTE NEEDED TRIG FUNCTIONS
      C1=COS(L)
      S1=SIN(L)
      A=G-L
      C2=COS(A)
      S2=SIN(A)
      A=G+L
      C3=COS(A)
      S3=SIN(A)
      A=G+G+L
      C4=COS(A)
      S4=SIN(A)
      A=G+G-L
      C5=COS(A)
      S5=SIN(A)
      A=G-L-J
      C6=COS(A)
      S6=SIN(A)
      A=G+G+L-V-V
      C7=COS(A)
      S7=SIN(A)
      C8=COS(C)
      S8=SIN(C)
      A=C-L-L
      C9=COS(A)
      S9=SIN(A)
      A=4*G+L-8*N+J+J+J
      C10=COS(A)
      S10=SIN(A)
      A=A-L-L
      C11=COS(A)
      S11=SIN(A)
      A=G+L-V
      C12=COS(A)
      S12=SIN(A)
      A=G+G-L-J-J
      C13=COS(A)
      S13=SIN(A)
C
C  SOLAR POSITION VECTOR IN ASTRONOMICAL UNITS
      X=0.999860*C1      -0.025127*C2     +0.008374*C3
     * +0.000105*C4      +0.000063*T*C2   +0.000035*C5
     $ -0.000026*S6      -0.000021*T*C3   +0.000018*S7
     $ +0.000017*C8      -0.000014*C9     +0.000012*C10
     $ -0.000012*C11     -0.000012*C12    +0.000011*C13
     $ +0.000011*C7
C
      Y=0.917308*S1      +0.023053*S2     +0.007683*S3
     $ +0.000097*S4      -0.000057*T*S2   -0.000032*S5
     $ -0.000024*C2      -0.000019*T*S3   -0.000017*C7
     $ +0.000016*S8      +0.000013*S9     +0.000011*S10
     $ +0.000011*S11     -0.000011*S12    +0.000010*S7
     $ -0.000010*S13
C
      Z=0.397825*S1      +0.009998*S2     +0.003332*S3
     $ +0.000042*S4      -0.000025*T*S2   -0.000014*S5
     $ -0.000010*C6
C
C  SOLAR VELOCITY VECTOR IN ASTRONOMICAL UNITS PER DAY
      XDOT=-0.017200*S1      -0.000288*S3      -0.000005*S4
     $     -0.000004*S8      +0.000003*S9      +0.000001*T*S3
     $     -0.000001*S5
C
      YDOT= 0.015780*C1      +0.000264*C3      +0.000005*C4
     $     +0.000004*C8      +0.000003*C9      -0.000001*T*C3
C
      ZDOT= 0.006843*C1      +0.000115*C3      +0.000002*C4
     $     +0.000002*C8      +0.000001*C9
C
C  CONVERT FROM AU TO LIGHT SECONDS
      TIME=499.012
      X=X*TIME
      Y=Y*TIME
      Z=Z*TIME
C
C  CONVERT FROM AU/DAY TO KM/S
      VEL=1731.481
      XDOT=XDOT*VEL
      YDOT=YDOT*VEL
      ZDOT=ZDOT*VEL
      RETURN
      END

      FUNCTION DCYCLE(X)
      REAL*8 X
      NCYCLE=X/360
      DCYCLE=X-NCYCLE*360.0D0
      RETURN
      END
      SUBROUTINE SUNPOS(YEAR,MONTH,DAY,TIME,SRA,SDEC)
C
C CALCULATES RA,DEC OF SUN AT A GIVEN DATE AND TIME
C
      DOUBLE PRECISION PI
      PARAMETER (PI=3.14159265D0)
      INTEGER*4 YEAR,MONTH,DAY
      REAL*8 DATE,TIM,TIME,EG,WG,WORK,DIFF,GUESS,DIV,SRA,SDEC
      DATA EG,WG,EC,ECL/2.7904147D2,2.82510396D2,1.672D-2,2.343333D1/
C
C EG ECLIPTIC LONGITUDE AT 1975.0 IN DEGREES
C WG ECLIPTIC LONGITUDE OF PERIGEE IN DEGREES
C EC ECCENTRICITY OF EARTH ORBIT
C
      CALL NDAY(0,1,1975,IDUM,IWANT)
      CALL NDAY(DAY,MONTH,YEAR,ND,ND1)
      TIM=TIME
      DATE=DBLE(ND1-IWANT)+TIM/2.4D1
      WORK=3.6D2/3.6525D2*DATE+EG-WG
      WORK=WORK-3.6D2*DBLE(INT(WORK/3.6D2))
      IF(WORK.LT.0.D0) WORK=WORK+3.6D2
      WORK=PI*WORK/1.8D2
      GUESS=WORK
10    DIFF=GUESS-EC*SIN(GUESS)-WORK
      DIV=1.D0-EC*COS(GUESS)
      IF(ABS(DIFF).LT.1.D-5) GOTO 20
      GUESS=GUESS-DIFF/DIV
      GOTO 10
20    IF(ABS(GUESS-PI).LT.1.D-5) THEN
        WORK=1.8D2
        GOTO 30
      ELSE IF(ABS(GUESS-2.D0*PI).LT.1.D-5) THEN
        WORK=3.6D2
        GOTO 30
      END IF
      IF(GUESS.GT.2.D0*PI) GUESS=GUESS-2.D0*PI
      WORK=SQRT((1.D0+EC)/(1.D0-EC))*TAN(GUESS/2.D0)
      WORK=2.D0*ATAND(WORK)
30    WORK=WORK+WG
      IF(WORK.GT.3.6D2) WORK=WORK-3.6D2
      IF(WORK.LT.0.D0)  WORK=WORK+3.6D2
      SRA=ATAND(TAND(WORK)*COSD(ECL))
      SDEC=ASIND(SIND(ECL)*SIND(WORK))
      IF(SRA.LT.0.D0) THEN
        IF(WORK.GE.2.6D2) THEN
          SRA=SRA+3.6D2
        ELSE
          SRA=SRA+1.8D2
        END IF
      ELSE
        IF(WORK.GE.1.7D2) SRA=SRA+1.8D2
      END IF
      SRA=SRA/1.5D1
      RETURN
      END
      SUBROUTINE SUNSET(YEAR,MONTH,DAY,LONG,LATI,RISEG,SETG,IERR)
C
C SUBRUTINE FOR FINDING SUNRISE AND SUNSET TIMES IN GMT
C YEAR,MONTH,DAY INPUT FOR THE DATE
C LONG = LONGITUDE OF OBSERVATION POINT
C LATI = LATITUDE OF OBSERVATION POINT
C RISEG= SUNRISE IN HOURS REAL*8
C SETG = SUNSET IN HOURS  REAL*8
C
C IERR=0 IF ALL OK
C IERR=1 IF NO RISE/SET OCCURS
C
      INTEGER*4 YEAR,MONTH,DAY,LENG(12)
      REAL*8 LONG
      REAL*8 LAT,LON,RASUN,DECSUN
      REAL*8 WORK,WORK1,RISEG,SETG,ALSUN1,ALSUN2,ALSUN3,AZSUN
      REAL*8 APAR,BPAR,CPAR
      DATA LENG/31,28,31,30,31,30,31,31,30,31,30,31/
      DATA ALSET/-8.3333D-1/
C
      IERR=0
      LAT=LATI
      LON=LONG/1.5D1
C
C FIRST TAKE THE TIME AS MIDDAY ON THE DAY IN QUESTION
C
C CALCULATE RA,DEC OF THE SUN
      WORK=1.2D1-LON
      IF(WORK.LT.0) WORK=WORK+2.4D1
      CALL SUNPOS(YEAR,MONTH,DAY,WORK,RASUN,DECSUN)
C
C FIRST APPROXIMATIONS TO RISE AND SETTING TIMES
      WORK=-TAND(LAT)*TAND(DECSUN)
      IF(WORK.LT.-1.D0.OR.WORK.GT.1.D0) THEN
        PRINT *,'No rise or set occurs'
        IERR=1
        RETURN
      END IF
      RISE=2.4D1-ACOSD(WORK)/1.5D1+RASUN
      RISE=RISE-2.4D1*DBLE(INT(RISE/2.4D1))
      SET=ACOSD(WORK)/1.5D1+RASUN
      SET=SET-2.4D1*DBLE(INT(SET/2.4D1))
      CALL GMT(YEAR,MONTH,DAY,RISEG,RISE)
      CALL GMT(YEAR,MONTH,DAY,SETG,SET)

C
C CALCULATE NEW RA,DEC FOR SUN
C AND THEN SUNRISE TIME
C
47    CALL CHECK1(LON,RISEG,YEAR,MONTH,DAY,IYEAR,IMONTH,IDAY)
      CALL SUNPOS(IYEAR,IMONTH,IDAY,RISEG,RASUN,DECSUN)
      WORK=-TAND(LAT)*TAND(DECSUN)
      WORK=2.4D1-ACOSD(WORK)/1.5D1+RASUN
      WORK=WORK-2.4D1*DBLE(INT(WORK/2.4D1))
      IF(ABS(WORK-RISE).GT.2.D-4) THEN
        RISE=WORK
        CALL GMT(IYEAR,IMONTH,IDAY,RISEG,RISE)
        GOTO 47
      END IF
      CALL GMT(IYEAR,IMONTH,IDAY,RISEG,WORK)
      CALL CHECK1(LON,RISEG,YEAR,MONTH,DAY,IYEAR,IMONTH,IDAY)
C
C FIRST APPROX COMPLETE, NOW FOR CALCULATION OF AZIMUTH
C
      CALL SIDER(IYEAR,IMONTH,IDAY,RISEG,WORK)
      CALL SUNPOS(IYEAR,IMONTH,IDAY,RISEG,RASUN,DECSUN)
      CALL ALTAZ(LAT,LONG,RASUN,DECSUN,WORK,ALSUN1,AZSUN)
      RISEG=RISEG-5.D-2
      CALL SIDER(IYEAR,IMONTH,IDAY,RISEG,WORK)
      CALL SUNPOS(IYEAR,IMONTH,IDAY,RISEG,RASUN,DECSUN)
      CALL ALTAZ(LAT,LONG,RASUN,DECSUN,WORK,ALSUN2,AZSUN)
      RISEG=RISEG-5.D-2
      CALL SIDER(IYEAR,IMONTH,IDAY,RISEG,WORK)
      CALL SUNPOS(IYEAR,IMONTH,IDAY,RISEG,RASUN,DECSUN)
      CALL ALTAZ(LAT,LONG,RASUN,DECSUN,WORK,ALSUN3,AZSUN)
      APAR=(ALSUN1+ALSUN3-2.D0*ALSUN2)/5.D-3
      BPAR=(ALSUN1-ALSUN3)/1.D-1
C
C ALSET SET IN DATA STATEMEMT ABOVE , WILL ACCOUNT FOR SIZE AND
C REFRACTION OF THE SUN
C
      CPAR=ALSUN2-ALSET
      RISEG=RISEG+5.D-2
      IF(ABS(2.D-1*APAR).GT.ABS(BPAR))
     $PRINT *,CHAR(7),'Possible error in rise time'
      IF(BPAR*BPAR-4.D0*APAR*CPAR.LT.0.D0) THEN
        IERR=1
        RETURN
      END IF
      WORK=(-BPAR+SQRT(BPAR*BPAR-4.D0*APAR*CPAR))/2.D0/APAR
      WORK1=(-BPAR-SQRT(BPAR*BPAR-4.D0*APAR*CPAR))/2.D0/APAR
      IF(ABS(WORK1).LT.ABS(WORK)) THEN
        RISEG=RISEG+WORK1
      ELSE
        RISEG=RISEG+WORK
      END IF
C
C SUNSET TIME
C
48    CALL CHECK2(LON,SETG,YEAR,MONTH,DAY,IYEAR,IMONTH,IDAY)
      CALL SUNPOS(IYEAR,IMONTH,IDAY,SETG,RASUN,DECSUN)
      WORK=-TAND(LAT)*TAND(DECSUN)
      WORK=ACOSD(WORK)/1.5D1+RASUN
      WORK=WORK-2.4D1*DBLE(INT(WORK/2.4D1))
      IF(ABS(WORK-SET).GT.2.D-4) THEN
        SET=WORK
        CALL GMT(IYEAR,IMONTH,IDAY,SETG,SET)
        GOTO 48
      END IF
      CALL GMT(IYEAR,IMONTH,IDAY,SETG,WORK)
      CALL CHECK2(LON,SETG,YEAR,MONTH,DAY,IYEAR,IMONTH,IDAY)
C
C FIRST APPROX COMPLETE, NOW FOR CALCULATION OF AZIMUTH
C
      CALL SIDER(IYEAR,IMONTH,IDAY,SETG,WORK)
      CALL SUNPOS(IYEAR,IMONTH,IDAY,SETG,RASUN,DECSUN)
      CALL ALTAZ(LAT,LONG,RASUN,DECSUN,WORK,ALSUN3,AZSUN)
      SETG=SETG+5.D-2
      CALL SIDER(IYEAR,IMONTH,IDAY,SETG,WORK)
      CALL SUNPOS(IYEAR,IMONTH,IDAY,SETG,RASUN,DECSUN)
      CALL ALTAZ(LAT,LONG,RASUN,DECSUN,WORK,ALSUN2,AZSUN)
      SETG=SETG+5.D-2
      CALL SIDER(IYEAR,IMONTH,IDAY,SETG,WORK)
      CALL SUNPOS(IYEAR,IMONTH,IDAY,SETG,RASUN,DECSUN)
      CALL ALTAZ(LAT,LONG,RASUN,DECSUN,WORK,ALSUN1,AZSUN)
      APAR=(ALSUN1+ALSUN3-2.D0*ALSUN2)/5.D-3
      BPAR=(ALSUN1-ALSUN3)/1.D-1
C
C ALSET SET IN DATA STATEMEMT ABOVE , WILL ACCOUNT FOR SIZE AND
C REFRACTION OF THE SUN
C
      CPAR=ALSUN2-ALSET
      SETG=SETG-5.D-2
      IF(ABS(2.D-1*APAR).GT.ABS(BPAR))
     $PRINT *,CHAR(7),'Possible error in set time'
      IF(BPAR*BPAR-4.D0*APAR*CPAR.LT.0.D0) THEN
        IERR=1
        RETURN
      END IF
      WORK=(-BPAR+SQRT(BPAR*BPAR-4.D0*APAR*CPAR))/2.D0/APAR
      WORK1=(-BPAR-SQRT(BPAR*BPAR-4.D0*APAR*CPAR))/2.D0/APAR
      IF(ABS(WORK1).LT.ABS(WORK)) THEN
        SETG=SETG+WORK1
      ELSE
        SETG=SETG+WORK
      END IF
      RETURN
      END
C
      SUBROUTINE CHECK1(LON,RISEG,YEAR,MONTH,DAY,IYEAR,IMONTH,IDAY)
C
      INTEGER*4 IYEAR,IMONTH,IDAY,YEAR,MONTH,DAY,LENG(12)
      REAL*8 LON,RISEG
      DATA LENG/31,28,31,30,31,30,31,31,30,31,30,31/
C
      IF(LON.LT.1.2D1) THEN
        RISEG=RISEG-LON
        IMONTH=MONTH
        IDAY=DAY
        IYEAR=YEAR
        IF(RISEG.LT.0.D0) THEN
          IDAY=DAY-1
          IMONTH=MONTH
          IYEAR=YEAR
          IF(IDAY.EQ.0) THEN
            IMONTH=MONTH-1
            IDAY=LENG(IMONTH)
            IF(IMONTH.EQ.2.AND.YEAR-4*(YEAR/4).EQ.0) IDAY=29
            IF(IMONTH.EQ.0) THEN
              IYEAR=IYEAR-1
              IMONTH=12
              IDAY=31
            END IF
          END IF
          RISEG=RISEG+2.4D1
        END IF
      ELSE
        RISEG=RISEG+2.4D1-LON
        IDAY=DAY
        IMONTH=MONTH
        IYEAR=YEAR
      END IF
      RETURN
      END
C
      SUBROUTINE CHECK2(LON,SETG,YEAR,MONTH,DAY,IYEAR,IMONTH,IDAY)
C
      INTEGER*4 IYEAR,IMONTH,IDAY,YEAR,MONTH,DAY,LENG(12)
      REAL*8 LON,SETG
      DATA LENG/31,28,31,30,31,30,31,31,30,31,30,31/
C
      IF(LON.LT.1.2D1) THEN
        SETG=SETG-LON
        IDAY=IDAY
        IMONTH=MONTH
        IYEAR=YEAR
      ELSE
        SETG=SETG+2.4D1-LON
        IDAY=DAY
        IMONTH=MONTH
        IYEAR=YEAR
        IF(SETG.GT.2.4D1) THEN
          SETG=SETG-2.4D1
          IDAY=DAY+1
          IMONTH=MONTH
          IYEAR=YEAR
          IF(IDAY.GT.LENG(MONTH)) THEN
            IMONTH=MONTH+1
            IDAY=1
            IF(IMONTH.EQ.13) THEN
              IMONTH=1
              IDAY=1
              IYEAR=YEAR+1
            END IF
          END IF
          IF(DAY+1.EQ.29.AND.MONTH.EQ.2
     $       .AND.YEAR-4*(YEAR/4).EQ.0) THEN
            IMONTH=MONTH
            IDAY=DAY+1
          END IF
        END IF
      END IF
      RETURN
      END
