        REAL FUNCTION SEATON (LAMBDA, EBV)
C
C  **  [RAW.IUE]SEATON.FOR   NOV 1981    R.A.WADE  **
C
C  **  PROVIDES EXTINCTION (IN MAGS) AT A GIVEN
C      WAVELENGTH (IN MICRONS), FOR A GIVEN
C      VALUE OF E(B-V) (IN MAGS).  BASED ON
C      SEATON'S PAPER IN M.N.R.A.S. VOL 187,
C      PAGE 75P (1979).  THE FORMULAE ARE BASED
C      ON AN ADOPTED VALUE OF R = 3.20  .
C
C      NOTE THAT SEATON'S REPRESENTATION OF
C      OF THE INTERSTELLAR REDDENING LAW
C      DIFFERS SUBSTANTIALLY FROM SCHILD'S
C      REPRESENTATION (ASTRON. J. 82, 339,
C      TABLE II, 1977) IN THE REGION OF
C      OVERLAP.  SCHILD ALSO ADOPTED R = 3.20 .
C
C      FOR WAVELENGTHS > 3704 ANGSTROMS, THE
C      PROGRAM INTERPOLATES LINEARLY IN 1/LAMBDA
C      IN SEATON'S TABLE 3.  ENTRY IN THE TABLE
C      IS FACILITATED BY AN ARRAY, INDEX.
C      FOR WAVELENGTHS < 3704 ANGSTROMS, THE
C      PROGRAM USES THE FORMULAE FROM SEATON'S
C      TABLE 2.  THE FORMULAE MATCH AT THE
C      ENDPOINTS OF THEIR RESPECTIVE INTERVALS.
C      THERE IS A MISMATCH OF 0.009 MAG/EBV
C      AT NU=2.7 (LAMBDA=3704 ANGSTROMS).
C      SEATON'S TABULATED VALUE OF 1.44 MAGS AT
C      1/LAMBDA = 1.1 MAY BE IN ERROR; 1.64 SEEMS
C      MORE CONSISTENT WITH HIS OTHER VALUES.
C
C      WAVELENGTH RANGE ALLOWED IS 0.1000 TO
C      1.0000 MICRONS .  CALLS TO THE SUBROUTINE
C      FOR WAVELENGTHS OUTSIDE THIS RANGE
C      RESULT IN A VALUE OF -1. FOR THE
C      EXTINCTION BEING RETURNED.
C
C
      IMPLICIT NONE
      INTEGER I, J, K, I1, I2
      REAL E1, E2, LAMBDA, NU, EBV, LINV(18), E(18)
      REAL DIFF, L1, L2
      INTEGER INDX(4), NPTS
      LOGICAL DEBUG
      DATA NPTS/18/
      DATA DEBUG/.FALSE./
      DATA    LINV/1.0, 1.1, 1.2, 1.3, 1.4, 1.5,
     &             1.6, 1.7, 1.8, 1.9, 2.0, 2.1,
     &             2.2, 2.3, 2.4, 2.5, 2.6, 2.7/
      DATA    E/1.36, 1.44, 1.84, 2.04, 2.24, 2.44,
     &          2.66, 2.88, 3.14, 3.36, 3.56, 3.77,
     &          3.96, 4.15, 4.26, 4.40, 4.52, 4.64/
      DATA    INDX/1, 6, 11, 15/
C
C  INITIALIZE AND CHECK INPUT DATA
C
      I=0
      J=0
      K=0
      SEATON = -1.0
      IF (LAMBDA.LT.0.1 .OR. LAMBDA.GT.1.) RETURN
      NU = 1.0/LAMBDA
C
C  CHECK IF FORMULAE ARE NEEDED
C
      IF (NU.GE.2.7) GO TO 40
C
C  IF NOT, USE TABLE
C
      IF (NU.LT.1.5) THEN
        I=INDX(1)
      ELSE IF (NU.LT.2.0) THEN
        I=INDX(2)
      ELSE IF (NU.LT.2.4) THEN
        I=INDX(3)
      ELSE
        I=INDX(4)
      END IF
C
10    IF (NU.LT.LINV(I)) GO TO 200
      DO J= I+1, NPTS
        IF (NU.LE.LINV(J)) THEN
          I1 = J-1
          I2 = J
          GOTO 30
        END IF
      END DO
C
C     NOW DO LINEAR INTERPOLATION
30    L1=LINV(I1)
      L2=LINV(I2)
      E1=E(I1)
      E2=E(I2)
      SEATON=E1 + (E2-E1)*(NU-L1)/(L2-L1)
      SEATON=SEATON*EBV
      RETURN
C
C  USE FORMULAS
C
   40 IF (NU.GE.3.65) GO TO 50
C     ELSE 2.7 < NU < 3.65
      K=1
        DIFF = NU - 4.6
      SEATON=1.56 + 1.048*NU + 1.01/( DIFF*DIFF + 0.280)
      GO TO 70
C
   50 IF (NU.GE.7.14) GO TO 60
C     ELSE 3.65 < NU < 7.14
      K=2
        DIFF = NU - 4.6
      SEATON = 2.29 + 0.848*NU + 1.01/( DIFF*DIFF + 0.280)
      GO TO 70
C
C     ELSE 7.14 < NU < 10.00
   60 K=3
      SEATON=16.17 + NU*(-3.20 + 0.2975*NU)
C
   70 IF (DEBUG) WRITE(6,102) K, LAMBDA, NU, SEATON
      SEATON=SEATON*EBV
      RETURN
C
C  ERROR HANDLING
C
  200 WRITE (*,101)
      WRITE (*,100) I,J,I1,I2,L1,NU,L2,E1,SEATON,E2
      RETURN
C
  100 FORMAT(' SEATON: INTERPOLATION RESULTS:',
     $/' INDICES I, J, I1, I2:',2I5,T40,I10,10X,I10,
     $/' L1, NU, L2:',T40,3F10.3,
     $/' E1, SEATON, E2:',T40,3F10.3/)
  101 FORMAT(' ERROR IN SUBROUTINE SEATON: LAMBDA',
     $' OUT OF RANGE OR INDEXING IS WRONG.')
  102 FORMAT(' SEATON: FORMULA',I2,':',
     $/' LAMBDA, NU, SEATON:',3F10.4)
C
      END
