      DOUBLE PRECISION FUNCTION RTSAFE(FUNCD,X1,X2,XACC)
*
*  Numerical recipes root finding routine
*
      IMPLICIT NONE
      INTEGER MAXIT, J
      PARAMETER (MAXIT=100)
      EXTERNAL FUNCD
      DOUBLE PRECISION X1, X2, FL, DF, FH, XL, XH
      DOUBLE PRECISION SWAP, DXOLD, DX, TEMP, F, XACC
*
      CALL FUNCD(X1,FL,DF)
      CALL FUNCD(X2,FH,DF)
      IF(FL*FH.GE.0.) PAUSE 'RTSAFE: root must be bracketed'
      IF(FL.LT.0.)THEN
        XL=X1
        XH=X2
      ELSE
        XH=X1
        XL=X2
        SWAP=FL
        FL=FH
        FH=SWAP
      ENDIF
      RTSAFE=.5*(X1+X2)
      DXOLD=ABS(X2-X1)
      DX=DXOLD
      CALL FUNCD(RTSAFE,F,DF)
      DO J=1,MAXIT
        IF(((RTSAFE-XH)*DF-F)*((RTSAFE-XL)*DF-F).GE.0.
     *    .OR. ABS(2.*F).GT.ABS(DXOLD*DF) ) THEN
          DXOLD=DX
          DX=0.5*(XH-XL)
          RTSAFE=XL+DX
          IF(XL.EQ.RTSAFE) RETURN
        ELSE
          DXOLD=DX
          DX=F/DF
          TEMP=RTSAFE
          RTSAFE=RTSAFE-DX
          IF(TEMP.EQ.RTSAFE)RETURN
        ENDIF
        IF(ABS(DX).LT.XACC) RETURN
        CALL FUNCD(RTSAFE,F,DF)
        IF(F.LT.0.) THEN
          XL=RTSAFE
          FL=F
        ELSE
          XH=RTSAFE
          FH=F
        ENDIF
      ENDDO
      PAUSE 'RTSAFE exceeding maximum iterations'
      RETURN
      END
