        SUBROUTINE I2QUICKSORT(N,X,KEY)
*
* I2QUICKSORT subroutine (Hoare)
* Produces index such that X(KEY(I)) ascends with I
*
* Adapted by T.R. Marsh from a Mike Irwin routine
* X is left unchanged. Compatible arguments with
* SHELLSORT and BUBSORT. About 3 times faster than
* SHELLSORT for more than 5000 points, roughly the
* same below 2000.
* INTEGER*2 version TRM @ RGO 12/05/88
*
        INTEGER*2 X(N)
        INTEGER*2 XTEST
        INTEGER*4 ISTACK(2,100), KEY(N)
        LOGICAL*1 L1,L2,L3, CARRYON
*
        DO I = 1, N
          KEY(I) = I
        END DO
        CARRYON = .TRUE.
        M = 9
        IF(N.GT.M) THEN
          IL = 1
          IR = N
*
* Initialise stack pointer
*
          ISP = 0
          DO WHILE(CARRYON)
            I = IL
            J = IR + 1
*
* Find median for partition
*
            IM=(IL+IR)/2
            L1=X(KEY(IM)).LT.X(KEY(IR))
            L2=X(KEY(IR)).LT.X(KEY(IL))
            L3=X(KEY(IL)).LT.X(KEY(IM))
            IF(L2.EQV.L3)THEN
              IQ=IL
            ELSE
              IF(L1.EQV.L3)THEN
                IQ=IM
              ELSE
                IQ=IR
              END IF
            END IF
            XTEST = X(KEY(IQ))
            ITEST = KEY(IQ)
            KEY(IQ) = KEY(IL)
            KEY(IL) = ITEST
100         I = I + 1
            DO WHILE(X(KEY(I)).LT.XTEST)
              I=I+1
            END DO
            J = J - 1
            DO WHILE(XTEST.LT.X(KEY(J)))
              J = J-1
            END DO
            IF(J.LE.I)THEN
              ITEST = KEY(J)
              KEY(J) = KEY(IL)
              KEY(IL) = ITEST
            ELSE
              ITEST = KEY(J)
              KEY(J) = KEY(I)
              KEY(I) = ITEST
              GOTO 100
            END IF
*
* Update stack
*
            IF(IR-J.GE.J-IL.AND.J-IL.GT.M)THEN
              ISP=ISP+1
              ISTACK(1,ISP)=J+1
              ISTACK(2,ISP)=IR
              IR=J-1
            ELSE IF(J-IL.GT.IR-J.AND.IR-J.GT.M)THEN
              ISP=ISP+1
              ISTACK(1,ISP)=IL
              ISTACK(2,ISP)=J-1
              IL=J+1
            ELSE IF(IR-J.GT.M.AND.M.GE.J-IL)THEN
              IL=J+1
            ELSE IF(J-IL.GT.M.AND.M.GE.IR-J)THEN
              IR=J-1
            ELSE IF(ISP.GT.0)THEN
              IL=ISTACK(1,ISP)
              IR=ISTACK(2,ISP)
              ISP=ISP-1
            ELSE
              CARRYON = .FALSE.
            END IF
          END DO
        END IF
*
* Straight insertion sort
*
        IF(M.EQ.1) RETURN
        INT=1
        IFIN=N-INT
        DO II=1,IFIN
          I=II
          J=I+INT
          IF(X(KEY(I)).GT.X(KEY(J))) THEN
            XTEST=X(KEY(J))
            ITEST = KEY(J)
            KEY(J) = KEY(I)
            J=I
            I=I-INT
            DO WHILE(I.GT.0 .AND. X(KEY(I)).GT.XTEST)
              KEY(J)= KEY(I)
              J=I
              I=I-INT
            END DO
            KEY(J)=ITEST
          END IF
        END DO
        RETURN
        END

        SUBROUTINE QUICKSORT(N,X,KEY)
*
* QUICKSORT subroutine (Hoare)
* Produces index such that X(KEY(I)) ascends with I
*
* Adapted by T.R. Marsh from a Mike Irwin routine
* X is left unchanged. Compatible arguments with
* SHELLSORT and BUBSORT. About 3 times faster than
* SHELLSORT for more than 5000 points, roughly the
* same below 2000.
*
        REAL*4 X(N)
        REAL*4 XTEST
        INTEGER*4 ISTACK(2,100), KEY(N)
        LOGICAL*1 L1,L2,L3, CARRYON
*
        DO I = 1, N
          KEY(I) = I
        END DO
        CARRYON = .TRUE.
        M = 9
        IF(N.GT.M) THEN
          IL = 1
          IR = N
*
* Initialise stack pointer
*
          ISP = 0
          DO WHILE(CARRYON)
            I = IL
            J = IR + 1
*
* Find median for partition
*
            IM=(IL+IR)/2
            L1=X(KEY(IM)).LT.X(KEY(IR))
            L2=X(KEY(IR)).LT.X(KEY(IL))
            L3=X(KEY(IL)).LT.X(KEY(IM))
            IF(L2.EQV.L3)THEN
              IQ=IL
            ELSE
              IF(L1.EQV.L3)THEN
                IQ=IM
              ELSE
                IQ=IR
              END IF
            END IF
            XTEST = X(KEY(IQ))
            ITEST = KEY(IQ)
            KEY(IQ) = KEY(IL)
            KEY(IL) = ITEST
100         I = I + 1
            DO WHILE(X(KEY(I)).LT.XTEST)
              I=I+1
            END DO
            J = J - 1
            DO WHILE(XTEST.LT.X(KEY(J)))
              J = J-1
            END DO
            IF(J.LE.I)THEN
              ITEST = KEY(J)
              KEY(J) = KEY(IL)
              KEY(IL) = ITEST
            ELSE
              ITEST = KEY(J)
              KEY(J) = KEY(I)
              KEY(I) = ITEST
              GOTO 100
            END IF
*
* Update stack
*
            IF(IR-J.GE.J-IL.AND.J-IL.GT.M)THEN
              ISP=ISP+1
              ISTACK(1,ISP)=J+1
              ISTACK(2,ISP)=IR
              IR=J-1
            ELSE IF(J-IL.GT.IR-J.AND.IR-J.GT.M)THEN
              ISP=ISP+1
              ISTACK(1,ISP)=IL
              ISTACK(2,ISP)=J-1
              IL=J+1
            ELSE IF(IR-J.GT.M.AND.M.GE.J-IL)THEN
              IL=J+1
            ELSE IF(J-IL.GT.M.AND.M.GE.IR-J)THEN
              IR=J-1
            ELSE IF(ISP.GT.0)THEN
              IL=ISTACK(1,ISP)
              IR=ISTACK(2,ISP)
              ISP=ISP-1
            ELSE
              CARRYON = .FALSE.
            END IF
          END DO
        END IF
*
* Straight insertion sort
*
        IF(M.EQ.1) RETURN
        INT=1
        IFIN=N-INT
        DO II=1,IFIN
          I=II
          J=I+INT
          IF(X(KEY(I)).GT.X(KEY(J))) THEN
            XTEST=X(KEY(J))
            ITEST = KEY(J)
            KEY(J) = KEY(I)
            J=I
            I=I-INT
            DO WHILE(I.GT.0 .AND. X(KEY(I)).GT.XTEST)
              KEY(J)= KEY(I)
              J=I
              I=I-INT
            END DO
            KEY(J)=ITEST
          END IF
        END DO
        RETURN
        END
