        SUBROUTINE QUADFIT(YY,XX,ERR,N,A1,A2,A3,VAR,IERR)
C
C SUBROUTINE TO PERFORM A WEIGHTED LEAST SQUARES FIT Y=A1+A2*X+A3*(X**2)
C TO A SET OF POINTS WITH Y,X AND THE ERROR ON Y GIVEN AT EACH POINT
C A1, A2, A3 CONTAINS THE RESULT, VAR(6) CONTAINS THE VARIANCES AS SPECIFIED
C BELOW. THESE WILL ONLY BE CORRECT IF THE ARRAY ERR(N) IS CORRECTLY
C INPUT AND IF THE RESIDUALS CAN BE ASSUMED TO BE NORMALLY DISTRIBUTED.
C
C PASSED:
C         REAL*4 YY(N) ARRAY OF Y VALUES
C         REAL*4 XX(N) ARRAY OF X VALUES
C         REAL*4 ERR(N) ARRAY OF ERROR ESTIMATES ON THE YY VALUES
C       YY VALUES ARE ASSUMED TO BE UNCORELATED (STANDARD DEVIATIONS)
C       IF ANY ARE LESS THAN OR EQUAL TO ZERO THEY WILL BE IGNORED
C         INTEGER*4 N  NUMBER OF POINTS TO FIT
C
C RETURNED:
C         REAL*4 A1, A2, A3  FITTED PARAMETERS AS ABOVE
C
C         REAL*4 VAR(6) VARIANCE MATRIX. SHOULD BE 9 ELEMENTS, BUT
C         ELEMENTS ARE AS FOLLOWS VAR(1)=VAR( A1 )
C                                 VAR(2)=VAR( A2 )
C                                 VAR(3)=VAR( A3 )
C                                 VAR(4)=COVAR(A1, A2)
C                                 VAR(5)=COVAR(A2, A3)
C                                 VAR(6)=COVAR(A3, A1)
C WHERE ON THE RIGHT-HAND SIDE, VAR STANDS FOR VARIANCE.
C         INTEGER*4 IERR 0 IF NO ERROR, 1 OTHERWISE
C
        REAL*4 YY(1),XX(1),ERR(1),A1,A2,A3,VAR(6)
        INTEGER*4 N, IERR
C
        IERR=0
C
C SUMS WHICH WILL BE FORMED SET TO ZERO INITIALLY
C
        S1 = 0.
        S2 = 0.
        S3 = 0.
        S4 = 0.
        S5 = 0.
        V1 = 0.
        V2 = 0.
        V3 = 0.
C
C THE S'S ARE ELEMENTS OF A MATRIX MULTIPLYING THE A PARAMETERS GIVING
C THE VECTOR FORMED BY THE V'S
C
        DO 10 I= 1, N
          ERROR = ERR(I)
          IF(ERROR.LE.0.) GOTO 10
          Y1 = YY(I)/ERROR
          C1 = XX(I)/ERROR
          C2 = C1*XX(I)
          C3 = 1./ERROR
          S1 = S1 + C3*C3       ! SUM OF 1/VARIANCE
          S2 = S2 + C1*C3       ! SUM OF X/VARIANCE
          S3 = S3 + C2*C3       ! SUM OF X*X/VARIANCE
          S4 = S4 + C1*C2       ! SUM OF X*X*X/VARIANCE
          S5 = S5 + C2*C2       ! SUM OF X*X*X*X/VARIANCE
          V1 = V1 + Y1*C3       ! SUM OF Y/VARIANCE
          V2 = V2 + Y1*C1       ! SUM OF X*Y/VARIANCE
          V3 = V3 + Y1*C2       ! SUM OF X*X*Y/VARIANCE
10      END DO
        IF(S1.EQ.0.) THEN
          WRITE(6,*) CHAR(7),'** NO VALID POINTS'
          IERR = 1
          RETURN
        END IF
C
C NOW THE S MATRIX MUST BE INVERTED
C ACHIEVED HERE BY FINDING COFACTORS ETC.
C (IT'S ONLY A THREE BY THREE MATRIX)
C R1,R2 ... INVERSE ELEMENTS
C
        R1 = S3*S5 - S4*S4
        R2 = S3*S4 - S2*S5
        R3 = S2*S4 - S3*S3
        R4 = S1*S5 - S3*S3
        R5 = S2*S3 - S1*S4
        R6 = S1*S3 - S2*S2
C
C FORM DETERMINANT FROM THESE
C
        DET = S1*R1 + S2*R2 + S3*R3
        IF(ABS(DET).LT.1.E-10) THEN
          WRITE(*,*) CHAR(7),
     &    '** MODULUS OF DETERMINANT LESS THAN 1.E-10 **'
          WRITE(*,*) 'NO MATRIX INVERSION DONE; NO FIT'
          IERR=1
          RETURN
        END IF
C
C PARAMETERS OF FIT
C
        A1 = (R1*V1 + R2*V2 + R3*V3)/DET
        A2 = (R2*V1 + R4*V2 + R5*V3)/DET
        A3 = (R3*V1 + R5*V2 + R6*V3)/DET
C
C VARIANCES
C
        VAR(1) = R1/DET
        VAR(2) = R4/DET
        VAR(3) = R6/DET
        VAR(4) = R2/DET
        VAR(5) = R5/DET
        VAR(6) = R3/DET
        RETURN
        END
