        LOGICAL FUNCTION PARSE( STRING, MASTER )
        CHARACTER*(*) STRING, MASTER
*
*  Command parser
*  Compares all non-blank characters
*  between two strings STRING and MASTER.
*  PARSE = .TRUE. if they match.
*  Strings will match if:
*
*       (1) Both STRING and MASTER are blank
*       (2) STRING is shorter than MASTER and all letters matched
*
*  Strings will not match if:
*
*       (1) STRING is blank, MASTER is not.
*       (2) STRING has more non-blank characters than MASTER
*
        PARSE = .TRUE.
        L1 = LEN(STRING)
        M1 = LEN(MASTER)
        L2 = 1
        M2 = 1
        N = 0
        DO WHILE(L2.LE.L1 .AND. M2.LE.M1)
*
* Find non-blank characters
*
          N = N + 1
          DO WHILE(L2.LE.L1 .AND. STRING(L2:L2).EQ.' ')
            L2 = L2 + 1
          END DO
          L2 = MIN(L1, L2)
          DO WHILE(M2.LE.M1 .AND. MASTER(M2:M2).EQ.' ')
            M2 = M2 + 1
          END DO
          M2 = MIN(M1, M2)
          IF(STRING(L2:L2).NE.' ' .AND. MASTER(M2:M2).NE.' ' .AND.
     &       STRING(L2:L2).NE.MASTER(M2:M2)) THEN
            PARSE = .FALSE.
            RETURN
          ELSE IF(STRING(L2:L2).EQ.' ') THEN
            IF(N.EQ.1 .AND. MASTER(M2:M2).NE.' ') PARSE = .FALSE.
            RETURN
          ELSE IF(MASTER(M2:M2).EQ.' ' .AND. STRING(L2:L2).NE.' ') THEN
            PARSE = .FALSE.
            RETURN
          END IF
*
* Move onto next character
*
          L2 = L2 + 1
          M2 = M2 + 1
        END DO
        IF(M2.GT.M1 .AND. L2.LE.L1) THEN
          DO WHILE(L2.LE.L1 .AND. STRING(L2:L2).EQ.' ')
            L2 = L2 + 1
          END DO
          L2 = MIN(L2, L1)
          IF(STRING(L2:L2).NE.' ') PARSE = .FALSE.
        END IF
        RETURN
        END
