      REAL FUNCTION ISRED(WAVE, EBV, R)
*
* Returns extinction in mags at wavelength WAVE (in Angstroms)
* for E(B-V)=EBV in mags and a ratio of Av/E(B-V) = R (e.g. 3.1)
* Based on formulae of Howarth 1983 MN 203, 301 for WAVE > 10000/2.75
* and Seaton 1979 MN 187, 73p for WAVE < 10000/2.75
*
* The transition to the infrared formula of Howarth (at WAVE = 10000/1.83)
* is only smooth if R = 3.1
*
* Range 1000 to infinity. Returns 0 if outside valid range.
*
      IMPLICIT NONE
      REAL WAVE, EBV, R
      REAL X
*
      X = 10000./WAVE
      IF(X.GE.0 .AND. X.LT.1.83) THEN
*
* IR/opt
*
        ISRED = X*((1.86-0.48*X)*X-0.1)
      ELSE IF(X.GE.1.83 .AND. X.LT.2.75) THEN
*
* Opt
*
        ISRED = R + 2.56*(X-1.83)-0.993*(X-1.83)**2
      ELSE IF(X.GE.2.75 .AND. X.LT.3.65) THEN
*
* UV
*
        ISRED = R - 3.2 + 1.56 + 1.048*X + 1.01/((X-4.60)**2+0.28)
      ELSE IF(X.GE.3.65 .AND. X.LT.7.14) THEN
*
* UV
*
        ISRED = R - 3.2 + 2.29 + 0.848*X + 1.01/((X-4.60)**2+0.28)
      ELSE IF(X.GE.7.14 .AND. X.LT.10.) THEN
*
* UV
*
        ISRED = R - 3.2 + 16.17 - 3.20*X + 0.2975*X**2
      ELSE
        ISRED = 0.
      END IF
      ISRED = EBV*ISRED
      RETURN
      END  
      
