        SUBROUTINE EPHEMER(IAGAIN, IPRINT, YEAR, MONTH, DAY,
     $                     UT1, UT2, ORB, UTOUT, IFAIL)
C
C PASSED ARGUMENTS:
C   YEAR,MONTH,DAY INTEGER*4 DATE OF OBSERVATION.
C   IAGAIN INTEGER*4 IF NEW DATA IS TO BE INPUT (EPHEMERIS ETC.)
C                    IAGAIN SHOULD BE SET TO 1, 0 TO KEEP OLD DATA.
C   IPRINT INTEGER*4    IF ORBITAL PHASE RANGE IS REQUIRED PUT = 1,
C                       ANYTHING ELSE FOR NO PRINT.
C
C   UT1,UT2  REAL*8 UT RANGE TO BE EXAMINED.
C       UT2 IS ASSUMED TO FOLLOW UT1 AND IF IT IS LESS, "DAY"
C       WILL BE INCREASED BY ONE DURING CALCULATION.
C
C   ORB        REAL*8 ORBITAL PHASE; UT EQUIVALENT TO THIS WILL
C                     BE FOUND. (UTOUT)
C                       SET TO -1.D0 ON INPUT AND THE PROGRAM WILL IGNORE
C                       IT.
C RETURNED ARGUMENTS:
C       UTOUT REAL*8 UT OF ORBITAL PHASE REQUESTED.
C       INTEGER*4 IFAIL  0 IF ALL OK
C                        1 IF AN ERROR HAPPENED
C                        2 IF PHASE WAS OUT OF RANGE AND SET TO NEAREST
C                          LIMIT.
C
        IMPLICIT NONE
        INTEGER YEAR,MONTH,DAY,IAGAIN,IYEAR,IMONTH,IDAY
        INTEGER IFAIL,IBEF,NUM,NAMB,NCHOS,IPRINT
        DOUBLE PRECISION UT1,UT2,ORB,UTOUT,HJD1,HJD2,WORK1,WORK2
        DOUBLE PRECISION ORB1,ORB2
        CHARACTER*10 STNAM
        CHARACTER*30 SITNAM
        DOUBLE PRECISION GLON,GLAT,HEIG,RJD,HJD,TDELAY
        DOUBLE PRECISION VHELC,RA,DEC,EPOC,EPH
        COMMON/STINFO/RA,DEC,EPOC,EPH(2)
        COMMON/FRUIT7/RJD,HJD,TDELAY,VHELC
C
        IFAIL=0
        IBEF=IBEF+1
        IF(IAGAIN.EQ.0.AND.IBEF.GT.1) GOTO 260
10      IF(IAGAIN.EQ.1) IBEF=1
C
C STELLAR DATA
        CALL GSTAR(STNAM,1,0,IFAIL)
        IF(IFAIL.EQ.1 .OR. IFAIL.EQ.2) THEN
          IFAIL=1
          RETURN
        END IF
        IF(EPH(2).LE.0.D0) THEN
          IFAIL = 1
          RETURN
        END IF
C
C OBSERVATORY DATA
160     IF(IBEF.EQ.1) CALL SITEQ(SITNAM,GLAT,GLON,HEIG)
C
C CALCULATE HELIOCENTRIC JULIAN DATES OF UT LIMITS
C FIRST FOR UT1
C
260     NUM=0
        CALL FRUIT(GLON,GLAT,HEIG,EPOC,RA,DEC,YEAR,MONTH,DAY,UT1)
        HJD1=HJD
C
C IF UT2 IS LESS THAN UT1 ADD 24 HOURS TO IT, ADD 1 TO DAY ("NUM")
C IF UT2 IS GREATER THAN 24, SUBTRACT TILL BELOW 24, RECORD EXTRA
C NUMBER OF DAYS ADDED
C
        IF(UT2.LT.UT1) NUM=NUM+1
280     IF(UT2.GT.2.4D1) THEN
          NUM=NUM+1
          UT2=UT2-2.4D1
          GOTO 280
        END IF
C
C FIND NEW DATE AFTER ADDING NUM DAYS
C
        CALL DAYADD(YEAR,MONTH,DAY,NUM,IYEAR,IMONTH,IDAY)
        CALL FRUIT(GLON,GLAT,HEIG,EPOC,RA,DEC,IYEAR,IMONTH,IDAY,UT2)
        HJD2=HJD
C
C LINEAR EPHEMERIS
C
300     ORB1=(HJD1-EPH(1))/EPH(2)
        ORB2=(HJD2-EPH(1))/EPH(2)
        IF(IPRINT.EQ.1)
     $PRINT *,'Orbital phase range is ',ORB1, ' to ',ORB2
C
C IF ORB SET TO -1 THEN RETURN
C
        IF(ORB.EQ.-1.D0) RETURN
        WORK1=DBLE(INT(ORB1))+ORB
        IF(ORB1.LT.0.D0) WORK1 = WORK1 - 1.D0
        NAMB=0
C
C FIND NUMBER OF TIMES THE REQUESTED ORBITAL PHASE WILL OCCUR
C
320     IF(WORK1.LT.ORB2) THEN
          IF(WORK1.GT.ORB1) NAMB=NAMB+1
          WORK1=WORK1+1.D0
          GOTO 320
        END IF
C
C IF NONE, SET TO NEAREST LIMIT
C
        IF(NAMB.EQ.0) THEN
          PRINT *,'Phase requested ',ORB
          PRINT *,'Not found between limits; set to nearest one.'
          WORK1 = ORB1 - DBLE(INT(ORB1))
          IF(WORK1.LT.0.D0) WORK1 = WORK1 + 1.D0
          WORK2 = ORB2 - DBLE(INT(ORB2))
          IF(WORK2.LT.0.D0) WORK2 = WORK2 + 1.D0
          IFAIL = 2
          IF(ABS(ORB-WORK1).LT. ABS(ORB-WORK2)) THEN
            PRINT *,'i.e. in this case ',ORB1
            ORB=ORB1
            UTOUT=UT1
          ELSE
            PRINT *,'i.e. in this case ',ORB2
            ORB=ORB2
            UTOUT=UT2
          END IF
          RETURN
        END IF
        WORK1=DBLE(INT(ORB1))+ORB
        IF(ORB1.LT.0.D0) WORK1 = WORK1 -1.D0
        IF(WORK1.LT.ORB1) WORK1=WORK1+1.D0
        NCHOS=1
C
C IF MULTIPLE, REQUEST WHICH ONE IS TO BE USED
C
        IF(NAMB.GT.1) THEN
          PRINT *,CHAR(7),'Orbital phase occurs more than once'
340       PRINT *,'Which one do you want (1 to ',NAMB,')  ?'
          READ(5,*,ERR=340) NCHOS
          IF(NCHOS.LT.1 .OR. NCHOS.GT.NAMB) GOTO 340
        END IF
        WORK1=WORK1+DBLE(NCHOS-1)
C
C HELIOCENTRIC JULIAN DATE OF REQUESTED ORBITAL PHASE
C
        WORK2 = EPH(1) + EPH(2)*WORK1
C
C UT EQUIVALENT TO THIS TIME
C
        UTOUT=(WORK2-HJD1)/(HJD2-HJD1)*(UT2+DBLE(NUM)*2.4D1-UT1)+UT1
        RETURN
        END
