      REAL*4 FUNCTION DIFREF(WA,HE,TE,VA,Z)
      REAL*4 RI,WA,HE,TE,VA,PL,Z
C
C FUNCTION TO CALCULATE REFRACTION OF THE ATMOSPHERE IN ARC SEC (DIFREF)
C NEED TO INPUT WAVELENGTH (WA Angstroms),HEIGHT OF OBSERVATORY (HE m)
C AVERAGE TEMPERATURE (TE IN C),VAPOUR PRESSURE OF WATER (VA mm Hg)
C ZENITH DISTANCE (Z IN DEGREES)
C DEFL IS THEN THE DEFLECTION CAUSED BY THE ATMOSPHERE
C
      PL = 64.328+29498.1/(146.-1.E8/WA/WA)+255.4/(41.-1.E8/WA/WA)
      PL = PL/720.883/(1.+.003661*TE)/1.E6
      RI = 760.*EXP(-3.42E-2*HE/(273.15+TE))
      PL = RI*(1.+(1.049-.0157*TE)*1.E-6*RI)*PL
      PL = PL-(.0624-6.8E4/WA/WA)/(1.+.003661*TE)*VA/1.E6
      DIFREF = 206265.*PL*TAND(Z)
      RETURN
      END
