      SUBROUTINE PGLOBE(VELPLOT, VUNIT, Q, TX, TY, ANGLE)
*
* Plots a roche lobe.
*
* LOGICAL VELPLOT -- .TRUE. if velocity plot roche lobe, else
*                    ordinary Roche lobe, in units of RL1
* REAL VUNIT      -- Velocity scale unit = Kw+Kr
* REAL Q          -- Mass ratio = Mr/Mw = Kw/Kr
* REAL TX,TY      -- translation to add to points
* REAL ANGLE      -- clockwise rotation
*
*
      LOGICAL VELPLOT
      INTEGER NPOINT
      PARAMETER (NPOINT = 400)
      REAL XPLOT(NPOINT),YPLOT(NPOINT), PI
*
      IF( Q.LE.0. ) RETURN
      NSTEP = NPOINT/2
      PI=4.*ATAN(1.)
      XCM = Q /( 1. + Q )
*
* find Lagrangian points
*
      CALL LAG1(Q,CL1,XL1,IER)
      CALL LAG2(Q,CL2,XL2,IER)
      CALL LAG3(Q,CL3,XL3,IER)
*
* find back ends of Roche lobes
*
      IF(.NOT.VELPLOT) THEN
        BACK1=-XL1
        CALL XEND(Q,CL1,BACK1)
      ELSE
        BACK1 = XL1
      END IF
      BACK2=2.-XL1
      CALL XEND(Q,CL1,BACK2)
*
* compute Roche lobe surface
*
      XPLOT(1)=BACK1/XL1
      YPLOT(1)=0.
      DX=(BACK2-BACK1)/(XL1*REAL(NSTEP-1))
      DO I=2,NSTEP-1
        XPLOT(I) = XPLOT(I-1)+DX
        YPLOT(I) = RHO(CL1,Q,XPLOT(I)*XL1,PI/2.)/XL1
        IF(XPLOT(I).LE.1.) NBACK=I
      END DO
      XPLOT(NSTEP)=BACK2/XL1
      YPLOT(NSTEP)=0.
      IF(VELPLOT) THEN
        NBACK = NSTEP
        DO I = 1, NSTEP
          SWAP     = - VUNIT*XL1*YPLOT(I)
          YPLOT(I) =   VUNIT*(XL1*XPLOT(I)-XCM)
          XPLOT(I) = SWAP
        END DO
        DO I = 1,NSTEP
          XPLOT(I+NSTEP) = -XPLOT(I)
          YPLOT(I+NSTEP) =  YPLOT(I)
        END DO
      ELSE
        DO I = 1,NSTEP
          XPLOT(NSTEP+I) =  XPLOT(I)
          YPLOT(NSTEP+I) = -YPLOT(I)
        END DO
      END IF
*
* Apply translation and rotation
*
      RXX = COS(PI*ANGLE/180.)
      RXY = SIN(PI*ANGLE/180.)
      RYX = -RXY
      RYY = RXX
      DO I = 1, 2*NSTEP
        XP = XPLOT(I) + TX
        YP = YPLOT(I) + TY
        XPLOT(I) = RXX*XP + RXY*YP
        YPLOT(I) = RYX*XP + RYY*YP
      END DO
*
* plot Roche lobe in two halfs with dashed line
* for the primary and solid for the secondary roche lobe
*
      IF(.NOT.VELPLOT) THEN
        CALL PGSLS(2)
        CALL PGLINE( NBACK, XPLOT, YPLOT)
        CALL PGSLS(1)
        CALL PGLINE( NSTEP-NBACK+1, XPLOT(NBACK), YPLOT(NBACK))
        CALL PGSLS(2)
        CALL PGLINE( NBACK, XPLOT(NSTEP+1), YPLOT(NSTEP+1))
        CALL PGSLS(1)
        CALL PGLINE(NSTEP-NBACK+1,XPLOT(NSTEP+NBACK),YPLOT(NSTEP+NBACK))
      ELSE
        CALL PGSLS(1)
        CALL PGLINE( NSTEP, XPLOT, YPLOT)
        CALL PGLINE( NSTEP, XPLOT(NSTEP+1), YPLOT(NSTEP+1))
      END IF
*
      RETURN
      END
