      SUBROUTINE ADDTEXT
*
* Subroutine for interactively adding text to a PGPLOT diagram
*
*  Written by TRM @ RGO
* Modified by TRM @STSCI 6/10/88
*
      REAL X1, X2, Y1, Y2
      CHARACTER*3 BACK
      CHARACTER*1 REPLY, CH
      CHARACTER*80 TEXT
      CHARACTER*80 STRING
      INTEGER COLOUR
      DATA SIZE/1./
      DATA ANGLE/0./
      DATA FJUST/0.5/
      DATA LINE/1/
      DATA COLOUR/1/
*
      CALL PGQWIN(X1,X2,Y1,Y2)
      CALL PGQCH(SOLD)
      CALL PGQCI(LCOLD)
      CALL PGQLW(LOLD)
      X = (X1+X2)/2.
      Y = (Y1+Y2)/2.
      CALL PGQINF('CURSOR', BACK, LENGTH)
50    WRITE(*,'(A,$)') 'Enter text, <CR> to quit: '
      READ(*,'(A)') TEXT
      IF(TEXT.EQ.' ') THEN
        CALL PGSCH(SOLD)
        CALL PGSLW(LOLD)
        CALL PGSCI(LCOLD)
        RETURN
      END IF
      IF(BACK.EQ.'YES') THEN
        WRITE(*,'(A,$)') 'Place text with C(ursor) or
     &T(erminal) input ? [C]: '
        READ(*,'(A)') REPLY
        CALL UPPER_CASE(REPLY)
      ELSE
        WRITE(*,'(A,$)') 'Place text ? [Y]'
        READ(*,'(A)') REPLY
        CALL UPPER_CASE(REPLY)
        IF(REPLY.EQ.'N') RETURN
        REPLY = 'T'
      END IF
      IF(REPLY.EQ.'T') THEN
100     WRITE(*,*) 'Plot extends from ',X1,' to ',X2,' in X'
        WRITE(*,*) '              and ',Y1,' to ',Y2,' in Y.'
        WRITE(*,'(A,1PG10.3,A,1PG10.3,A,$)')
     &  'Enter position of text [',X,',',Y,']: '
        READ(*,'(A)') STRING
        IF(STRING.EQ.' ') THEN
          RX = X
          RY = Y
        ELSE
          READ(STRING,*,ERR=100) RX, RY
        END IF
        IF(RX.LT.X1 .OR. RX.GT.X2 .OR.
     &     RY.LT.Y1 .OR. RY.GT.Y2) GOTO 100
        X = RX
        Y = RY
      ELSE
        WRITE(*,*) 'Select position with cursor'
        CALL PGCURSE(X,Y,CH)
        WRITE(*,'(A,1PG10.3,A,1PG10.3)')
     &  ' Position selected = ',X,',',Y
      END IF
200   WRITE(*,*) 'Enter angle in degrees anti-clockwise from'
      WRITE(*,*) 'horizontal, justification (0.5 = centred,'
      WRITE(*,*) '0.0 = left, 1.0 =right justified, etc),'
      WRITE(*,*) 'character size, line width and colour.'
      WRITE(*,'(A,F6.2,A,F4.2,A,F4.2,A,I1,A,I2,A,$)')
     &'Old values [',ANGLE,',',FJUST,',',SIZE,',',LINE,',',
     &COLOUR,']: '
      READ(*,'(A)') STRING
      IF(STRING.EQ.' ') THEN
        RANGLE = ANGLE
        RFJUST = FJUST
        RSIZE = SIZE
        NLINE = LINE
        NCOLOUR = COLOUR
      ELSE
        READ(STRING,*,ERR=200) RANGLE, RFJUST, RSIZE, NLINE, NCOLOUR
      END IF
      IF(RANGLE.LT.0. .OR. RANGLE.GT.360. .OR. RFJUST.LT.0.
     &.OR. RFJUST.GT.1. .OR. RSIZE.GE.10. .OR. RSIZE.LE.0.
     &.OR. NLINE.LE.0 .OR. NLINE.GE.10 .OR. NCOLOUR.LT.0) GOTO 200
      ANGLE = RANGLE
      FJUST = RFJUST
      SIZE  = RSIZE
      LINE  = NLINE
      COLOUR = NCOLOUR
      CALL PGSCI(COLOUR)
      CALL PGSLW(LINE)
      CALL PGSCH(SIZE)
      CALL PGPTEXT(X,Y,ANGLE,FJUST,TEXT)
      GOTO 50
      END


