*WFITS
* WFITS ROOT N1 N2 NUMBER - Writes spectra to FITS files.
*
* Parameters: 
*     
*   Root   -- Root of output file names.
*   N1     -- First spectrum to write.
*   N2     -- Last spectrum to write.
*   NUMBER -- Name of integer header item for numbering output files.
*
*   Output files are names <root>.<number>.fits 
*
*   Set NUMBER to 'NONE' to use numbering 0001,0002 etc. 
*
* The output FITS file contains the following elements.
* 
* 1. Primary data array: empty
* 2. Extension HEADER: ASCII  table; header items, 8 columns with
*    Names and values in the order Char,double,int,real.
* 3. Extension DATA  : Binary table; counts,errors and fluxes resp.
*                      There are ABS(NARC) arc coeffcients stored 
*                      in header items NARC1,NARC2 ... If NARC is
*                       -ve, the scale is logarithmic.
*                      
*
* Related command: LFITS
*
*WFITS
      SUBROUTINE WRFITS(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, 
     &NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &MXREAL, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, 
     &NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, 
     &MXSDOUB, MXSINTR, MXSREAL, SLOTS, MXSLOTS, MUTE, CLOBBER, 
     &NREAD, IFAIL)

*
* Write spectra in FITS format. 
*
* History
* Written by PFLM a long time ago in a galaxy far, far away...
*
* PFLM - 10 Feb 2003
* Corrected bug whereby wrong arc coefficients were written to file.
* PFLM - 14 July 2003
* Corrected bug whereby the wrong value of number of arc coefficients 
* was written to the output file.
* Also updated declared length of STRING, which was too short.

***********************************************************************
*
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT) -- Command parameters. See below.
* >  I     NSPLIT         -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT        -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF) -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF) -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)   -- Equivalent fluxes to COUNTS
* >  I     MXBUFF         -- Size of spectrum buffers in calling routine
* >  I     MXSPEC         -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX          -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coeffs per spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
* >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
* >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double selection items.
* >  D     VSDOUB(2,MXSDOUB)  -- Values of double selection items.
* >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
* >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
* >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
* >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
* >  I     NSCHAR            -- Number of character selection items.
* >  I     NSDOUB            -- Number of double selection items.
* >  I     NSINTR            -- Number of integer selection items.
* >  I     NSREAL            -- Number of real selection items.
* >  I     MXSCHAR           -- Dimension of NMSCHAR in calling routine.
* >  I     MXSDOUB           -- Dimension of NMSDOUB in calling routine.
* >  I     MXSINTR           -- Dimension of NMSINTR in calling routine.
* >  I     MXSREAL           -- Dimension of NMSREAL in calling routine.   
* >  I     SLOTS(MXSLOTS)     -- Work array for list
* >  I     MXSLOTS            -- Size of work array
* >                              incremented and returned by routine.
* >  L     MUTE               -- Cut out terminal I/O
* >  L     CLOBBER            -- Overwrite files on output
* >  I     NREAD              -- Number last read by SPCRED
* >  I     IFAIL
*
      IMPLICIT NONE
*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL, MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, NREAD
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Search parameters, names then values.
*
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
*
* Local variables
*
      CHARACTER*64 ROOT,NITEM
      CHARACTER*100 STRING
      INTEGER SLOT1, SLOT2
      INTEGER I,J, MAXSPEC,IFAIL
      LOGICAL CLOBBER,SELECT
      INTEGER FILENO,NCOM
      CHARACTER*8 CNUMBER
      CHARACTER*100 FILENAME,MKFILENAME
      INTEGER N,FTEMP
      INTEGER STATUS,UNIT,BLOCKSIZE
      LOGICAL DEFAULT, ESAMECI, MUTE
      INTEGER TBCOL(8),ROWLEN,NTAB
      CHARACTER*6 AFORM(8)
      CHARACTER*3 AUNITS(8)*1,BUNITS(3)
      CHARACTER*6 BTYPE(3),BFORM(3)*2
      CHARACTER*5 ATYPE(8)
      CHARACTER KEYWRD*8
      CHARACTER*8 ERRTXT*32,ERRMESS*100
*
      DATA ROOT, NITEM/'molly', 'NONE'/
      DATA SLOT1, SLOT2 /1,1/
      DATA (AUNITS(I),I=1,8) /' ',' ',' ',' ',' ',' ',' ',' '/
      DATA (AFORM(I),I=1,8) /'A16','A32','A16','D20.12','A16','I16',
     +                       'A16','E16.8'/
      DATA (ATYPE(I),I=1,8) /'Name','Value','Name','Value',
     +                       'Name','Value','Name','Value'/
      DATA (BFORM(I),I=1,3)  /'1E','1E','1E'/
      DATA (BUNITS(I),I=1,3) /'ADU','ADU','MJy'/
      DATA (BTYPE(I),I=1,3)  /'Counts','Errors','Fluxes'/
      DATA CNUMBER /' '/
       
*
************************************************************************
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      NCOM = 0
      IFAIL = 0

      IF(NREAD.EQ.0) THEN
         WRITE(*,*) 'No spectra have been read yet.'
         GOTO 999
      END IF

      CALL CHAR_IN('File name root', SPLIT, NSPLIT, MXSPLIT, NCOM,
     &     DEFAULT, ROOT, IFAIL)
      CALL INTR_IN('First slot to dump', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to dump', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, SLOT2, 0, MAXSPEC, IFAIL)
      IF(SLOT2.LT.SLOT1 .OR. SLOT2.GT.MAXSPEC) THEN
         WRITE(*,*) 'Slot out of range.'
         SLOT2 = SLOT1
         GOTO 999
      END IF
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST.GT.0) THEN
            CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
         ELSE
            WRITE(*,*) 'Enter list of spectra to dump'
            CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &           NSLOTS, MXSLOTS)
         END IF
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
      IF(NSLOTS.EQ.0) GOTO 999
*     
      CALL CHAR_IN('Integer header item', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, NITEM, IFAIL)
      
*     Get free output unit.
      CALL GETLUN(UNIT,IFAIL)
      IF (IFAIL .NE. 0) THEN
         WRITE (*,*) 'Cannot open logical unit.'
         GOTO 999
      ENDIF
*     
*     Start to dump files, checking headers as we go.
*     
      FILENO = 0
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
*     
*     Apply selection criteria
*     
         IF(NPIX(SLOT).LE.0 .OR. .NOT.SELECT(SLOT, NMCHAR, NMDOUB, 
     &        NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &        NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &        MXREAL, MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &        NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, 
     &        NSINTR, NSREAL, MXSCHAR, MXSDOUB, MXSINTR, 
     &        MXSREAL)) THEN
            IF(.NOT.MUTE) WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
            GOTO 200
         END IF
         
*     
*     Create filename
*     
         IF(ESAMECI(NITEM,'NONE')) THEN
            FILENO=FILENO+1
            IF (FILENO.GT.9999) THEN
               WRITE(*,*) 'Unable to create filename'
               GOTO 999
            ENDIF
            FTEMP=FILENO
            DO J=3,0,-1
               N = FTEMP/(10**J)
               WRITE (CNUMBER(4-J:4-J),'(I1)') N
               FTEMP=FTEMP-N*(10**J)
            ENDDO 
         ELSE
            CALL HGETI(NITEM,FTEMP,SLOT,MXSPEC,
     &           NMINTR,HDINTR,NINTR,MXINTR,IFAIL)    
            IF(IFAIL.NE.0) THEN
               WRITE(*,*) 'Failed to read header item ',NITEM
               GOTO 999 
            ENDIF
            WRITE (CNUMBER,*) FTEMP
            FILENO=FILENO+1
         ENDIF
         FILENAME = MKFILENAME(ROOT,CNUMBER,'fits')
*     
*     Check if file already exists and delete it if possible.
*     
         STATUS = 0
         BLOCKSIZE=1
         
         CALL FTOPEN(UNIT,FILENAME,1,BLOCKSIZE,STATUS)
         IF (STATUS.EQ.0) THEN
            IF (CLOBBER) THEN
               CALL FTDELT(UNIT,STATUS)
               IF (STATUS.NE.0) THEN
                  WRITE(*,*)'Error deleting file ',FILENAME
                  GOTO 998
               ENDIF
            ELSE
               WRITE(*,*)'Error: file exists: ',FILENAME
               CALL FTCLOS(UNIT,STATUS)
            ENDIF
         ELSE IF (STATUS.EQ.103) THEN
            STATUS = 0
         ELSE
            STATUS=0
            CALL FTCMSG
            CALL FTDELT(UNIT,STATUS)
         ENDIF
         
*     
*     Create new empty FITS file
*     
         CALL FTINIT(UNIT,FILENAME,BLOCKSIZE,STATUS)
*     
*     Write the required header keywords
*     
         CALL FTPHPR(UNIT, .TRUE.,-64,0,0,0,1,.TRUE.,STATUS)
*     
         CALL FTPKYJ(UNIT,'FCODE',3,'Molly format code',STATUS)
         CALL FTPKYS(UNIT,'UNITS','MILLIJANSKYS','Flux units',STATUS)
*     
*     Add comments/history.
*     
*     
         CALL FTPCOM(UNIT,'Primary data array: empty',STATUS)
         CALL FTPCOM(UNIT,'Extension HEADER: ASCII  table; '//
     &        'header items, 8 columns',STATUS)
         CALL FTPCOM(UNIT,'Names and values in the order '//
     &        'char*32,dble,int,real',STATUS)
         CALL FTPCOM(UNIT,'Extension DATA  :Binary table; '//
     &        'counts,errors and fluxes resp.',STATUS)
         CALL FTPCOM(UNIT,'There are ABS(NARC) arc '//
     &        'coeffcients stored in header items', STATUS)
         CALL FTPCOM(UNIT,'ARC1,ARC2 ... If NARC is -ve,'//
     &        ' the scale is logarithmic.', STATUS)
         CALL FTPHIS(UNIT,'FITS file written by molly.',STATUS)
         
*     
*     Write header items as an ascii table. Order is Char,double,int,real.
*     
         CALL FTCRHD(UNIT,STATUS)
         CALL FTGABC(8,AFORM,1,ROWLEN,TBCOL,STATUS)
         NTAB = MAX(NCHAR(SLOT),NDOUB(SLOT),NINTR(SLOT),NREAL(SLOT))
         CALL FTPHTB(UNIT,ROWLEN,NTAB,8,ATYPE,TBCOL,AFORM,AUNITS,
     +        'HEADER',STATUS)
*     
*     Add keywords to header
*     
         CALL FTPKYJ(UNIT,'FCODE',3,'Molly format code',STATUS)
         CALL FTPKYS(UNIT,'UNITS','MILLIJANSKYS','Flux units',STATUS)
         CALL FTPKYJ(UNIT,'NCHAR',NCHAR(SLOT),
     +        'No. of character header items' ,STATUS)
         CALL FTPKYJ(UNIT,'NDOUB',NDOUB(SLOT),
     +        'No. of dble prec. header items' ,STATUS)
         CALL FTPKYJ(UNIT,'NINTR',NINTR(SLOT),
     +        'No. of integer header items' ,STATUS)
         CALL FTPKYJ(UNIT,'NREAL',NREAL(SLOT),'No. of real header items'
     +        ,STATUS)
*     
         CALL FTPCLS(UNIT,1,1,1,NCHAR(SLOT),NMCHAR(1,SLOT),STATUS)
         CALL FTPCLS(UNIT,2,1,1,NCHAR(SLOT),HDCHAR(1,SLOT),STATUS)
*     
         CALL FTPCLS(UNIT,3,1,1,NDOUB(SLOT),NMDOUB(1,SLOT),STATUS)
         CALL FTPCLD(UNIT,4,1,1,NDOUB(SLOT),HDDOUB(1,SLOT),STATUS)
*     
         CALL FTPCLS(UNIT,5,1,1,NINTR(SLOT),NMINTR(1,SLOT),STATUS)
         CALL FTPCLJ(UNIT,6,1,1,NINTR(SLOT),HDINTR(1,SLOT),STATUS)
*     
         CALL FTPCLS(UNIT,7,1,1,NREAL(SLOT),NMREAL(1,SLOT),STATUS)
         CALL FTPCLE(UNIT,8,1,1,NREAL(SLOT),HDREAL(1,SLOT),STATUS)
*     
*     Now write data as a binary table with arc coefficients in header
*     items with keywords ARC1,ARC2,ARCN.
*     
         CALL FTCRHD(UNIT,STATUS)
*     
*     
*     Add keywords to header
*     
         CALL FTPHBN(UNIT,NPIX(SLOT),3,BTYPE,BFORM,BUNITS,'DATA',0,
     &        STATUS)
         CALL FTPKYJ(UNIT,'FCODE',3,'Molly format code',STATUS)
         CALL FTPKYS(UNIT,'UNITS','MILLIJANSKYS','Flux units',STATUS)
         CALL FTPKYJ(UNIT,'NARC',NARC(SLOT),'No. arc coeffs, '//
     &        '-ve for log',STATUS)
         CALL FTPCOM(UNIT,' Wavelength units are Angstrom.',STATUS)
         DO J=1,ABS(NARC(SLOT))
            IF (J.LT.10) THEN 
               WRITE(KEYWRD,'(A3,I1)') 'ARC',J
            ELSE
               WRITE(KEYWRD,'(A3,I2)') 'ARC',J
            ENDIF
            CALL FTPKYD(UNIT,KEYWRD,ARC(J,SLOT),10,'Arc coefficient',
     &           STATUS)
         ENDDO
         CALL FTPCLE(UNIT,1,1,1,NPIX(SLOT),COUNTS(1,SLOT),STATUS)
         CALL FTPCLE(UNIT,2,1,1,NPIX(SLOT),ERRORS(1,SLOT),STATUS)
         CALL FTPCLE(UNIT,3,1,1,NPIX(SLOT),FLUX(1,SLOT),STATUS)
*     
*     Close file
*     
         CALL FTCLOS(UNIT,STATUS)
*     
*     Check for errors
*     
         IF (STATUS.GT.0) THEN
            CALL FTGERR(STATUS,ERRTXT)
            WRITE (*,*) 'Error occurred while writing FITS file.'
            WRITE (*,*) 'Error status = ',STATUS,' : ',ERRTXT
 199        CALL FTGMSG (ERRMESS)
            WRITE (*,*) ERRMESS
            IF (ERRMESS.NE.' ') GOTO 199
            IFAIL = 1
            GOTO 999
         ELSE IF(.NOT.MUTE) THEN
            CALL SL_INF(SLOT, MXSPEC, NPIX, NMCHAR, NMDOUB, NMINTR,
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB,
     &           NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, STRING,
     &           IFAIL)
            WRITE(*,*) STRING
         END IF
         
*     
 200     CONTINUE
      END DO
      
      WRITE(*,*) FILENO,' FITS files written'
      
      IFAIL = 0
 998  CLOSE(UNIT=UNIT)
 999  RETURN
      END
*     
*----------------------------------------------------------------------
*     
      
      CHARACTER *(*) FUNCTION MKFILENAME(ROOT,NUMBER,EXTEN)
*     
*     Create a filename of the form ROOT.NUMBER.EXTEN 
*     
      IMPLICIT NONE
      CHARACTER*(*) ROOT,NUMBER,EXTEN
      INTEGER NBROOT,NBNUMBER,NBEXTEN,LROOT,LNUMBER,LEXTEN
      
*     
*     Find position of first non-blank in ROOT
*     
      NBROOT = 1
      DO WHILE(NBROOT .LE. LEN(ROOT) .AND. ROOT(NBROOT:NBROOT).EQ.' ')
         NBROOT = NBROOT + 1
      END DO
      NBROOT = NBROOT - 1
*     
*     Find useful length of ROOT
*     
      IF (NBROOT .GT. 0) THEN
         LROOT = INDEX (ROOT(NBROOT:),' ')
         IF (LROOT .EQ. 0) THEN
            LROOT=LEN(ROOT(NBROOT:))
         ELSE
            LROOT=LROOT-1
         ENDIF
      ELSE
         LROOT = 0
      ENDIF
         
*     
*     Find position of first non-blank in NUMBER
*     
      DO 200 NBNUMBER=1,LEN(NUMBER)
 200     IF  (NUMBER(NBNUMBER:NBNUMBER)  .NE. ' ') GOTO 201
         NBNUMBER= 0
 201     CONTINUE
*     
*     Find useful length of NUMBER
*     
         IF (NBNUMBER .GT. 0) THEN
            LNUMBER = INDEX (NUMBER(NBNUMBER:),' ')
            IF (LNUMBER .EQ. 0) THEN
               LNUMBER=LEN(NUMBER(NBNUMBER:))
            ELSE
               LNUMBER=LNUMBER-1
            ENDIF
         ELSE
            LNUMBER = 0
         ENDIF
         
         
*     
*     Find position of first non-blank in EXTEN
*     
         DO 300 NBEXTEN=1,LEN(EXTEN)
 300        IF  (EXTEN(NBEXTEN:NBEXTEN)  .NE. ' ') GOTO 301
            NBEXTEN= 0
 301        CONTINUE
*     
*     Find useful length of EXTEN
*     
            IF (NBEXTEN .GT. 0) THEN
               LEXTEN = INDEX (EXTEN(NBEXTEN:),' ')
               IF (LEXTEN .EQ. 0) THEN
                  LEXTEN=LEN(EXTEN(NBEXTEN:))
               ELSE
                  LEXTEN=LEXTEN-1
               ENDIF
            ELSE
               LEXTEN = 0
            ENDIF
            
*     
*     Check MKFILENAME has been declared large enough to accept the full
*     file name
*     
            IF (LEN(MKFILENAME) .LT. LROOT + LNUMBER + LEXTEN + 3) THEN
            ENDIF
            
*     
*     Concatenate
*     
            IF ( (NBROOT.NE.0).AND.(NBNUMBER.NE.0).AND.
     &           (NBEXTEN.NE.0)) THEN
               MKFILENAME = ROOT(NBROOT:NBROOT+LROOT-1)//'.'//
     +              NUMBER(NBNUMBER:NBNUMBER+LNUMBER-1)//'.'//
     +              EXTEN(NBEXTEN:NBEXTEN+LEXTEN-1)
               
            ELSE IF((NBROOT.EQ.0).AND.(NBNUMBER.NE.0).AND.
     &              (NBEXTEN.NE.0)) THEN
               MKFILENAME = NUMBER(NBNUMBER:NBNUMBER+LNUMBER-1)//'.'//
     +              EXTEN(NBEXTEN:NBEXTEN+LEXTEN-1)
            ELSE IF((NBROOT.NE.0).AND.(NBNUMBER.EQ.0).AND.
     &              (NBEXTEN.NE.0)) THEN
               MKFILENAME = ROOT(NBROOT:NBROOT+LROOT-1)//'.'//
     +              EXTEN(NBEXTEN:NBEXTEN+LEXTEN-1)
            ELSE IF((NBROOT.NE.0).AND.(NBNUMBER.NE.0).AND.
     &              (NBEXTEN.EQ.0)) THEN
               MKFILENAME = ROOT(NBROOT:NBROOT+LROOT-1)//'.'//
     +              NUMBER(NBNUMBER:NBNUMBER+LNUMBER-1)
            ELSE IF((NBROOT.EQ.0).AND.(NBNUMBER.NE.0).AND.
     &              (NBEXTEN.EQ.0)) THEN
               MKFILENAME = NUMBER(NBNUMBER:NBNUMBER+LNUMBER-1)
            ELSE IF((NBROOT.EQ.0).AND.(NBNUMBER.EQ.0).AND.
     &              (NBEXTEN.NE.0)) THEN
               MKFILENAME = EXTEN(NBEXTEN:NBEXTEN+LEXTEN-1)
            ELSE IF((NBROOT.NE.0).AND.(NBNUMBER.EQ.0).AND.
     &              (NBEXTEN.EQ.0)) THEN
               MKFILENAME = ROOT(NBROOT:NBROOT+LROOT-1)
            ELSE
               MKFILENAME =  ' '
            ENDIF
*     
            END






