      SUBROUTINE RVMSH(LUNIT, FCODE, UNITS, NPIX, NARC, NCHAR, 
     &NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &HDREAL, IFAIL)
*
* Written by TRM 
*
* Reads a spectrum header in TRM format. 
* It assumes that the first header found is the one you want. 
*
* See WTHEAD for definition of TRM format 
*
      IMPLICIT NONE
      INTEGER  IFAIL
      INTEGER MXCHAR, MXDOUB, MXINTR, MXREAL
      INTEGER LUNIT, FCODE, NPIX, NARC
      INTEGER NCHAR, NDOUB, NINTR, NREAL
      CHARACTER*16     UNITS
      CHARACTER*(*)    NMCHAR(MXCHAR)
      CHARACTER*(*)    NMDOUB(MXDOUB)
      CHARACTER*(*)    NMINTR(MXINTR)
      CHARACTER*(*)    NMREAL(MXREAL)
      CHARACTER*(*)    HDCHAR(MXCHAR)
      DOUBLE PRECISION HDDOUB(MXDOUB)
      INTEGER          HDINTR(MXINTR)
      REAL             HDREAL(MXREAL)
*
      LOGICAL SEG
      INTEGER RECL, NBYTE
      COMMON/REC_LEN/RECL, NBYTE
*
* Read first line of essential information
* In this case need to skip bytes at start of record
* (2 bytes for sequential VMS files). Check number
* of bytes to be read against RECL to see if segmentation
* will occur.
*
      IFAIL = 0
      SEG = .FALSE.
      CALL SKIPBYTES(LUNIT,2,IFAIL)               
      SEG = 7*4+16 .GT. RECL
      NBYTE = 0
*
* Now read in parameters
*
      CALL READINTR(LUNIT,1,FCODE,SEG,IFAIL)
      CALL READCHAR(LUNIT,1,16,UNITS,SEG,IFAIL)
      CALL READINTR(LUNIT,1,NPIX,SEG,IFAIL)
      CALL READINTR(LUNIT,1,NARC,SEG,IFAIL)
      CALL READINTR(LUNIT,1,NCHAR,SEG,IFAIL)
      CALL READINTR(LUNIT,1,NDOUB,SEG,IFAIL)
      CALL READINTR(LUNIT,1,NINTR,SEG,IFAIL)
      CALL READINTR(LUNIT,1,NREAL,SEG,IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(FCODE.LT.1 .OR. FCODE.GT.5 .OR. NPIX.LT.1) THEN
        IFAIL = -10
        GOTO 999
      END IF
      IF(NCHAR.GT.MXCHAR .OR. NDOUB.GT.MXDOUB .OR.
     &   NINTR.GT.MXINTR .OR. NREAL.GT.MXREAL) THEN
        write(*,*) fcode,units,npix,narc,nchar,ndoub,nintr,nreal
        WRITE(*,*) ' RVMSH: Too many header parameters'
        WRITE(*,*) 'CDIR',NCHAR,NDOUB,NINTR,NREAL
        IFAIL = 1000
        RETURN
      END IF
*
* Read names of header parameters. Computation of number
* of bytes needed in case records are segmented. If so
* flag set.
*
      CALL SKIPBYTES(LUNIT,2,IFAIL)
      SEG = 16*(NCHAR+NDOUB+NINTR+NREAL).GT.RECL
      NBYTE = 0
      CALL READCHAR(LUNIT,NCHAR,(*),NMCHAR,SEG,IFAIL)
      CALL READCHAR(LUNIT,NDOUB,(*),NMDOUB,SEG,IFAIL)
      CALL READCHAR(LUNIT,NINTR,(*),NMINTR,SEG,IFAIL)
      CALL READCHAR(LUNIT,NREAL,(*),NMREAL,SEG,IFAIL)
*
* Read values of header parameters
*
      CALL SKIPBYTES(LUNIT,2,IFAIL)
      SEG = 32*NCHAR+8*NDOUB+4*(NINTR+NREAL).GT.RECL
      NBYTE = 0
      CALL READCHAR(LUNIT,NCHAR,(*),HDCHAR,SEG,IFAIL)
      CALL READDOUB(LUNIT,NDOUB,HDDOUB,SEG,IFAIL)
      CALL READINTR(LUNIT,NINTR,HDINTR,SEG,IFAIL)
      CALL READREAL(LUNIT,NREAL,HDREAL,SEG,IFAIL)
999   CONTINUE
      IF(IFAIL.LT.0) THEN
        WRITE(*,*) 'End of MOLLY file on trying to read headers'
      ELSE IF(IFAIL.GT.0) THEN
        WRITE(*,*) 'Error reading MOLLY headers'
      END IF
      RETURN
      END

      SUBROUTINE RVMSD(LUNIT, COUNTS, ERRORS, FLUX, ARC, FCODE, 
     &NPIX, NARC, IFAIL)
*
* Written by TRM 28/7/91
*
* Reads a spectrum in TRM format. 
* It assumes that the file is positioned on the data.
*
* Inputs
*
* I*4 FCODE -- Format code obtained from header.
* I*4 NPIX  -- Number of pixels obtained from header.
* I*4 NARC  -- Number of arc coefficients 
*
* See WTHEAD for definition of TRM format.
*
*
      IMPLICIT NONE
      INTEGER IFAIL, LUNIT, FCODE, NPIX, NARC
      REAL COUNTS(NPIX), ERRORS(NPIX), FLUX(NPIX)
      DOUBLE PRECISION ARC(1)
      LOGICAL SEG
      INTEGER RECL, NBYTE
      COMMON/REC_LEN/RECL, NBYTE
*
* Read data 
*
      IFAIL = 0
      CALL SKIPBYTES(LUNIT,2,IFAIL)
      SEG = 8*ABS(NARC).GT.RECL
      NBYTE = 0
      CALL READDOUB(LUNIT,ABS(NARC),ARC,SEG,IFAIL)
      CALL SKIPBYTES(LUNIT,2,IFAIL)
      NBYTE = 0
      IF(FCODE.EQ.1) THEN
        SEG = 4*NPIX.GT.RECL
        CALL READREAL(LUNIT,NPIX,COUNTS,SEG,IFAIL)
      ELSE IF(FCODE.EQ.2) THEN
        SEG = 2*4*NPIX.GT.RECL
        CALL READREAL(LUNIT,NPIX,COUNTS,SEG,IFAIL)
        CALL READREAL(LUNIT,NPIX,ERRORS,SEG,IFAIL)
      ELSE IF(FCODE.EQ.3) THEN
        SEG = 3*4*NPIX.GT.RECL
        CALL READREAL(LUNIT,NPIX,COUNTS,SEG,IFAIL)
        CALL READREAL(LUNIT,NPIX,ERRORS,SEG,IFAIL)
        CALL READREAL(LUNIT,NPIX,FLUX,SEG,IFAIL)
      ELSE IF(FCODE.EQ.4) THEN
        SEG = 4*NPIX.GT.RECL
        CALL READREAL(LUNIT,NPIX,FLUX,SEG,IFAIL)
      ELSE IF(FCODE.EQ.5) THEN
        SEG = 2*4*NPIX.GT.RECL
        CALL READREAL(LUNIT,NPIX,FLUX,SEG,IFAIL)
        CALL READREAL(LUNIT,NPIX,ERRORS,SEG,IFAIL)
      ELSE 
        WRITE(*,*) 'Invalid FCODE in RTDATA'
        IFAIL = 1000
        RETURN
      END IF
999   CONTINUE
      IF(IFAIL.LT.0) THEN
        WRITE(*,*) 'End of MOLLY file on trying to read data'
      ELSE IF(IFAIL.GT.0) THEN
        WRITE(*,*) 'Error reading MOLLY data'
      END IF
      RETURN
      END
c------------------------------------------------------
      SUBROUTINE READDOUB(LUNIT,NUM,DAR,SEGMNT,IFAIL)
*
* Reads NUM DOUBLE PRECISION numbers from LUNIT
* into array DAR(NUM)
*
*
* Passed by common
*
* RECL  -- Default record length of segments
* NBYTE -- If segmented records (SEGMNT=.TRUE.) we must keep track 
*          of how many bytes have been read in order to know when
*          to skip. NBYTE must be set to 0 at the start of every
*          new record in this case.
*
      INTEGER LUNIT,J,K,NUM, IFAIL
      DOUBLE PRECISION DAR(*),DVAL,DR,DI
      CHARACTER B(8),BR(4),BI(4)
      REAL R
      INTEGER I, EXPT
      EQUIVALENCE (R, BR(1))
      EQUIVALENCE (I, BI(1))
      EQUIVALENCE(B(1),DVAL)
      LOGICAL SEGMNT
      INTEGER RECL, NBYTE
      COMMON/REC_LEN/RECL, NBYTE
*
      IF(IFAIL.NE.0) RETURN
      DO K = 1,NUM
        DO J = 1,8
          IF(SEGMNT .AND. NBYTE.EQ.RECL) THEN
            NBYTE = 0
            CALL SKIPBYTES(LUNIT,2,IFAIL)
            IF(IFAIL.NE.0) RETURN
          END IF                   
          CALL FGETC(LUNIT,B(J),IFAIL)
          IF(IFAIL.NE.0) RETURN
          NBYTE = NBYTE + 1
        END DO
*
* Compute REAL*4 part. Possibility of an overflow here if
* value is within 4 of upper limit due to different position
* of radix point in VMS and ULTRIX storage. Bytes swapped
* as if for reals here.
*
        BR(1) = B(3)
        BR(2) = B(4)
        BR(3) = B(1)
        BR(4) = B(2)
        DR = R
*
* Compute exponent. Need to first equate bytes to integers
* to prevent arithematic being carried out in terms of bytes
* VMS D-floating format exponent stored as excess 128 binary
* number. (-127 to 127 mapped to 1 to 255. 0 has no meaning)
* Exponent contained in second byte excluding first bit which
* is a sign bit for the whole number, plus the leading bit of 
* second byte whose value can be determined by checking the
* sign (- = 1)
*
        I1 = B(1)
        I2 = B(2)
        IF(I2.LT.0) I2 = I2 + 128
        EXPT = 2*I2 - 128
        IF(I1.LT.0) EXPT = EXPT + 1
*
* Remaining 4 bytes are a continuation of the fractional
* part. VMS stores them in a strange order so swap them
* around and set equivalent integer. Then equate to
* a double precision number so that it can be made positive
* since the integer is interpreted as 2's complement otherwise.
* Add into the real part with correct offset. Since REAL*8 are
* stored by default as G-floating whereas VMS uses D-floating
* there is no problem with overflows here but some precision is
* lost.
*
        BI(1) = B(7)
        BI(2) = B(8)
        BI(3) = B(5)
        BI(4) = B(6)
        DI = I
        IF(I.LT.0) DI = DI + 2.D0**32
        IF(B(2).GT.0) THEN
          DAR(K) = (DR + DI*2.D0**(EXPT-54))/4.
        ELSE
          DAR(K) = (DR - DI*2.D0**(EXPT-54))/4.
        END IF
      END DO
      RETURN
      END
c------------------------------------------------------
      SUBROUTINE READREAL(LUNIT,NUM,RAR,SEGMNT,IFAIL)
*
* Reads NUM REAL*4 numbers from LUNIT into RAR(NUM),
* a real array. Byte swapping needed here to account
* for difference between the way VMS and ULTRIX store
* REAL*4 numbers
*
      INTEGER LUNIT,J,K,NUM,IFAIL
      REAL RAR(*),RVAL
      CHARACTER B(4),B1(4)
      EQUIVALENCE(RVAL,B(1))
      LOGICAL SEGMNT
      INTEGER RECL, NBYTE
      COMMON/REC_LEN/RECL, NBYTE
*
      IF(IFAIL.NE.0) RETURN
      DO K = 1,NUM
        DO J = 1,4
          IF(SEGMNT .AND. NBYTE.EQ.RECL) THEN
            NBYTE = 0
            CALL SKIPBYTES(LUNIT,2,IFAIL)
            IF(IFAIL.NE.0) RETURN
          END IF                   
          CALL FGETC(LUNIT,B1(J),IFAIL)
          IF(IFAIL.NE.0) RETURN
          NBYTE = NBYTE + 1
        END DO
        B(1) = B1(3)
        B(2) = B1(4)
        B(3) = B1(1)
        B(4) = B1(2)
        RAR(K) = RVAL/4.
      END DO
      RETURN
      END
c------------------------------------------------------
      SUBROUTINE READINTR(LUNIT,NUM,IAR,SEGMNT,IFAIL)
*
* Read NUM integers from LUNIT into the integer
* array IAR. No byte swapping needed for VMS to
* ULTRIX
*
      INTEGER LUNIT,J,K,IVAL,NUM,IAR(*),IFAIL
      CHARACTER B(4)
      EQUIVALENCE (IVAL,B(1))
      LOGICAL SEGMNT
      INTEGER RECL, NBYTE
      COMMON/REC_LEN/RECL, NBYTE
*
      IF(IFAIL.NE.0) RETURN
      DO K = 1,NUM
        DO J = 1,4
          IF(SEGMNT .AND. NBYTE.EQ.RECL) THEN
            NBYTE = 0
            CALL SKIPBYTES(LUNIT,2,IFAIL)
            IF(IFAIL.NE.0) RETURN
          END IF                   
          CALL FGETC(LUNIT,B(J),IFAIL)
          IF(IFAIL.NE.0) RETURN
          NBYTE = NBYTE + 1
        END DO
        IAR(K) = IVAL
      END DO
      IFAIL = 0
      RETURN
      END
c------------------------------------------------------
      SUBROUTINE READCHAR(LUNIT,NUM,LEN,STRING,SEGMNT,IFAIL)
*
* Read NUM strings of LEN characters from LUNIT into the character
* string array STRING(NUM)
*
      INTEGER LUNIT,J,K,LEN,IFAIL
      CHARACTER*(*) STRING(*)
      CHARACTER*1 C
      CHARACTER B
      EQUIVALENCE (C,B)
      LOGICAL SEGMNT
      INTEGER RECL, NBYTE
      COMMON/REC_LEN/RECL, NBYTE
*
      IF(IFAIL.NE.0) RETURN
      DO K = 1, NUM
        DO J = 1,LEN
          IF(SEGMNT .AND. NBYTE.EQ.RECL) THEN
            NBYTE = 0
            CALL SKIPBYTES(LUNIT,2,IFAIL)
            IF(IFAIL.NE.0) RETURN
          END IF
          CALL FGETC(LUNIT,B,IFAIL) 
          IF(IFAIL.NE.0) RETURN
          STRING(K)(J:J) = C
          NBYTE = NBYTE + 1
        END DO
      END DO
      IFAIL = 0
      RETURN
      END
c-------------------------------------------------------
      SUBROUTINE SKIPBYTES(LUNIT,NBYTES,IFAIL)
*
* Skips NBYTES bytes from LUNIT by reading into dummy byte
*
      INTEGER LUNIT, K, IFAIL, NBYTES
      CHARACTER B
*
      IF(IFAIL.NE.0) RETURN
      DO K = 1, NBYTES
        CALL FGETC(LUNIT,B,IFAIL)
        IF(IFAIL.NE.0) RETURN
      END DO
      IFAIL = 0
      RETURN
      END
