      SUBROUTINE TEMIN( RLO, RATIO, RHI, TOL, DATA, SIG, MASK, 
     &WSPEC, NDATA, WORK1, WORK2, WORK3, NFL, NFS, IFAIL)
*
*  Tries to minimise the scatter in regions defined by the logical
*  array MASK when the array DATA is corrected by a telluric spectrum
*  WSPEC (on the same wavelength scale). The telluric spectrum is
*  adjusted by raising it to the power RATIO and it is this value which
*  is returned for the best fit.
*
*
* R RLO, RATIO, RHI - Lowest, best guess, highest values.
* R TOL           --- Fractional precision in minimum.
* R DATA(NDATA)   --- Data values
* R SIG(NDATA)    --- 1-sigma uncertainties.
* L MASK(NDATA)   --- TRUE if to be included
* R WSPEC(NDATA)  --- Array of correction factors between 0 and 1
* I NDATA         --- Number of pixels
* R WORK1(NDATA)  --- Work space
* R WORK2(NDATA)  --- Work space
* R WORK3(NDATA)  --- Work space
* I NFL           --- Width of largescale filter to be used
* I NFS           --- Width of shortscale filter to be used
* I IFAIL         --- 0 if all ok
*
* 
      IMPLICIT NONE
      INTEGER NDATA, NFL, NFS
      REAL DATA(NDATA), SIG(NDATA), WSPEC(NDATA)
      REAL WORK1(NDATA), WORK2(NDATA), WORK3(NDATA)
      REAL RLO, RATIO, RHI, TOL
      LOGICAL MASK(NDATA)
      DOUBLE PRECISION TSCAT
      INTEGER ITMAX, ITER, IFAIL
      REAL CGOLD, ZEPS, A, B, V, W, X, XM, TOL1, TOL2
      REAL E, R, Q, P, D, U, ETEMP
      PARAMETER (ITMAX=100,CGOLD=.3819660,ZEPS=1.0E-10)
      DOUBLE PRECISION FX, FV, FW, FU
*
      A=MIN(RLO,RHI)
      B=MAX(RLO,RHI)
      V=RATIO
      W=V
      X=V
      E=0.
      FX=TSCAT(X, DATA, SIG, MASK, WSPEC, NDATA, 
     &   WORK1, WORK2, WORK3, NFL, NFS)
      FV=FX
      FW=FX
      DO ITER=1,ITMAX
        XM=0.5*(A+B)
        TOL1=TOL*ABS(X)+ZEPS
        TOL2=2.*TOL1
        IF(ABS(X-XM).LE.(TOL2-.5*(B-A))) GOTO 3
        IF(ABS(E).GT.TOL1) THEN
           R=REAL((X-W)*(FX-FV))
           Q=REAL((X-V)*(FX-FW))
           P=(X-V)*Q-(X-W)*R
           Q=2.*(Q-R)
           IF(Q.GT.0.) P=-P
           Q=ABS(Q)
           ETEMP=E
           E=D
           IF(ABS(P).GE.ABS(.5*Q*ETEMP).OR.P.LE.Q*(A-X).OR. 
     *          P.GE.Q*(B-X)) GOTO 1
           D=P/Q
           U=X+D
           IF(U-A.LT.TOL2 .OR. B-U.LT.TOL2) D=SIGN(TOL1,XM-X)
           GOTO 2
        END IF
 1      IF(X.GE.XM) THEN
           E=A-X
        ELSE
           E=B-X
        END IF
        D=CGOLD*E
 2      IF(ABS(D).GE.TOL1) THEN
           U=X+D
        ELSE
           U=X+SIGN(TOL1,D)
        END IF
        FU=TSCAT(U, DATA, SIG, MASK, WSPEC, NDATA, 
     &       WORK1, WORK2, WORK3, NFL, NFS)
        IF(FU.LE.FX) THEN
           IF(U.GE.X) THEN
              A=X
           ELSE
              B=X
           END IF
           V=W
           FV=FW
           W=X
           FW=FX
           X=U
           FX=FU
        ELSE
           IF(U.LT.X) THEN
              A=U
           ELSE
              B=U
           ENDIF
           IF(FU.LE.FW .OR. W.EQ.X) THEN
              V=W
              FV=FW
              W=U
              FW=FU
           ELSE IF(FU.LE.FV .OR. V.EQ.X .OR. V.EQ.W) THEN
              V=U
              FV=FU
           END IF
        END IF
      END DO
      WRITE(*,*) 'TEMIN exceed maximum iterations.'
      IFAIL = 1
      WRITE(*,*) 'Reached ',X,' but will retain ',RATIO
      RETURN
 3    IFAIL = 0
      RATIO = X
      RETURN
      END


      DOUBLE PRECISION FUNCTION TSCAT(RATIO, DATA, SIG, MASK, 
     &WSPEC, NDATA, WORK1, WORK2, WORK3, NFL, NFS)
*
* Evaluates scatter for particular value of RATIO
*
      IMPLICIT NONE
      INTEGER NDATA, NFL, NFS
      REAL DATA(NDATA), SIG(NDATA), WSPEC(NDATA)
      REAL WORK1(NDATA), WORK2(NDATA), WORK3(NDATA)
      REAL RATIO
      LOGICAL MASK(NDATA)
      INTEGER I, NF, NL, IFAIL
*
      DO I = 1, NDATA
         WORK1(I) = DATA(I)/WSPEC(I)**RATIO
         WORK3(I) = (SIG(I)/WSPEC(I)**RATIO)**2
      END DO
      CALL REPLACE(WORK1, SIG, MASK, .FALSE., NDATA, NF, NL, IFAIL)
      
      DO I = 1, NDATA
         WORK2(I) = WORK1(I)
      END DO

      CALL BOXFILT(NDATA, WORK1, NFL)
      CALL BOXFILT(NDATA, WORK2, NFS)
      CALL BOXFILT(NDATA, WORK3, NFS)
      TSCAT = 0.D0
      DO I = 1, NDATA
         IF(MASK(I) .AND. SIG(I).GT.0.) THEN
            
            TSCAT  = TSCAT + ((WORK2(I)-WORK1(I))/WORK1(I))**2
     &           -WORK3(I)/WORK1(I)**2/REAL(NFS)
         END IF
      END DO
      RETURN
      END
      



