CMASK
C MASK N1 N2 N3 MASK SET -- Mask spectra
C
C Parameters: 
C     
C  N1  -- Slot number of first spectrum to mask
C  N2  -- Slot number of last spectrum to mask.
C  N3  -- Slot number of first output spectrum 
C  MASK-- Yes to mask, No to unmask. 
C  SET -- Yes to set mask.
C
C MASK applies a mask by making masked pixels have negative error
C bars. They will then be ignored by fitting routines and for plotting.
C Selection criteria are applied. 
C
C Related routine: EMUL
CMASK
CEMUL
C EMUL N1 N2 N3 FAC SET -- Multiplies error bars on spectra
C
C Parameters: 
C     
C  N1  -- Slot number of first spectrum to mask
C  N2  -- Slot number of last spectrum to mask.
C  N3  -- Slot number of first output spectrum 
C  FAC -- Yes to mask, No to unmask. 
C  SET -- Yes to set mask.
C
C EMUL multiplies error bars by a constant specified by the user.
C Selection criteria are applied. 
C
C Related routine: MASK
CEMUL
      SUBROUTINE SPCMSK(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &     VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &     MXSINTR, MXSREAL, WORK1, WORK2, WORK3, MASK, MXWORK, SLOTS, 
     &     MXSLOTS, METHOD, IFAIL)
C     
C     Applies mask to spectra
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
C     >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
C     >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
C     >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
C     >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
C     >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
C     >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
C     >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
C     >  I     NSCHAR             -- Number of character selection items.
C     >  I     NSDOUB             -- Number of double precsion selection items.
C     >  I     NSINTR             -- Number of integer selection items.
C     >  I     NSREAL             -- Number of real selection items.
C     >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
C     >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
C     >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
C     >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
C     >  R     WORK1(MXWORK)      -- Work array
C     >  R     WORK2(MXWORK)      -- Work array
C     >  R     WORK3(MXWORK)      -- Work array
C     >  L     MASK(MXWORK)       -- Mask array
C     >  I     MXWORK             -- Size of work array
C     >  I     SLOTS(MXSLOTS)       -- Work array for list of spectra
C     >  I     MXSLOTS             -- Maximum number of entries
C     C     METHOD             -- 'M' for masking, 'E' for multiplying
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE
C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL   FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Search parameters
C     
      INTEGER MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
C     
C     Search parameters, names then values.
C     
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
C     
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Mask arrays
C     
      INTEGER MXMASK
      PARAMETER (MXMASK=50)
      INTEGER NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
      CHARACTER*(*) METHOD
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
      INTEGER MXWORK
      REAL WORK1(MXWORK), WORK2(MXWORK)
      REAL WORK3(MXWORK)
      LOGICAL MASK(MXWORK)
C     
C     Local variables
C     
      INTEGER I, J, K, NV, SLOT1, SLOT2, SLOT3, IFAIL
      INTEGER MAXSPEC, NCOM, LENSTR
      REAL FAC
      LOGICAL SELECT, SAMECI, DEFAULT, NORMAL
      DOUBLE PRECISION VEARTH
      CHARACTER*100 STRING
      CHARACTER*3 SET, WHAT
C     
      SAVE SLOT1, SLOT2, SLOT3, NPMASK, NWMASK, NVMASK
      SAVE NLIST, WHAT, FAC
      DATA SLOT1, SLOT2, SLOT3/1,1,2/
      DATA NPMASK, NWMASK, NVMASK, NLIST/0,0,0,0/
      DATA WHAT/'y'/
      DATA FAC/1./
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
      CALL INTR_IN('First slot to mask', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to mask', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST.GT.0) THEN
            CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
         ELSE
            WRITE(*,*) 'Enter list of spectra to 	mask'
            CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &           NSLOTS, MXSLOTS)
         END IF
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
C     
C     Count number of valid spectra
C     
      NV = 0      
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF( NPIX(SLOT).GT.0 .AND. ((NVMASK.EQ.0 .AND. NWMASK.EQ.0)
     &        .OR. NARC(SLOT).GT.0) .AND. SELECT(SLOT, NMCHAR, NMDOUB, 
     &        NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, 
     &        NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &        MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, 
     &        VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &        NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) NV = NV + 1
      END DO
      SLOT3 = MIN(SLOT3, MAXSPEC-NV+1)
      CALL INTR_IN('First output slot', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, SLOT3, 1, MAXSPEC-NV+1, IFAIL)
C     
      IF(SAMECI(METHOD,'M')) THEN
         CALL CHAR_IN('Mask (else unmask)?', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, WHAT, IFAIL)
         IF(SAMECI(WHAT,'Y')) THEN
            NORMAL = .TRUE.
         ELSE IF(SAMECI(WHAT,'N')) THEN
            NORMAL = .FALSE.
         ELSE
            WRITE(*,*) 'Must answer Y or N'
            GOTO 999
         END IF
      ELSE IF(SAMECI(METHOD,'E')) THEN
         CALL REAL_IN('Multiplier', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, FAC, -1.E20, 1.E20, IFAIL)
      ELSE
         WRITE(*,*) 'Invalid method = ',METHOD
         GOTO 999
      END IF
C     
C     Does a mask have to be set
C     
      CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
      CALL CHAR_IN('Set mask?', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &     DEFAULT, SET, IFAIL)
      IF(SAMECI(SET,'YES')) THEN
         IF(SAMECI(METHOD,'M')) THEN
            IF(NORMAL) THEN
               WRITE(*,*) 'Define regions to MASK'
            ELSE
               WRITE(*,*) 'Define regions to UNMASK'
            END IF
         ELSE
            WRITE(*,*) 'Mask regions to be altered'
         END IF
         CALL MASKIT(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &        NVMASK, MXMASK, COUNTS, ERRORS, FLUX, MXBUFF, MAXPX,
     &        NPIX, MXSPEC, NARC, ARC, MXARC, NMCHAR, NMDOUB, NMINTR,
     &        NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB,
     &        NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, WORK1, 
     &        WORK2, WORK3, MXWORK, MASK)
      END IF
      CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
      IF(SAMECI(SET,'YES')) THEN
         WRITE(*,*) 'Must mask something'
         GOTO 999
      END IF
C     
C     Now apply mask. Loop through spectra
C     
      NV = 0      
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF( NPIX(SLOT).LE.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' empty; skipped.'
         ELSE IF(NARC(SLOT).EQ.0 .AND. (NVMASK.GT.0 .OR.
     &           NWMASK.GT.0)) THEN
            WRITE(*,*) 'Slot ',SLOT,' has no wavelength scale'
            WRITE(*,*) 'to interpret mask and will be skipped'
         ELSE IF(.NOT.SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, 
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, 
     &           NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &           MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, 
     &           VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &           NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN
            WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
         ELSE
            IF(NARC(SLOT).NE.0) THEN
C     
C     Search for double precision header item Vearth. If not
C     found, assume = 0
C     
               CALL HGETD('Vearth', VEARTH, SLOT, MXSPEC, 
     &              NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
               IFAIL = 0
            END IF
C     
            NV = NV + 1
            K = SLOT3 + NV - 1
C     
C     Get mask
C     
            CALL APPMASK(MASK,NPIX(SLOT),ARC(1,SLOT),NARC(SLOT),
     &           MXARC,PMASK,NPMASK,WMASK,NWMASK,VMASK,NVMASK,MXMASK,
     &           .TRUE.,VEARTH,IFAIL)
C     
C     Output results
C     
            DO J = 1, NPIX(SLOT)
               FLUX(J,K)   = FLUX(J,SLOT)
               COUNTS(J,K) = COUNTS(J,SLOT)
               IF(SAMECI(METHOD,'M')) THEN
                  IF(NORMAL .AND. MASK(J)) THEN
                     ERRORS(J,K) = - ABS(ERRORS(J,SLOT))
                  ELSE IF(.NOT.NORMAL .AND. MASK(J)) THEN
                     ERRORS(J,K) =   ABS(ERRORS(J,SLOT))
                  ELSE
                     ERRORS(J,K) =   ERRORS(J,SLOT)
                  END IF
               ELSE IF(SAMECI(METHOD,'E')) THEN
                  IF(MASK(J)) THEN
                     ERRORS(J,K) =  FAC*ERRORS(J,SLOT)
                  ELSE
                     ERRORS(J,K) =   ERRORS(J,SLOT)
                  END IF
               END IF
            END DO
C     
C     Set headers equal to those of input spectrum 
C     
            CALL SET_HEAD(K, SLOT, MXSPEC, NPIX, ARC, NARC, MXARC, 
     &           NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &           HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &           MXDOUB, MXINTR, MXREAL, IFAIL)
            CALL SL_INF(K, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &           NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &           NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &           MXINTR, MXREAL, STRING, IFAIL)
            WRITE(*,*) STRING(:LENSTR(STRING))
         END IF
      END DO
 999  RETURN
      END
