*FAKE
* FAKE N W1 W2 NBIN TYPE CONT FILE -- Fakes up a spectrum 
*
* The spectrum has a constant continuum and gaussian lines. No noise
* is added.
*
* Parameters:
*
*      N    -- Slot number to store fake spectrum in.
*      W1   -- Start wavelength
*      W2   -- End wavelength
*      NBIN -- Number of bins
*      TYPE -- V for velocity scale, W for wavelength
*      CONT -- Continuum level
*      FILE -- File of data for fake lines with columns as follows:
*
*              WAVE   -- Wavelength of line, A
*              WIDTH  -- FWHM width of line
*              WIDTYP -- Type of width: 
*                          1 for km/s
*                          2 for A
*              STR    -- Strength of line
*              STRTYP -- Type of strength: 
*                          1 for additive emission  STR*EXP( )
*                          2 for multiplicative abs EXP(-STR*EXP( ))
*
*FAKE
      SUBROUTINE SPCFAK(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &WORK1, MXWORK, IFAIL)
*
* Generates fake spectrum
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
*    R     WORK1(MXWORK)
*    I     MXWORK
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE

*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Slot lists
*
      INTEGER SLOT
*
      INTEGER MXWORK
      REAL WORK1(MXWORK)
*
* Local variables
*
      INTEGER I,  NCOM
      DOUBLE PRECISION  ANGST
      DOUBLE PRECISION W
      CHARACTER*64 FILE
      INTEGER IFAIL
      INTEGER  MAXSPEC
      REAL VLIGHT,  WIDTH
      REAL  Z, FFAC
      REAL WAVE, WAVE1, WAVE2, EFAC, CONT, STR
      DOUBLE PRECISION AOUT(2)
      INTEGER NAOUT, NLINE, NBIN, WIDTYP, STRTYP
      CHARACTER*5 TYPE
      LOGICAL ESAMECI, DEFAULT
*
* Functions
*
      REAL CGS
C
C     Common from SINCF
C
      DATA WAVE1, WAVE2, CONT/5000., 6000., 1./
      DATA SLOT, NBIN/1, 1000/
      DATA FILE, TYPE/'lines','V'/
C
      FFAC = 4.*LOG(2.)
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
      CALL INTR_IN('Slot to store fake spectrum', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT, 1, MAXSPEC, IFAIL)
      CALL REAL_IN('Start wavelength (A)', SPLIT, NSPLIT,
     &     MXSPLIT, NCOM, DEFAULT, WAVE1, 1.E-10, 1.E10, IFAIL)
      CALL REAL_IN('End wavelength (A)', SPLIT, NSPLIT,
     &     MXSPLIT, NCOM, DEFAULT, WAVE2, WAVE1, 1.E10, IFAIL)
      CALL INTR_IN('Number of pixels', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, NBIN, 1, MAXPX, IFAIL)
      CALL CHAR_IN('Uniform in V(elocity) or W(avelength)?',
     &     SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, TYPE, IFAIL)
      IF(IFAIL.NE.0) GOTO 999     
      IF(ESAMECI(TYPE,'V')) THEN
         AOUT(2) = LOG(WAVE2/WAVE1)*REAL(NBIN)/REAL(NBIN-1)
         AOUT(1) = LOG(WAVE1) - AOUT(2)/REAL(NBIN)
         NAOUT = -2
      ELSE IF(ESAMECI(TYPE,'W')) THEN
         AOUT(2) = (WAVE2-WAVE1)*REAL(NBIN)/REAL(NBIN-1)
         AOUT(1) = WAVE1 - AOUT(2)/REAL(NBIN)
         NAOUT = 2
      ELSE
         WRITE(*,*) 'Must answer either V or W'
         GOTO 999
      END IF
      CALL REAL_IN('Continuum level (mJy)', SPLIT, NSPLIT,
     &     MXSPLIT, NCOM, DEFAULT, CONT, -1.E20, 1.E20, IFAIL)
      CALL CHAR_IN('Line data file', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, FILE, IFAIL)
C     
      OPEN(UNIT=47,FILE=FILE,STATUS='OLD',IOSTAT=IFAIL)
      IF(IFAIL.NE.0) THEN
         WRITE(*,*) 'Could not open ',FILE
         GOTO 999
      END IF
C     
C     Fake spectrum
C
      VLIGHT = CGS('C')/1.E5
      DO I = 1, NBIN
         WORK1(I) = CONT
      END DO
      NLINE = 0
 600  NLINE = NLINE + 1
      READ(47,*,ERR=601,END=602) WAVE, WIDTH, WIDTYP, STR, STRTYP
      DO I = 1, NBIN
         Z = REAL(I)
         W = ANGST(Z,NBIN,NAOUT,AOUT,2)
         IF(WIDTYP.EQ.1) THEN
            EFAC = REAL(FFAC*(VLIGHT*(W/WAVE-1.)/WIDTH)**2)
         ELSE
            EFAC = REAL(FFAC*((W-WAVE)/WIDTH)**2)
         END IF
         IF(STRTYP.EQ.1) THEN
            WORK1(I) = WORK1(I) + STR*EXP(-EFAC)
         ELSE
            WORK1(I) = EXP(-STR*EXP(-EFAC))*WORK1(I) 
         END IF
      END DO
      GOTO 600
 601  WRITE(*,*) 'Error reading ',FILE
      CLOSE(UNIT=47)
      GOTO 999
 602  NLINE = NLINE - 1
      WRITE(*,*) NLINE,' entries read.'
      CLOSE(UNIT=47)
C
C     Store spectrum
C     
      NPIX(SLOT) = NBIN
      NARC(SLOT) = NAOUT
      ARC(1,SLOT) = AOUT(1)
      ARC(2,SLOT) = AOUT(2)
      DO I = 1, NPIX(SLOT)
         COUNTS(I,SLOT) = WORK1(I)
         ERRORS(I,SLOT) = WORK1(I)/10000.
         FLUX(I,SLOT)   = WORK1(I)
      END DO
C
C     Clear headers, set object name
C
      NCHAR(SLOT) = 0
      NDOUB(SLOT) = 0
      NINTR(SLOT) = 0
      NREAL(SLOT) = 0
      CALL HSETC('Object', 'Fake spectrum', SLOT, MXSPEC, 
     &     NMCHAR, HDCHAR, NCHAR, MXCHAR, IFAIL)
C
 999  RETURN
      END

