      SUBROUTINE SL_INF(SLOT, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &     NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &     MXINTR, MXREAL, STRING, IFAIL)
C
C Returns character string loaded with basic information on slot.
C 
C Arguments:
C
C >  I     SLOT             -- Slot you want information for.
C    I     MXSPEC           -- Maximum number of spectra
C <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C <  I     NCHAR(MXSPEC)  -- Number of character header items.
C <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C <  I     NINTR(MXSPEC)  -- Number of integer items.
C <  I     NREAL(MXSPEC)  -- Number of real items.
C >  I     MXCHAR    -- Maximum number of character header items/spec
C >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C >  I     MXINTR    -- Maximum number of integer header items/spec
C >  I     MXREAL    -- Maximum number of real headers items/spec
C >  C     STRING    -- String with information.
C <  I     IFAIL              -- Error return.
C
      IMPLICIT NONE
C
C     Integer parameters
C
      INTEGER MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC
      INTEGER SLOT
      CHARACTER*(*) STRING
      INTEGER NPIX(MXSPEC)
C
C     Numbers of header items
C
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C
C     Names of header items
C
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C
C     Values of header items
C
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C
C     Local variables
C
      INTEGER IOBJ, IDWE, IUT,  IRUN
      INTEGER HOURS, MINS, SECS, MILLIS
      INTEGER YEAR, IYEAR, IMONTH, IDAY
      INTEGER IFAIL, MONTH, DAY
      DOUBLE PRECISION UTC
      CHARACTER*32 OBJECT
      INTEGER RECORD
      REAL DWELL
C
C     Search for standard header items 
C     'OBJECT', 'DWELL', 'UTC', 'YEAR', 'MONTH', 'DAY'
C
      STRING = '     , obj:                 , run:       ,'//
     &' exp:          , time:   /  /  ,   :  :  '
      WRITE(STRING(1:5),'(I5)') SLOT
      IF(SLOT.GT.MXSPEC .OR. NPIX(SLOT).EQ.0) THEN
        IFAIL = 1
        RETURN
      ELSE
        IFAIL = 0
      END IF
      CALL HGETC('Object', OBJECT, SLOT, MXSPEC, NMCHAR,
     &     HDCHAR, NCHAR, MXCHAR, IOBJ)
      CALL HGETI('Record', RECORD, SLOT, MXSPEC, NMINTR,
     &     HDINTR, NINTR, MXINTR, IRUN)
      CALL HGETR('Dwell', DWELL, SLOT, MXSPEC, NMREAL,
     &     HDREAL, NREAL, MXREAL, IDWE)
      CALL HGETD('UTC', UTC, SLOT, MXSPEC, NMDOUB,
     &     HDDOUB, NDOUB, MXDOUB, IUT)
      CALL HGETI('Day', DAY, SLOT, MXSPEC, NMINTR,
     &     HDINTR, NINTR, MXINTR, IDAY)
      CALL HGETI('Month', MONTH, SLOT, MXSPEC, NMINTR,
     &     HDINTR, NINTR, MXINTR, IMONTH)
      CALL HGETI('Year', YEAR, SLOT, MXSPEC, NMINTR,
     &     HDINTR, NINTR, MXINTR, IYEAR)

      IF(IOBJ.EQ.0) STRING(13:28) = OBJECT(:16)
      IF(IRUN.EQ.0) WRITE(STRING(36:42),'(I7)') RECORD
      IF(IDWE.EQ.0) WRITE(STRING(50:58),'(G9.4E1)') DWELL
      IF(IDAY.EQ.0) WRITE(STRING(66:67),'(I2.2)') DAY
      IF(IMONTH.EQ.0) WRITE(STRING(69:70),'(I2.2)') MONTH
      IF(IYEAR.EQ.0) THEN
        YEAR = YEAR - 100*(YEAR/100)
        WRITE(STRING(72:73),'(I2.2)') YEAR
      END IF
      IF(IUT.EQ.0) THEN
        CALL TSPLIT(UTC,HOURS,MINS,SECS,MILLIS)
        WRITE(STRING(76:83),'(I2.2,A,I2.2,A,I2.2)') 
     &  HOURS,':',MINS,':',SECS
      END IF
      RETURN
      END




