      SUBROUTINE SINCMAX(DATA,NDATA,NMAX,X,F,D2,IFAIL)
*
* Locates a maximum close to pixel NMAX which must itself be greater
* than the pixels on either side (checked for) using sinc function
* interpolation. Returns the position of the maximum X, the value at
* the maximum F and the second derivative at the maximum D2. NMAX must
* not be at the ends of the array. Data beyond the edges of the array
* is assumed to have the same value as the respective end pixels.
* A window function is used to truncate the sinc function.
*
      IMPLICIT NONE
      INTEGER NDATA, NMAX, IFAIL
      REAL DATA(NDATA), X, F, D2
*
      IF(NMAX.LE.1 .OR. NMAX.GE.NDATA) THEN
        IFAIL = 1
        RETURN
      END IF
      IF(DATA(NMAX).LT.DATA(NMAX-1) .OR. 
     &DATA(NMAX).LT.DATA(NMAX+1)) THEN
        IFAIL = 2
        RETURN
      END IF
      RETURN
      END

      REAL FUNCTION SINCI(X,DATA,NDATA)
*
* Computes sinc interpolated function at X
*
      IMPLICIT NONE
      INTEGER NDATA, N, I, I1, I2
      INCLUDE 'maxsinc.inc'
      REAL DATA(NDATA), X, PI, FUNC, X1, X2
      DOUBLE PRECISION SUM, NORM
*
      PI = 4.*ATAN(1.)
      N = NINT(X)      
      I1 = N - MAXSINC
      I2 = N + MAXSINC
      SUM  = 0.D0
      NORM = 0.D0
      DO I = I1, I2
        X1 = PI*(X-REAL(I))
        X2 = ABS(X-REAL(I))/(REAL(MAXSINC)+0.5)
        IF(ABS(X1).LT.1.E-2) THEN
          FUNC = 1.-X1**2/6.
        ELSE
          FUNC =  SIN(X1)/X1
        END IF
        IF(X2.LE.0.5) THEN
          FUNC = FUNC*(4./3.+8.*(X2-1.)*X2**2)
        ELSE
          FUNC = FUNC*8./3.*(1.-X2)**3
        END IF
        SUM = SUM + FUNC*DATA(MAX(1,MIN(I,NDATA)))
        NORM = NORM + FUNC
      END DO
      SINCI = REAL(SUM/NORM)
      RETURN
      END

      REAL FUNCTION SINCID(X,DATA,NDATA)
*
* Computes derivative of sinc interpolated function at X
*
      IMPLICIT NONE
      INTEGER NDATA, N, I, I1, I2
      INCLUDE 'maxsinc.inc'
      REAL DATA(NDATA), X, PI, FAC1, FAC2, FAC3, FAC4, GRAD
      REAL X1, X2, S
      DOUBLE PRECISION SUM, NORM
*
      PI = 4.*ATAN(1.)
      N = NINT(X)      
      I1 = N - MAXSINC
      I2 = N + MAXSINC
      SUM = 0.D0
      NORM = 0.D0
      DO I = I1, I2
        X1 = PI*(X-REAL(I))
        X2 = ABS(X-REAL(I))/(REAL(MAXSINC)+0.5)
        IF(X2.LE.0.5) THEN
          IF(ABS(X1).LT.1.E-2) THEN
            FAC1 = -PI*X1*(1.-X1**2/10.)/3.
            FAC4 =  1.-X1**2/6.
          ELSE
            S = SIN(X1)
            FAC1 =  PI*(X1*COS(X1)-S)/X1**2
            FAC4 =  S/X1
          END IF
          FAC3 = 4.*(6.*X2-4.)*X2/(REAL(MAXSINC)+0.5)
          IF(X1.LT.0.) FAC3 = - FAC3
          FAC2 = 4./3.+8.*(X2-1.)*X2**2
        ELSE
          S = SIN(X1)
          FAC1 =  PI*(X1*COS(X1)-S)/X1**2
          FAC4 = S/X1
          FAC3 = 8.*(-1.+2.*X2*(1.-X2))/(REAL(MAXSINC)+0.5)
          IF(X1.LT.0.) FAC3 = - FAC3
          FAC2 = 8./3.*(1.-X2)**3
        END IF
        GRAD = FAC1*FAC2+FAC3*FAC4
        SUM = SUM + GRAD*DATA(MAX(1,MIN(I,NDATA)))
      END DO
      SINCID = REAL(SUM/NORM)
      RETURN
      END

      DOUBLE PRECISION FUNCTION SINCF(X)
*
* Computes sinc interpolation function at X away from origin
*
      IMPLICIT NONE
      INCLUDE 'maxsinc.inc'
      DOUBLE PRECISION X, PI, X1, X2
      LOGICAL FIRST
      DATA FIRST/.TRUE./
*
      IF(FIRST) THEN
        PI = 4.D0*ATAN(1.D0)
        FIRST = .FALSE.
      END IF
      X1 = PI*X
      X2 = ABS(X)/(DBLE(MAXSINC)+5.D-1)
      IF(X2.GE.1.D0) THEN
        SINCF = 0.D0
      ELSE
        IF(ABS(X1).LT.1.D-2) THEN
          SINCF = 1.D0-X1**2/6.D0
        ELSE
          SINCF =  SIN(X1)/X1
        END IF
        IF(X2.LE.5.D-1) THEN
          SINCF = SINCF*(4.D0/3.D0+8.D0*(X2-1.D0)*X2**2)
        ELSE
          SINCF = SINCF*8.D0/3.D0*(1.D0-X2)**3
        END IF
      END IF
      RETURN
      END
