*ZERO
* ZERO STATUS -- Sets ZERO flag which determines the whether zero levels
*                are plotted in spectrum plots or not. This can be useful
*                for multiple spectrum plots with an offset.
*                 
*
* Parameters:  
*
* STATUS -- If not supplied by user, the status of ZERO is just switched
*           Otherwise put STATUS = 'ON' or 'OFF' to force the required state.
*
*ZERO
      SUBROUTINE SET_ZERO(SPLIT, NSPLIT, MXSPLIT, ZERO, IFAIL)
*
*
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, IFAIL
      CHARACTER*(*) SPLIT(MXSPLIT)
      LOGICAL SAMECI, ZERO, STATUS
*
      IFAIL = 0
      IF(NSPLIT.GE.1) THEN
        STATUS = SAMECI(SPLIT(1),'ON')
        IF(.NOT.STATUS .AND. .NOT.SAMECI(SPLIT(1),'OFF')) THEN
          WRITE(*,*) 'Forced status must either be ON or OFF'
          GOTO 999
        END IF
      END IF
      IF(NSPLIT.GE.1) THEN
        ZERO = STATUS
      ELSE
        ZERO = .NOT.ZERO
      END IF
      IF(ZERO) THEN
        WRITE(*,*) 'Zero levels will be plotted with spectra.'
      ELSE
        WRITE(*,*) 'Zero levels will not be plotted with spectra.'
      END IF                          
      RETURN
999   IFAIL = 1
      RETURN
      END
