*MXPIX
* MXPIX N SURE  -- Sets maximum number of pixels/spectrum.
*
* MOLLY stores spectra in 3 arrays for counts, uncertainties
* and fluxes. These are declared as 1D arrays in the main program,
* but as 2D in subroutines with dimensions specified by the
* maximum number of pixels/spectrum and the maximum number of spectra.
* These are related in that the larger the size of spectrum you want
* to handle, the fewer spectra can be loaded in. MXPIX allows you to
* set the maximum spectrum size. Note that below a certain number of
* pixels you gain no more slots becuase there are other parameters
* set which limit it. You are also limited in how large a spectrum
* can be handled by the work array sizes. If you need to change these
* constraints, you should edit the main MOLLY program and re-link.
*
*
* **IMPORTANT NOTE**
*
* If you alter the maximum pixel size you will lose **ALL SPECTRA**
* that you have inside MOLLY!!!
*
* Parameters:
*
*             N    -- New number of pixels/spectrum
*             SURE -- This is a safety device. On a command
*                     line this must be set = 'SURE' for the
*                     operation to be carried out.
*MXPIX
      SUBROUTINE SET_PIX(SPLIT, NSPLIT, NPIX, NARC, NCHAR, NDOUB,
     &NINTR, NREAL, MXSPLIT, MXBUFF, MXSPEC, MXWORK, MAXPX, IFAIL)
*
* Master routine for setting plot options
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
*    I     NPIX(MXSPEC)     -- Spectrum lengths
*    I     NARC(MXSPEC)     -- Numbers of arc coeffs
*    I     NCHAR(MXSPEC)    -- Numbers of C header items
*    I     NDOUB(MXSPEC)    -- Numbers of D header items
*    I     NINTR(MXSPEC)    -- Numbers of I header items
*    I     NREAL(MXSPEC)    -- Numbers of R header items
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* >  I     MXBUFF           -- Maximum buffer size
* >  I     MXSPEC           -- Maximum number of spectra
* >  I     MXWORK           -- Maximum work array size, which sets effective
*                              upper limit to MAXPX
*    I     MAXPX            -- Maximum spectrum length
*
      IMPLICIT NONE
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
      INTEGER MXBUFF, MXSPEC, MXWORK, MAXPX
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Local variables
*
      INTEGER IFAIL, NOLD, NCOM, I, NSPEC
      CHARACTER*5 REPLY
      LOGICAL DEFAULT, ESAMECI
*
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
      NOLD = MAXPX
      CALL INTR_IN('Maximum spectrum size', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, MAXPX, 1, MXWORK, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(NSPLIT.GT.1 .AND. .NOT.ESAMECI(SPLIT(2),'SURE')) THEN
        WRITE(*,*) 'No change. Must enter ''sure'' on command line'
        IFAIL = 1
        GOTO 999
      ELSE IF(NSPLIT.EQ.1) THEN
        WRITE(*,*) 'All old spectra will be lost.'
        REPLY = 'n'
        CALL CHAR_IN('Do you want to proceed ?', SPLIT, 
     &  NSPLIT, MXSPLIT, NCOM, DEFAULT, REPLY, IFAIL)
        IF(.NOT.ESAMECI(REPLY,'Y')) THEN
          WRITE(*,*) 'No change made.'
          IFAIL = 0
          GOTO 999
        END IF
      END IF
      WRITE(*,*) 'Maximum spectrum length set = ',MAXPX
      WRITE(*,*) '  Maximum number of spectra = ',
     &MIN(MXBUFF/MAXPX,MXSPEC)
      IF(MAXPX.NE.NOLD) THEN
        NSPEC = 0
        DO I = 1, MXSPEC
          IF(NPIX(I).GT.0) NSPEC = NSPEC + 1
          NPIX(I)  = 0
          NARC(I)  = 0
          NCHAR(I) = 0
          NDOUB(I) = 0
          NINTR(I) = 0
          NREAL(I) = 0
        END DO
        IF(NSPEC.GT.0) WRITE(*,*) 'Buffers cleared'
      END IF
999   RETURN
      END
