*MOLEX
* MOLEX STATUS -- Sets MOLEX flag which determines whether the extension
*                 .mol is sused for molly files.
*
* Parameters:  
*
* STATUS -- If not supplied by user, the status of MOLEX is just switched
*           Otherwise put STATUS = 'ON' or 'OFF' to force the required state.
*
*MOLEX
      SUBROUTINE SET_MOLEX(SPLIT, NSPLIT, MXSPLIT, MOLEX, IFAIL)
*
*
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, IFAIL
      CHARACTER*(*) SPLIT(MXSPLIT)
      LOGICAL SAMECI, MOLEX, STATUS
*
      IFAIL = 0
      IF(NSPLIT.GE.1) THEN
        STATUS = SAMECI(SPLIT(1),'ON')
        IF(.NOT.STATUS .AND. .NOT.SAMECI(SPLIT(1),'OFF')) THEN
          WRITE(*,*) 'Forced status must either be ON or OFF'
          GOTO 999
        END IF
      END IF
      IF(NSPLIT.GE.1) THEN
        MOLEX = STATUS
      ELSE
        MOLEX = .NOT.MOLEX
      END IF
      IF(MOLEX) THEN
        WRITE(*,*) 'Extension .mol will be assumed.'
      ELSE
        WRITE(*,*) 'Extension .mol will not be assumed.'
      END IF                          
      RETURN
999   IFAIL = 1
      RETURN
      END
