*DCOLOUR
* DCOLOUR DCOL -- Sets colour for data in line plots 
*
* Parameters: 
*  
*   DCOL   -- Colour for plotting data. 
*
* The colours are integers e.g. 0=black,1=white,2=red,3=green etc.
* Range 0-15
*
* See also LCOLOUR for setting other colours (including data)
*DCOLOUR
*LCOLOUR
* LCOLOUR DCOL ECOL LABCOL AXCOL -- Sets colours for line plots 
*                              (as opposed to images)
*
* Parameters: 
*  
*   DCOL   -- Colour for plotting data. 
*   ECOL   -- Colour for plotting errors
*   LABCOL -- Colour for labels.
*   AXCOL  -- Colour for axes.
*
* The colours are integers e.g. 0=black,1=white,2=red,3=green etc.
* Range 0-15.
*
* See also DCOLOUR for setting data colour only.
*LCOLOUR
      SUBROUTINE SET_LCOLOUR(SPLIT, NSPLIT, MXSPLIT, DCOL, ECOL,
     &LABCOL, AXCOL, VERSION, IFAIL)
*
*
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, IFAIL, NCOM
      CHARACTER*(*) SPLIT(MXSPLIT), VERSION
      INTEGER DCOL, ECOL, LABCOL, AXCOL
      LOGICAL DEFAULT
*
      IFAIL = 0
      NCOM  = 0
      DEFAULT = .FALSE.
      CALL INTR_IN('Data colour', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, DCOL, 0, 15, IFAIL)
      IF(VERSION.EQ.'L') THEN
        CALL INTR_IN('Errors colour', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, ECOL, 0, 15, IFAIL)
        CALL INTR_IN('Label colour', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, LABCOL, 0, 15, IFAIL)
        CALL INTR_IN('Axes colour', SPLIT, NSPLIT, 
     &  MXSPLIT, NCOM, DEFAULT, AXCOL, 0, 15, IFAIL)
      END IF
      RETURN
      END
