*ID
* ID STATUS -- Sets ID flag which determines whether a user identifier
*              is added to plots.
*
* Parameters:  
*
* STATUS -- If not supplied by user, the status of ID is just switched
*           Otherwise put STATUS = 'ON' or 'OFF' to force the required state.
*
*ID
      SUBROUTINE SET_ID(SPLIT, NSPLIT, MXSPLIT, ID, IFAIL)
*
*
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, IFAIL
      CHARACTER*(*) SPLIT(MXSPLIT)
      LOGICAL SAMECI, ID, STATUS
*
      IFAIL = 0
      IF(NSPLIT.GE.1) THEN
        STATUS = SAMECI(SPLIT(1),'ON')
        IF(.NOT.STATUS .AND. .NOT.SAMECI(SPLIT(1),'OFF')) THEN
          WRITE(*,*) 'Forced status must either be ON or OFF'
          GOTO 999
        END IF
      END IF
      IF(NSPLIT.GE.1) THEN
        ID = STATUS
      ELSE
        ID = .NOT.ID
      END IF
      IF(ID) THEN
        WRITE(*,*) 'User ID will be added to plots.'
      ELSE
        WRITE(*,*) 'User ID will not be added to plots.'
      END IF                          
      RETURN
999   IFAIL = 1
      RETURN
      END
