      SUBROUTINE SET_HEAD(OUTPUT, INPUT, MXSPEC, NPIX, ARC, NARC, 
     &MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &MXINTR, MXREAL, IFAIL)
*
* Sets headers of slot OUTPUT equal to those of INPUT
* 
* Arguments:
*
* >  I     OUTPUT           -- Slot to copy headers to.
* >  I     INPUT            -- Slot to copy headers from.
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE
*
* Integer parameters
*
      INTEGER MXSPEC, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
      INTEGER INPUT, OUTPUT
*
* Local variables
*
      INTEGER I, J, K, IFAIL
*
* Check inputs
*
      I = INPUT
      J = OUTPUT
      IF(NPIX(I).LE.0) THEN
        WRITE(*,*) 'No spectrum found in slot ',I
        IFAIL = 1
        RETURN
      END IF
*
* Copy headers
*
      NPIX(J) = NPIX(I)
      NARC(J) = NARC(I)
      DO K = 1, ABS(NARC(I))
        ARC(K,J) = ARC(K,I)
      END DO
      NCHAR(J) = NCHAR(I)
      DO K = 1, NCHAR(I)
        NMCHAR(K,J) = NMCHAR(K,I)              
        HDCHAR(K,J) = HDCHAR(K,I)              
      END DO
      NDOUB(J) = NDOUB(I)
      DO K = 1, NDOUB(I)
        NMDOUB(K,J) = NMDOUB(K,I)              
        HDDOUB(K,J) = HDDOUB(K,I)              
      END DO
      NINTR(J) = NINTR(I)
      DO K = 1, NINTR(I)
        NMINTR(K,J) = NMINTR(K,I)              
        HDINTR(K,J) = HDINTR(K,I)              
      END DO
      NREAL(J) = NREAL(I)
      DO K = 1, NREAL(I)
        NMREAL(K,J) = NMREAL(K,I)              
        HDREAL(K,J) = HDREAL(K,I)              
      END DO
      IFAIL = 0
      RETURN
      END
