*EPLOT
* EPLOT STATUS -- Sets EPLOT flag which determines the whether error
*                bars are plotted in spectrum plots or not.
*                 
*
* Parameters:  
*
* STATUS -- If not supplied by user, the status of EPLOT is just switched
*           Otherwise put STATUS = 'ON' or 'OFF' to force the required state.
*
*EPLOT
      SUBROUTINE SET_EPLOT(SPLIT, NSPLIT, MXSPLIT, EPLOT, IFAIL)
*
*
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, IFAIL
      CHARACTER*(*) SPLIT(MXSPLIT)
      LOGICAL SAMECI, EPLOT, STATUS
*
      IFAIL = 0
      IF(NSPLIT.GE.1) THEN
        STATUS = SAMECI(SPLIT(1),'ON')
        IF(.NOT.STATUS .AND. .NOT.SAMECI(SPLIT(1),'OFF')) THEN
          WRITE(*,*) 'Forced status must either be ON or OFF'
          GOTO 999
        END IF
      END IF
      IF(NSPLIT.GE.1) THEN
        EPLOT = STATUS
      ELSE
        EPLOT = .NOT.EPLOT
      END IF
      IF(EPLOT) THEN
        WRITE(*,*) 'Errors will be plotted with spectra.'
      ELSE
        WRITE(*,*) 'Errors will not be plotted with spectra.'
      END IF                          
      RETURN
999   IFAIL = 1
      RETURN
      END
