*PCLOSE
* PCLOSE STATUS -- Sets PCLOSE flag which determines whether plots are
*                  closed on exiting commands or not.
*
* If you want to add labels to a plot or draw another plot on top of
* one you need to set pclose BEFORE making a plot (slight change from
* before where you could do it afterwards). If you do this then you must 
* explicitly 'close' the plot if you want a hardcopy.
*
* Parameters:  
*
* STATUS -- If not supplied by user, the status of PCLOSE is just switched
*           Otherwise put STATUS = 'ON' or 'OFF' to force the required state.
*
*
* Related commands: CLOSE, DEVICE
*
*PCLOSE
      SUBROUTINE SET_CLOSE(SPLIT, NSPLIT, MXSPLIT, CLOSE, IFAIL)
*
*
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, IFAIL
      CHARACTER*(*) SPLIT(MXSPLIT)
      LOGICAL SAMECI, CLOSE, STATUS
*
      IFAIL = 0
      IF(NSPLIT.GE.1) THEN
        STATUS = SAMECI(SPLIT(1),'ON')
        IF(.NOT.STATUS .AND. .NOT.SAMECI(SPLIT(1),'OFF')) THEN
          WRITE(*,*) 'Forced status must either be ON or OFF'
          GOTO 999
        END IF
      END IF
      IF(NSPLIT.GE.1) THEN
         CLOSE = STATUS
      ELSE
         CLOSE = .NOT.CLOSE
      END IF
      IF(CLOSE) THEN
         WRITE(*,*) 'Plots will be closed on exiting commands.'
      ELSE
         WRITE(*,*) 'Plots will not be closed on exiting commands.'
      END IF                          
      RETURN
999   IFAIL = 1
      RETURN
      END
