*AXES
* AXES Xaxis Yaxis -- Sets axes for spectrum plots.
*
* Parameters:
*            
*     XAXIS -- Xaxis type. Choices are:
*
*         pixels       -- pixel scale (always possible)
*         angstroms    -- angstrom wavelength scale (needs wavelength cal)
*         microns      -- micron wavelength scale (needs wavelength cal)
*         nannometres  -- nannometre wavelength scale (needs wavelength cal)
*         km/s         -- Velocity scale in km/s. Will be prompted for a
*                         central wavelength when plotting. Needs
*                         wavelength cal
*
*     YAXIS -- Yaxis type. Choices are:
*
*         counts       -- raw counts
*         millijanskys -- flux density in millijanskys 
*                         1 mJy = 10**-26 W/m**2/Hz = 10**-26 ergs/s/cm**2/Hz
*                         1 mJy = 16.4 on AB mag scale of Oke, roughly
*                                 matches V mag.
*         flambda      -- flux in ergs/s/cm**2/A
*         AB           -- AB mags = 16.4 - 2.5 LOG10(f/1mJy)
*         response     -- Measures reponse of detector etc as AB mag needed
*                         to get 1 count/sec/A. Plot allows you to correct
*                         this to zero airmass if need be.
*         efficiency   -- linearised version of rsponse which allows you
*                         to include telescope aperture to get fraction of
*                         photons detected. Again can be corrected for
*                         extinction.
*
*AXES
      SUBROUTINE SET_AXES(SPLIT, NSPLIT, MXSPLIT, XAXIS, YAXIS, IFAIL)
*
* Set X, Y axis types and labels
*
      IMPLICIT NONE
      INTEGER NSPLIT, MXSPLIT, IFAIL,  NCOM
      LOGICAL RECOG, DEFAULT
      CHARACTER*(*) SPLIT(MXSPLIT)
      CHARACTER*(*) XAXIS, YAXIS
      CHARACTER*100 STRING, DUMMY
*
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
      STRING = XAXIS
      CALL CHAR_IN('X axis type', SPLIT, NSPLIT, MXSPLIT, NCOM,
     &DEFAULT, XAXIS, IFAIL)
      CALL XTYPE(XAXIS, DUMMY, RECOG)
      IF(.NOT.RECOG) THEN
        XAXIS = STRING
        GOTO 999
      END IF
      STRING = XAXIS
      CALL CHAR_IN('Y axis type', SPLIT, NSPLIT, MXSPLIT, NCOM,
     &DEFAULT, YAXIS, IFAIL)
      CALL YTYPE(YAXIS, DUMMY, RECOG)
      IF(.NOT.RECOG) THEN
        YAXIS = STRING
        GOTO 999
      END IF
      IFAIL = 0
      RETURN
999   WRITE(*,*) 'Error translating command'
      IFAIL = 1
      RETURN
      END

