CBARB
C BARB N1 N2 N3 FILE METHOD -- Broadens spectra with user defined profile
C
C
C Parameters:
C           
C     N1   -- First spectrum to be broadened
C     N2   -- Last spectrum to be broadened
C     N3   -- First output spectrum
C     FILE -- File with 2 columns, the first of velocities, and the second
C             of the profile function at each velocity. Velocities in km/s.
C             It should increase monotonically in X. Linear interpolation
C             is used at the moment so a fine sampling is advisable.
C             Empty lines or lines beginning with # will be ignored.
C             The normalisation will be set by the maximum value. i.e.
C             a max value = 1 will leave the continuum unchanged whereas
C             0.5 will reduce it. This is to allow for sequences of models
C             where the normalisation may vary in a defineable manner.
C
C     METHOD- F = Fast crude method, which is only accurate if
C                 the broadening covers many pixels, otherwise it
C                 tends to underbroaden. It is only worth using
C                 on spectra which are not on a velocity scale since
C                 the time saving is otherwise small.
C
C             S = Slow, accurate method which requires convolving the
C                 broadening with the interpolating function for which
C                 a truncated SIN(X)/X type interpolation is used.
C                 BE WARNED: this can be VERY VERY slow see next.
C
C     If the scale is uniform in velocity, then the routine need only 
C     compute the blurring array once and the computation should not 
C     be much affected by the METHOD used. Otherwise the blurring array 
C     is recomputed for EVERY pixel assuming that the scale is locally 
C     a velocity scale according to the dispersion at the pixel of interest. 
C     This is the reason for the large difference in speeds between the
C     two methods for non-uniform in velocity data. I recommend that for
C     resonable accuracy and speed you rebin to a uniform velocity scale
C     (vbin) with sinc function rebinning, and then use method S, otherwise
C     it can take a VERY long time.
C
C Related commands: RBROAD, SMEAR
C
CBARB
CRBROAD
C RBROAD N1 N2 N3 VSINI EPS METHOD -- Rotationally broadens spectra 
C
C Parameters:
C           
C     N1   -- First spectrum to be broadened
C     N2   -- Last spectrum to be broadened
C     N3   -- First output spectrum
C     VSINI-- Vsini of rotational broadening in km/s
C     EPS  -- Linear limb darkening coefficient.
C     METHOD- F = Fast crude method, which is only accurate if
C                 the broadening covers many pixels, otherwise it
C                 tends to underbroaden. Just computes profile
C                 at each pixel.
C
C             S = Slow accurate method which requires convolving the
C                 broadening with the interpolating function for which
C                 a truncated SIN(X)/X type interpolation is used.
C                 BE WARNED: this can be VERY VERY slow see next.
C
C     If the scale is uniform in velocity, then the routine need only 
C     compute the blurring array once and the computation should not 
C     be much affected by the METHOD used. Otherwise the blurring array 
C     is recomputed for EVERY pixel assuming that the scale is locally 
C     a velocity scale according to the disperion at the pixel of interest. 
C     This is the reason for the large difference in speeds between the
C     two methods for non-uniform in velocity data. I recommend that for
C     resonable accuracy and speed you rebin to a uniform velocity scale
C     (vbin) with sinc function rebinning, and then use method S, otherwise
C     it can take a VERY long time.
C
C     You may notice variations in the time taken on the slow method
C     for different broadenings. This is a consequence of the convolution 
C     of the rotational profile with the sinc interpolation function. For 
C     certain ratios of V sin i/ pixel width the integration routine takes
C     longer than normal to converge.
C
C Related commands: BARB, SMEAR
C
CRBROAD
CSMEAR
C SMEAR N1 N2 N3 WIDTH METHOD -- Smears spectra to simulate a uniform
C                               translation across detector caused by
C                               binary motion for example
C
C Parameters:
C           
C     N1   -- First spectrum to be smeared
C     N2   -- Last spectrum to be smeared
C     N3   -- First output spectrum
C     WIDTH-- Total width of rectangular smear profile
C     METHOD- F = Fast crude method, which is only accurate if
C                 the broadening covers many pixels, otherwise it
C                 tends to underbroaden. It is only worth using
C                 on spectra which are not on a velocity scale since
C                 the time saving is otherwise small.
C
C             S = Slow accurate method which requires convolving the
C                 broadening with the interpolating function for which
C                 a truncated SIN(X)/X type interpolation is used.
C                 BE WARNED: this can be VERY VERY slow see next.
C
C     If the scale is uniform in velocity, then the routine need only 
C     compute the blurring array once and the computation should not be 
C     much affected by the METHOD used. Otherwise the blurring array is 
C     recomputed for EVERY pixel assuming that the scale is locally a 
C     velocity scale according to the disperion at the pixel of interest. 
C
C Related commands: BARB, RBROAD
C
CSMEAR
      SUBROUTINE ROTB(SPLIT, NSPLIT, MXSPLIT, METHOD, IFAIL)
C     
C     Rotationally broadens spectra or smears by rectangular profile
C     to simulate smearing caused by orbital motion during an exposure
C     
C     Arguments: (note that most are passed by common)
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     C     METHOD             -- 'B' = Rotational broadening
C     'S' = rectangular smear
C     'A' = arbitrary profile specified by
C     tabular data.
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Slot lists
C     
      INTEGER NSLOTS, SLOT
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
      CHARACTER*(*) METHOD
C     
C     Local variables
C     
      INTEGER I, J, K, L, NCOM, IA, IB
      REAL GET_FLX, GET_ERF, CFRAT
      DOUBLE PRECISION  ANGST, DISPA, D, SUM
      DOUBLE PRECISION W, W1, W2, DCON
      CHARACTER*64 FILE, PROMPT*32
      CHARACTER*100 STRING
      CHARACTER*5 FAST
      INTEGER SLOT1, SLOT2, SLOT3,  OUT, NMID, NBLURR
      INTEGER IFAIL, NLO, NHI, IMETH, MAXSPEC
      REAL VLIGHT, RATIO, EPS, VSINI, WIDTH
      REAL Z, X, VS, F, V, ANORM, NORM
      LOGICAL SELECT, ESAMECI, ZERO, DEFAULT, LOGSCL
      INTEGER LENSTR, IND
      REAL CGS
C     
C     Common blocks
C     
      INTEGER NTAB
      REAL VAVE, RX
      COMMON /ARB/NTAB, VAVE, RX
      INCLUDE 'maxsinc.inc'
      INCLUDE 'molly.coms'
C     
      DATA SLOT1, SLOT2, SLOT3/1,1,2/
      DATA EPS, FILE, FAST/0.5, '100', 'S'/
      SAVE SLOT1, SLOT2, LIST, NLIST, SLOT3, FILE
C     
C     Index functions
C     
      IND(I,J) = MAXPX*(J-1)+I
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
C     
C     First slot
C     
      IF(METHOD.EQ.'B') THEN
         PROMPT = 'First spectrum to broaden'
      ELSE IF(METHOD.EQ.'S') THEN
         PROMPT = 'First spectrum to smear'
      ELSE IF(METHOD.EQ.'A') THEN
         PROMPT = 'First spectrum to convolve'
      END IF
      CALL INTR_IN(PROMPT, SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &     DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
C     
C     Second slot
C     
      SLOT2 = MAX(SLOT2, SLOT1)
      IF(METHOD.EQ.'B') THEN
         PROMPT = 'Last spectrum to broaden'
      ELSE IF(METHOD.EQ.'S') THEN
         PROMPT = 'Last spectrum to smear'
      ELSE IF(METHOD.EQ.'A') THEN
         PROMPT = 'Last spectrum to convolve'
      END IF
      CALL INTR_IN(PROMPT, SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &     DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) '0,0 only for list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST.GT.0) THEN
            CALL SETSLOT(LIST, NLIST, MXLIST, ISLOT, NSLOTS, MXSLOT)
         ELSE
            IF(METHOD.EQ.'B') THEN
               WRITE(*,*) 'Enter list of spectra to broaden'
            ELSE IF(METHOD.EQ.'S') THEN
               WRITE(*,*) 'Enter list of spectra to smear'
            ELSE IF(METHOD.EQ.'A') THEN
               WRITE(*,*) 'Enter list of spectra to convolve'
            END IF
            CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, ISLOT, 
     &           NSLOTS, MXSLOT)
         END IF
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, ISLOT, 
     &        NSLOTS, MXSLOT)
      END IF
C     
      CALL INTR_IN('First output slot', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &     DEFAULT, SLOT3, 1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(METHOD.EQ.'B') THEN
         PROMPT = 'V sin i (km/s) (or file of values)'
      ELSE IF(METHOD.EQ.'S') THEN
         PROMPT = 'Smear width (km/s) (or file of values)'
      ELSE IF(METHOD.EQ.'A') THEN
         PROMPT = 'File with tabulated profile'
      END IF
      CALL CHAR_IN(PROMPT, SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &     DEFAULT, FILE, IFAIL)     
C     
C     Load tabulated profile
C     
      IF(METHOD.EQ.'A') THEN
         OPEN(UNIT=47,FILE=FILE,STATUS='OLD',IOSTAT=IFAIL)
         IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Could not open ',FILE
            GOTO 999
         END IF
         NTAB  = 0
         IFAIL = 0
         ZERO  = .TRUE.
         ANORM = 0.
         DO WHILE(IFAIL.EQ.0)
            READ(47, '(A)', IOSTAT=IFAIL) STRING
            IF(IFAIL.EQ.0) THEN 
               IF(STRING.NE.' ' .AND. STRING(1:1).NE.'#') THEN
                  NTAB = NTAB + 1
                  READ(STRING,*,IOSTAT=IFAIL) DWORK(NTAB,3), 
     &                 DWORK(NTAB,4)
C     
C     Skip zeroes at start, making sure however that the 
C     first entry is zero
C     
                  ANORM = REAL(MAX(ANORM, DWORK(NTAB,4)))
                  IF(DWORK(NTAB,4).NE.0.D0) ZERO = .FALSE.
                  IF(ZERO .AND. NTAB.GT.1) THEN
                     DWORK(1,3) = DWORK(NTAB,3)
                     DWORK(1,4) = DWORK(NTAB,4)
                     NTAB = 1
                  END IF
               END IF
               IF(NTAB.GE.MXWORK) THEN
                  WRITE(*,*) 'Too many entries in ',FILE
                  GOTO 999
               END IF
            END IF
         END DO
         IF(IFAIL.GT.0) THEN
            WRITE(*,*) 'Error reading ',FILE
            CLOSE(UNIT=47)
            GOTO 999
         ELSE
            CLOSE(UNIT=47)
            IFAIL = 0
         END IF
C     
C     Clip zeroes off end, making sure one is left.
C     
         DO WHILE(NTAB.GT.1 .AND. DWORK(NTAB-1,4).EQ.0.D0)
            NTAB = NTAB - 1
         END DO
         IF(NTAB.LE.1) THEN
            WRITE(*,*) 'Too few non-zero entries'
            GOTO 999
         END IF
         WRITE(*,*) NTAB,' entries stored.'
      END IF
C     
      IF(METHOD.EQ.'B') THEN
         CALL REAL_IN('Limb darkening coefficient', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, EPS, 0., 1., IFAIL)     
      END IF
C     
      CALL CHAR_IN('F(ast) and crude or S(low) and accurate?',
     &     SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, FAST, IFAIL)     
      IF(ESAMECI(FAST,'F')) THEN
         IMETH = 1
      ELSE IF(ESAMECI(FAST,'S')) THEN
         IMETH = 2
      ELSE
         WRITE(*,*) 'Must answer either F or S'
         FAST = 'S'
         GOTO 999
      END IF
      IF(IFAIL.NE.0) GOTO 999
C     
C     Now broaden/smear
C     
      VLIGHT = CGS('C')/1.E5
      OUT = SLOT3 - 1
      DO I = 1, NSLOTS
         SLOT = ISLOT(I,1)
         IF( NPIX(SLOT).LE.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' empty; skipped.'
         ELSE IF(NARC(SLOT).EQ.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' has no wavelength scale'
         ELSE IF(.NOT.SELECT( SLOT, NMCHAR, NMDOUB, NMINTR, 
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &           NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &           MXINTR, MXREAL, MXSPEC, NMSCHAR, VSCHAR, 
     &           NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &           VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, 
     &           MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN
            WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
         ELSE
C     
C     Get Vsini or smear width 
C     
            IF(METHOD.EQ.'B' .OR. METHOD.EQ.'S') THEN
               CALL GETCONST(FILE,DCON,IFAIL)
               IF(IFAIL.EQ.1) THEN
                  WRITE(*,*) 'Could not read ',I,'th file entry'
                  GOTO 999
               ELSE IF(IFAIL.EQ.2) THEN
                  WRITE(*,*) 'Could not interpret ',
     &                 FILE(:LENSTR(FILE))
                  GOTO 999
               ELSE IF(IFAIL.EQ.3) THEN
                  WRITE(*,*) 'Reached end-of-file'
                  GOTO 999
               END IF
               IF(DCON.LT.0. .OR. DCON.GT.1.E5) THEN
                  IF(METHOD.EQ.'B') THEN
                     WRITE(*,*) 'Vsini out of range = ',DCON
                  ELSE IF(METHOD.EQ.'S') THEN
                     WRITE(*,*) 
     &                    'Smearing width out of range = ',DCON
                  END IF                           
                  GOTO 999
               ELSE
                  IF(METHOD.EQ.'B') THEN
                     VSINI = REAL(DCON)
                  ELSE IF(METHOD.EQ.'S') THEN
                     WIDTH = REAL(DCON)
                  END IF                           
               END IF
            END IF
C     
C     Load work arrays
C     
            DO J = 1, NPIX(SLOT)
               IA = IND(J,SLOT)
               RWORK(J,1) = GET_FLX(COUNTS(IA),FLUX(IA))
               RWORK(J,2) = GET_ERF(COUNTS(IA),ERRORS(IA),
     &              FLUX(IA))**2
               DWORK(J,1) = 0.D0
               DWORK(J,2) = 0.D0
            END DO
C     
C     Compute wavelength range and mean velocity/pixel
C     
            W1 = ANGST(1.,NPIX(SLOT),NARC(SLOT),
     &           ARC(1,SLOT),MXARC)
            W2 = ANGST(REAL(NPIX(SLOT)),NPIX(SLOT),NARC(SLOT),
     &           ARC(1,SLOT),MXARC)
            VAVE = REAL(VLIGHT*(EXP(LOG(W2/W1)/REAL(NPIX(SLOT)-1))-1.))
C     
C     Get blurr array width (which depends upon the method of choice)
C     
            IF(IMETH.EQ.1) THEN
               IF(METHOD.EQ.'B') THEN
                  NBLURR = 2*INT(VSINI/ABS(VAVE))+1
               ELSE IF(METHOD.EQ.'S') THEN
                  NBLURR = 2*INT(WIDTH/ABS(VAVE)/2.)+1
               ELSE IF(METHOD.EQ.'A') THEN
                  NBLURR = 2*INT(MAX(-DWORK(1,3),
     &                 DWORK(NTAB,3))/DBLE(ABS(VAVE)))+1
               END IF                           
            ELSE IF(IMETH.EQ.2) THEN
               IF(METHOD.EQ.'B') THEN
                  NBLURR = 2*INT(VSINI/ABS(VAVE)+REAL(MAXSINC)+0.5)+1
               ELSE IF(METHOD.EQ.'S') THEN
                  NBLURR = 2*INT(WIDTH/ABS(VAVE)/2.+REAL(MAXSINC)+0.5)+1
               ELSE IF(METHOD.EQ.'A') THEN
                  NBLURR = 2*INT(MAX(-DWORK(1,3),
     &                 DWORK(NTAB,3))/DBLE(ABS(VAVE))+DBLE(MAXSINC)
     &                 +5.D-1)+1
               END IF                           
            END IF
            IF(NBLURR.GT.MXWORK) THEN
               WRITE(*,*) 'Too large a blurr for workspace in ROTB'
               GOTO 999
            END IF
C     
C     If the wavelength scale is logarithmic, we only need compute
C     the blurring array once.
C     
            IF(NARC(SLOT).EQ.-2) THEN
               LOGSCL = .TRUE.
C     
C     Compute blurr array. Store coefficients in slot 5
C     
               SUM = 0.D0
               DO J = 1, NBLURR
                  X  = REAL(J-NBLURR/2-1)
                  IF(METHOD.EQ.'B') THEN
                     VS = VSINI/ABS(VAVE)
                     CALL BRCOFF(X,VS,EPS,IMETH,DWORK(J,5),IFAIL)
                  ELSE IF(METHOD.EQ.'S') THEN
                     VS = WIDTH/ABS(VAVE)
                     CALL BSCOFF(X,VS,IMETH,DWORK(J,5),IFAIL)
                  ELSE IF(METHOD.EQ.'A') THEN
                     CALL BACOFF(X,IMETH,DWORK(J,5),IFAIL)
                  END IF      
                  SUM = SUM + DWORK(J,5)
               END DO         
C     
C     Normalise 
C     
               IF(METHOD.EQ.'A') THEN
                  NORM = REAL(ANORM/SUM)
               ELSE
                  NORM = REAL(1./SUM)
               END IF
               DO J = 1, NBLURR
                  DWORK(J,5) = NORM*DWORK(J,5)
               END DO
            ELSE
               LOGSCL = .FALSE.            
            END IF
C     
C     Effectively continue array at ends as though value was
C     constant
C     
            IF(METHOD.EQ.'B' .OR. METHOD.EQ.'S') THEN
               NLO = NBLURR/2+2
               NHI = NLO
            ELSE IF(METHOD.EQ.'A') THEN
               NLO = INT(ABS(SNGL(DWORK(NTAB,3))/VAVE))+2
               NHI = INT(ABS(SNGL(DWORK(1,3))/VAVE))+2
            END IF     
            DO J = 1-NLO, NPIX(SLOT)+NHI
C     
C     Not log scale, must recompute blurr array for every pixel,
C     assuming that can make a local approx to uniformity in log.
C     This is obviously a slow process.
C     
               IF(.NOT.LOGSCL) THEN
                  Z = REAL(J) 
                  W = ANGST(Z,NPIX(SLOT),NARC(SLOT),
     &                 ARC(1,SLOT),MXARC)
                  D = DISPA(Z,NPIX(SLOT),NARC(SLOT),
     &                 ARC(1,SLOT),MXARC)
                  VAVE = REAL(VLIGHT*D/W)
                  IF(IMETH.EQ.1) THEN
                     IF(METHOD.EQ.'B') THEN
                        NBLURR = 2*INT(VSINI/ABS(VAVE))+1
                     ELSE IF(METHOD.EQ.'S') THEN
                        NBLURR = 2*INT(WIDTH/ABS(VAVE)/2.)+1
                     ELSE IF(METHOD.EQ.'A') THEN
                        NBLURR = 2*INT(MAX(-DWORK(1,3),
     &                       DWORK(NTAB,3))/DBLE(ABS(VAVE)))+1
                     END IF                           
                  ELSE IF(IMETH.EQ.2) THEN
                     IF(METHOD.EQ.'B') THEN
                        NBLURR = 2*INT(VSINI/ABS(VAVE)+
     &                       REAL(MAXSINC)+0.5)+1
                     ELSE IF(METHOD.EQ.'S') THEN
                        NBLURR = 2*INT(WIDTH/ABS(VAVE)/2.+
     &                       REAL(MAXSINC)+0.5)+1
                     ELSE IF(METHOD.EQ.'A') THEN
                        NBLURR = 2*INT(MAX(-DWORK(1,3),
     &                       DWORK(NTAB,3))/DBLE(ABS(VAVE))+
     &                       DBLE(MAXSINC)+5.D-1)+1
                     END IF                           
                  END IF
                  IF(NBLURR.GT.MXWORK) THEN
                     WRITE(*,*) 
     &                    'Too large a blurr for workspace in ROTB'
                     GOTO 999
                  END IF
C     
C     Compute blurr array
C     
                  SUM = 0.D0
                  DO K = 1, NBLURR
                     X  = REAL(K-NBLURR/2-1)
                     IF(METHOD.EQ.'B') THEN
                        VS = VSINI/ABS(VAVE)
                        CALL BRCOFF(X,VS,EPS,IMETH,DWORK(K,5),IFAIL)
                     ELSE IF(METHOD.EQ.'S') THEN
                        VS = WIDTH/ABS(VAVE)
                        CALL BSCOFF(X,VS,IMETH,DWORK(K,5),IFAIL)
                     ELSE IF(METHOD.EQ.'A') THEN
                        CALL BACOFF(X,IMETH,DWORK(K,5),IFAIL)
                     END IF  
                     SUM = SUM + DWORK(K,5)
                  END DO       
C     
C     Normalise
C     
                  IF(METHOD.EQ.'A') THEN
                     NORM = REAL(ANORM/SUM)
                  ELSE
                     NORM = REAL(1./SUM)
                  END IF
                  DO K = 1, NBLURR
                     DWORK(K,5) = NORM*DWORK(K,5)
                  END DO
                  IF(IMETH.EQ.2 .AND. MOD(J,50).EQ.0) 
     &                 WRITE(*,*) 'Reached pixel ',J
               END IF
C     
C     Now at same stage whether uniform in log or not, just blurr
C     array
C     
               NMID = NBLURR/2
               F = RWORK(MAX(1,MIN(J,NPIX(SLOT))),1)
               V = RWORK(MAX(1,MIN(J,NPIX(SLOT))),2)
               DO K = MAX(1,J-NMID), MIN(NPIX(SLOT),J+NMID)
                  L = K - J + NMID + 1
                  DWORK(K,1) = DWORK(K,1) + DWORK(L,5)*F
                  DWORK(K,2) = DWORK(K,2) + DWORK(L,5)**2*V
               END DO
            END DO
C     
C     Now load results into output slot
C     
            OUT = OUT + 1
            DO J = 1, NPIX(SLOT)
               IA = IND(J,SLOT)
               IB = IND(J,OUT)
               RATIO = CFRAT(COUNTS(IA), FLUX(IA))
               COUNTS(IB) = REAL(RATIO*DWORK(J,1))
               ERRORS(IB) = REAL(RATIO*SQRT(DWORK(J,2)))
               IF(COUNTS(IB).EQ.0) THEN
                  FLUX(IB)   = RATIO
               ELSE
                  FLUX(IB)   = REAL(DWORK(J,1))
               END IF
            END DO
C     
C     Set headers 
C     
            CALL SET_HEAD(OUT, SLOT, MXSPEC, NPIX, ARC, NARC, 
     &           MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &           HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &           MXDOUB, MXINTR, MXREAL, IFAIL)
C     
            CALL SL_INF(OUT, MXSPEC, NPIX, NMCHAR, NMDOUB, NMINTR, 
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &           NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, STRING, 
     &           IFAIL)
            WRITE(*,*) STRING(:LENSTR(STRING))
         END IF
      END DO
      CALL GETCONST(FILE,DCON,-1)
 999  RETURN
      END
