CLFITS
C LFITS FILE N1  - Load spectra from molly FITS files.
C
C Parameters: 
C     
C    File -- Name of file to read in or name of a file containing
C            a list of file names to be read in. It assumes first
C            a list and then a specific name if the list file
C            cannot be read properly.
C
C    N1   -- First slot to read data into
C
C Related command: WFITS
C
CLFITS
      SUBROUTINE RFITS(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, 
     &     NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &     HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &     MXREAL, IFAIL)
C     
C     Reads FITS spectra
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     IFAIL)
C     
      IMPLICIT NONE
C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Local variables
C     
      CHARACTER*64 FILENAME, FILE
      CHARACTER*100 STRING, KEYSTR*32,ERRTXT*32,ERRMESS*80
      INTEGER SLOT1, SLOT,  IFAIL, IOPEN
      INTEGER  MAXSPEC,NCOM
      LOGICAL    DEFAULT,  ESAME, ANYF
      INTEGER LENSTR, UNIT, BLOCKSIZE,FCODE,HDUTYPE,NF,STATUS
C     
      DATA SLOT1/1/
      DATA FILENAME/'FITS.LIS'/
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
      CALL CHAR_IN('List of files', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, FILENAME, IFAIL)
      CALL INTR_IN('First slot to load into', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 1, MAXSPEC, IFAIL)
      IF((IFAIL.NE.0).OR.(SLOT1.LT.1)) GOTO 999
C     
C     
      SLOT = SLOT1 - 1
      OPEN(UNIT=47,FILE=FILENAME,STATUS='OLD',IOSTAT=IOPEN)
      IF(IOPEN.NE.0) THEN
         FILE = FILENAME
      ELSE
 100     READ(47,'(A)',IOSTAT=IFAIL) FILE
         IF(IFAIL.LT.0) THEN
            WRITE(*,*) 'End-of-file reached'
            WRITE(*,*) SLOT-SLOT1+1,' slots loaded.'
            IFAIL = 0
            GOTO 999
         ELSE IF(IFAIL.GT.0) THEN
            WRITE(*,*) 'Error reading file list'
            WRITE(*,*) SLOT-SLOT1+1,' slots loaded.'
            GOTO 999
         END IF
      END IF   
C     
C     Open FITS file for reading
C     
      STATUS = 0

      CALL GETLUN(UNIT,IFAIL)
      IF (IFAIL .NE. 0) THEN
         WRITE (*,*) 'Cannot open logical unit.'
         IFAIL = 1
         GOTO 999
      ENDIF

      CALL FTOPEN(UNIT,FILE,0,BLOCKSIZE,STATUS)
      IF (STATUS.NE.0) THEN
         WRITE (*,*) 'Failed to open ',FILE
         WRITE (*,*) 'STATUS =',STATUS
         IFAIL = 1
         GOTO 999
      ENDIF
      SLOT = SLOT + 1
C     
C     Check for correct FCODE keyword in primary header
C     
      CALL FTGKYJ(UNIT,'FCODE',FCODE,STRING,STATUS)
      IF (STATUS.NE.0 .OR. FCODE.NE.3) THEN
         WRITE (*,*) 'Missing/Invalid FCODE in header.'
         CALL FTCLOS(UNIT,STATUS)
         IFAIL = 1
         GOTO 999
      ENDIF
C     
C     
C     Read header items
C     
      CALL FTMAHD(UNIT,2,HDUTYPE,STATUS)
      IF (STATUS.NE.0 .OR. HDUTYPE.NE.1) THEN
         WRITE (*,*) 'ASCII table extension not found.'
         CALL FTCLOS(UNIT,STATUS)
         IFAIL = 1
         GOTO 999
      ENDIF
C     
      CALL FTGKYS(UNIT,'EXTNAME',KEYSTR,STRING,STATUS)
      IF ( (STATUS.NE.0) .OR. (.NOT. ESAME(KEYSTR,'HEADER')))THEN
         WRITE (*,*) 'ASCII table extension 2 is not a molly header.'
         CALL FTCLOS(UNIT,STATUS)
         IFAIL = 1
         GOTO 999
      ENDIF
C     
      CALL FTGKYJ(UNIT,'NCHAR',NCHAR(SLOT),STRING,STATUS)
      CALL FTGKYJ(UNIT,'NDOUB',NDOUB(SLOT),STRING,STATUS)
      CALL FTGKYJ(UNIT,'NINTR',NINTR(SLOT),STRING,STATUS)
      CALL FTGKYJ(UNIT,'NREAL',NREAL(SLOT),STRING,STATUS)
C     
      IF (STATUS.NE.0) THEN
         CALL FTGERR(STATUS,ERRTXT)
         WRITE (*,*)'Error occurred while reading FITS header'
         WRITE (*,*) 'Error status = ',STATUS,' : ',ERRTXT
 299     CALL FTGMSG (ERRMESS)
         WRITE (*,*) ERRMESS
         IF (ERRMESS.NE.' ') GOTO 299
         IFAIL = 1
         CALL FTCLOS(UNIT,STATUS)
         GOTO 999
      ENDIF
C     
      CALL FTGCVS(UNIT,1,1,1,NCHAR(SLOT),'Undefined',
     +     NMCHAR(1,SLOT),ANYF, STATUS)
      CALL FTGCVS(UNIT,2,1,1,NCHAR(SLOT),'Undefined',
     +     HDCHAR(1,SLOT),ANYF, STATUS)
      CALL FTGCVS(UNIT,3,1,1,NDOUB(SLOT),'Undefined',
     +     NMDOUB(1,SLOT),ANYF, STATUS)
      CALL FTGCVD(UNIT,4,1,1,NDOUB(SLOT),-1.D-33,
     +     HDDOUB(1,SLOT),ANYF, STATUS)
      CALL FTGCVS(UNIT,5,1,1,NINTR(SLOT),'Undefined',
     +     NMINTR(1,SLOT),ANYF, STATUS)
      CALL FTGCVJ(UNIT,6,1,1,NINTR(SLOT),-999999,
     +     HDINTR(1,SLOT),ANYF, STATUS)
      CALL FTGCVS(UNIT,7,1,1,NREAL(SLOT),'Undefined',
     +     NMREAL(1,SLOT),ANYF, STATUS)
      CALL FTGCVE(UNIT,8,1,1,NREAL(SLOT),-1.E-33,
     +     HDREAL(1,SLOT),ANYF, STATUS)
C     
      IF (STATUS.NE.0) THEN
         CALL FTGERR(STATUS,ERRTXT)
         WRITE (*,*)
     &        'Error occurred while reading header from FITS file.'
         WRITE (*,*) 'Error status = ',STATUS,' : ',ERRTXT
 199     CALL FTGMSG (ERRMESS)
         WRITE (*,*) ERRMESS
         IF (ERRMESS.NE.' ') GOTO 199
         IFAIL = 1
         CALL FTCLOS(UNIT,STATUS)
         GOTO 999
      ENDIF
C     
C     
C     Read Data items
C     
      CALL FTMAHD(UNIT,3,HDUTYPE,STATUS)
      IF (STATUS.NE.0 .OR. HDUTYPE.NE.2) THEN
         WRITE (*,*) 'Binary table extension not found.'
         CALL FTCLOS(UNIT,STATUS)
         IFAIL = 1
         GOTO 999
      ENDIF
C     
      CALL FTGKYS(UNIT,'EXTNAME',KEYSTR,STRING,STATUS)
      IF (STATUS.NE.0 .OR. .NOT. ESAME(KEYSTR,'DATA')) THEN
         WRITE (*,*) 'Binary table extension 3 is not a molly spectrum.'
         CALL FTCLOS(UNIT,STATUS)
         IFAIL = 1
         GOTO 999
      ENDIF
C     
C     Read arc coeffcients
C     
      CALL FTGKYJ(UNIT,'NARC',NARC(SLOT),STRING,STATUS)
      CALL FTGKND(UNIT,'ARC',1,ABS(NARC(SLOT)),ARC(1,SLOT),NF,STATUS)
      IF (STATUS.NE.0 .OR. NF.NE.ABS(NARC(SLOT))) THEN
         WRITE (*,*) 'Failed to find all arc coefficients.'
         CALL FTCLOS(UNIT,STATUS)
         IFAIL = 1
         GOTO 999
      ENDIF
C     
C     Read counts/errors/fluxes
C     
      CALL FTGKYJ(UNIT,'NAXIS2',NPIX(SLOT),STRING,STATUS)
      CALL FTGCVE(UNIT,1,1,1,NPIX(SLOT),'-1.e-33',
     +     COUNTS(1,SLOT),ANYF, STATUS)
      CALL FTGCVE(UNIT,2,1,1,NPIX(SLOT),'-1.e-33',
     +     ERRORS(1,SLOT),ANYF, STATUS)
      CALL FTGCVE(UNIT,3,1,1,NPIX(SLOT),'-1.e-33',
     +     FLUX(1,SLOT),ANYF, STATUS)
C     

      IF (STATUS.EQ.0) THEN
         WRITE(*,*) 'Loaded ',FILE(:LENSTR(FILE)),' into slot ',SLOT
         CALL SL_INF(SLOT, MXSPEC, NPIX, NMCHAR, NMDOUB, NMINTR, 
     &        NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &        NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, STRING, 
     &        IFAIL)
         WRITE(*,*) STRING(:LENSTR(STRING))
         CALL FTCLOS(UNIT,STATUS)
         GOTO 100 
      ELSE
         WRITE (*,*) 'Error occured while reading file ',
     +        FILE(:LENSTR(FILE))
         IFAIL = 1
         GOTO 999
      ENDIF
C     
      CALL FTCLOS(UNIT,STATUS)
C     
 999  CLOSE(47)
      RETURN
      END
