      SUBROUTINE QPLOT(PLOT1, PLOT2, PLOT3, NPLOT, EPLOT,
     &     XLABEL, YLABEL, TLABEL, IFAIL)
*     
*     simple workhorse plot routine with interaction to select limits.
*     Leaves device open at end.
*     
      INTEGER NPLOT,  J
      REAL PLOT1(NPLOT), PLOT2(NPLOT), PLOT3(NPLOT)
      LOGICAL EPLOT, NEW
      CHARACTER*(*) XLABEL, YLABEL, TLABEL
      REAL XR1, XR2, YR1, YR2
C     
      IFAIL = 0
      XR1 =  1.E30
      XR2 = -1.E30
      DO J = 1, NPLOT
         XR1 = MIN(XR1, PLOT1(J))
         XR2 = MAX(XR2, PLOT1(J))
      END DO
      YR1 =  1.E30
      YR2 = -1.E30
      DO J = 1, NPLOT
         YR1 = MIN(YR1, PLOT2(J))
         YR2 = MAX(YR2, PLOT2(J))
      END DO
      XR1 = XR1 - (XR2-XR1)/20.
      XR2 = XR2 + (XR2-XR1)/20.
      YR1 = YR1 - (YR2-YR1)/20.
      YR2 = YR2 + (YR2-YR1)/20.
      CALL SET_LIM(XR1, XR2, YR1, YR2, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      CALL DEV_OPEN(.FALSE.,NEW,IFAIL)
      IF(IFAIL.NE.0) RETURN
      CALL PGSCI(5)
      CALL PGENV(XR1, XR2, YR1, YR2, 0, 0)
      CALL PGSCI(7)
      CALL PGLAB(XLABEL, YLABEL, TLABEL)
      CALL PGSCI(1)
      CALL PGBIN(NPLOT, PLOT1, PLOT2, .TRUE.)
      CALL PGSCI(2)
      IF(EPLOT) CALL PGBIN(NPLOT, PLOT1, PLOT3, .TRUE.)
      CALL PGSCI(1)
      RETURN
999   IFAIL = 1
      RETURN
      END
