      SUBROUTINE POWELL3(P,XI,N,NP,FTOL,ITER,FRET)
*
* Adapted from Numerical Recipes. Implements Powell's
* method for the minimisation of a function AMPROB
*
* R*4 P(N)      -- Initial parameter vector. On return contains best found.
* R*4 XI(NP,NP) -- Matrix with N initial directions of N elements each
*                  On return contains current direction set.
* I*4 N         -- Dimension of problem.
* I*4 NP        -- Actual dimension of matrix
* R*4 FTOL      -- Fractional tolerance. Iterations stop if function does
*                  not decrease by FTOL*function
* I*4 ITER      -- Number of iterations to take. On exit contains the number 
*                  taken
* R*4 FRET      -- Value of function at minimum.
*
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER NMAX
      PARAMETER (NMAX=100)
      DOUBLE PRECISION P(NP),XI(NP,NP),PT(NMAX),PTT(NMAX),XIT(NMAX)
*
      ITMAX = ITER
      FRET=AMPROB(P)
      DO J=1,N
        PT(J)=P(J)
      END DO
      ITER=0
1     ITER=ITER+1
      IBIG=0
      DEL=0.
      FP = FRET
      DO I=1,N
*
* Minimise along each search direction
*
        DO J=1,N
          XIT(J)=XI(J,I)
        END DO
        FPPT=FRET
        CALL LINMIN3(P,XIT,N,FRET)
*
* Record direction of largest decrease
*
        IF(ABS(FPPT-FRET).GT.DEL)THEN
          DEL=ABS(FPPT-FRET)
          IBIG=I
        END IF
      END DO
*
* No significant improvement. return
*
      IF(2.*ABS(FP-FRET).LE.FTOL*(ABS(FP)+ABS(FRET))) RETURN
      IF(ITER.EQ.ITMAX) THEN
        WRITE(*,*) 'Powell exceeded maximum iterations.'
        RETURN
      END IF
      DO J=1,N
        PTT(J)=2.*P(J)-PT(J)
        XIT(J)=P(J)-PT(J)
        PT(J)=P(J)
      END DO
      FPTT=AMPROB(PTT)
      IF(FPTT.GE.FP) GOTO 1
      T=2.*(FP-2.*FRET+FPTT)*(FP-FRET-DEL)**2-DEL*(FP-FPTT)**2
      IF(T.GE.0.)    GOTO 1
      CALL LINMIN3(P,XIT,N,FRET)
      DO J=1,N
        XI(J,IBIG)=XIT(J)
      END DO
      GO TO 1
      END

      SUBROUTINE LINMIN3(P,XI,N,FRET)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER NMAX
      DOUBLE PRECISION TOL
      PARAMETER (NMAX=10, TOL=3.D-4)
      EXTERNAL G1DIM
      DOUBLE PRECISION P(N),XI(N), G1DIM
      COMMON /G1COM/ PCOM(NMAX),XICOM(NMAX),NCOM
      NCOM=N
      DO J=1,N
        PCOM(J) =P(J)
        XICOM(J)=XI(J)
      ENDDO
      AX=0.
      XX=1.
      BX=2.
      CALL MNBRAK(AX,XX,BX,FA,FX,FB,G1DIM)
      FRET=BRENT(AX,XX,BX,G1DIM,TOL,XMIN)
      DO J=1,N
        XI(J)=XMIN*XI(J)
        P(J) =P(J)+XI(J)
      END DO
      RETURN
      END

      DOUBLE PRECISION FUNCTION G1DIM(X)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER NMAX
      PARAMETER (NMAX=10)
      COMMON /G1COM/ PCOM(NMAX),XICOM(NMAX),NCOM
      DOUBLE PRECISION XT(NMAX)
*
      DO J=1,NCOM
        XT(J)=PCOM(J)+X*XICOM(J)
      ENDDO
      G1DIM=AMPROB(XT)
      RETURN
      END
