*CLOSE
*
* CLOSE [ARG] -- Closes plot devices
*
* This has changed since the introduction of multiple device opening 
* in PGPLOT.
*
* CLOSE on its own closes the most recently selected device. [Nearest
*       equivalent to old version.]
* CLOSE ALL closes all open devices.
* CLOSE ID closes device with indentifier = ID.
*
* NB in order to support the straight "CLOSE" this routine will NOT
* propmt the user.
*
* Related commands: DEVICE, PCLOSE
*
*CLOSE
      SUBROUTINE PL_CLOSE(SPLIT, NSPLIT, MXSPLIT, IFAIL)
      IMPLICIT NONE
      INTEGER IFAIL, NSPLIT, MXSPLIT, ID
      CHARACTER*(*) SPLIT(MXSPLIT)
      LOGICAL ESAMECI
C     
      IF(NSPLIT.EQ.0) THEN
         CALL DEV_CLOSE(0, IFAIL)
         IF(IFAIL.EQ.1) WRITE(*,*) 'No devices were open.'
      ELSE IF(NSPLIT.EQ.1) THEN
         IF(ESAMECI(SPLIT(1),'ALL')) THEN
            CALL DEV_CLOSE(-1, IFAIL)
            IF(IFAIL.EQ.1) WRITE(*,*) 'No devices were open.'
         ELSE
            READ(SPLIT(1),*,IOSTAT=IFAIL) ID
            IF(IFAIL.NE.0) THEN
               WRITE(*,*) 'Could not understand argument: ',SPLIT(1)
            ELSE
               CALL DEV_CLOSE(ID,IFAIL)
               IF(IFAIL.EQ.1) THEN
                  WRITE(*,*) 'No devices were open.'
               ELSE IF(IFAIL.EQ.2) THEN
                  WRITE(*,*) 'Device ',ID,' was not open.'
               END IF
            END IF
         END IF
      ELSE
         WRITE(*,*) 'CLOSE only takes 1 argument.'
         IFAIL = 1
      END IF
      RETURN
      END
      
      
