CPBIN
C PBIN N1 N2 N3 P1 P2 NBIN PHASE METHOD WEIGHTS -- Phase bins spectra
C
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to average
C  N2    -- Slot number of last spectrum to average
C  N3    -- Slot in which to start 
C  P1    -- Start phase (start of first bin)
C  P2    -- End phase (end of last)
C  NBIN  -- Number of phase bins
C  PHASE -- Phase to use, choice of 7:
C           'O' -- Orbital phase 
C           'S' -- Spin phase 
C           'B' -- Beat phase 
C           'H' -- Hump phase 
C           '1' -- Phase1
C           '2' -- Phase2
C           '3' -- Phase3
C  METHOD - Averaging method. At present supports
C           U  -- Unit weights
C           D  -- Dwell weights
C           R  -- Response weights
C           V  -- Variance weights
C
C  WEIGHTS   -- file of weights. Whatever method is chosen, the weights can
C               be multiplied by individual weights first. <CR> to ignore
C               These can, for example, allow you to weight spectra with
C               a certain spin phase or whatever and provide a more flexible
C               method than straight selection.
C
C
C Response weights are proportional to the local ratio of COUNTS/FLUX
C and thus effectively add the counts together (optimum for photon
C counting data). Variance weights use a single value equal to the
C mean Signal/noise**2 for each spectrum.
C
C Selection is done. Spectra must have same length.
C
C Related commands: AVERAGE, GROUP
C
CPBIN
      SUBROUTINE PHSBIN(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL,
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &     VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, MXSDOUB, 
     &     MXSINTR, MXSREAL, WORK1, WORK2, WORK3, WORK4, MXWORK, 
     &     SLOTS, WSLOTS, WEIGHTS, PHASES, MXSLOTS, MUTE, IFAIL)
C     
C     Phase bins spectra
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
C     >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
C     >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
C     >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
C     >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
C     >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
C     >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
C     >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
C     >  I     NSCHAR             -- Number of character selection items.
C     >  I     NSDOUB             -- Number of double precsion selection items.
C     >  I     NSINTR             -- Number of integer selection items.
C     >  I     NSREAL             -- Number of real selection items.
C     >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
C     >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
C     >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
C     >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.
C     >  R     WORK1(MXWORK) Work arrays
C     >  R     WORK2(MXWORK)
C     >  R     WORK3(MXWORK)
C     >  R     WORK4(MXWORK)
C     >  D     DWORK1(MXWORK)
C     >  I     MXWORK        Size of work arrays
C     >  I     SLOTS(MXSLOTS)   Array for list of slot numbers
C     >  R     WSLOTS(MXSLOTS)  Array for list of weights 
C     >  I     MXSLOTS         Size of list arrays 
C     >  L     MUTE
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE
C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL   FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Search parameters
C     
      INTEGER MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
C     
C     Search parameters, names then values.
C     
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
C     
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
      INTEGER MXWORK
      REAL WORK1(MXWORK), WORK2(MXWORK)
      REAL WORK3(MXWORK), WORK4(MXWORK)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT, SLT
      INTEGER SLOTS(MXSLOTS)
      REAL WSLOTS(MXSLOTS), WEIGHTS(MXSLOTS)
      DOUBLE PRECISION PHASES(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
C     Local variables
C     
      INTEGER I, J
      INTEGER  NVAL, NCOM
      REAL GET_FLX, GET_ERF, CFRAT, W, VAR, WINIT
      DOUBLE PRECISION  SUM1, SUM2, PHS
      REAL START, END, X, Y, WONE
      CHARACTER*1 PHASE
      CHARACTER*64 FILENAME
      CHARACTER*100 STRING
      INTEGER SLOT1, SLOT2, SLOT3, NPHASE, NB
      INTEGER  IFAIL, NSAME, NASAM, NW, LENSTR
      INTEGER  MAXSPEC, IV, NS
      REAL   PLO, PHI
      LOGICAL SELECT,  DEFAULT, WARN,  MUTE
      CHARACTER*1 METHOD
C     
C     Functions
C     
C     
      DATA METHOD, PHASE/'U','O'/
      DATA SLOT1, SLOT2, SLOT3/1,2,3/
      DATA START, END, NPHASE/0.,1.,10/
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
C     
      CALL INTR_IN('First spectrum to phase bin', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
C     
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last spectrum to phase bin', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
C     
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST.GT.0) THEN
            CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
         ELSE
            WRITE(*,*) 'Enter list of spectra to phase bin'
            CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &           NSLOTS, MXSLOTS)
         END IF
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
      IF(NSLOTS.EQ.0) GOTO 999
C     
      CALL INTR_IN('First slot for binned spectra', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT3, 1, MAXSPEC, IFAIL)
      CALL REAL_IN('Start phase', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &     DEFAULT, START,-1.E30, 1.E30, IFAIL)
      CALL REAL_IN('End phase', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &     DEFAULT, END, START, 1.E30, IFAIL)
      CALL INTR_IN('Number of bins', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, NPHASE, 1, MAXSPEC-SLOT3+1, IFAIL)
      CALL CHAR_IN('Name of phase to bin', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, PHASE, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      CALL UPPER_CASE(PHASE)
      IF(PHASE.NE.'O' .AND. PHASE.NE.'S' .AND. PHASE.NE.'B'
     &     .AND. PHASE.NE.'H' .AND. PHASE.NE.'1' .AND. 
     &     PHASE.NE.'2' .AND. PHASE.NE.'3') THEN
         WRITE(*,*) 'Valid phases are:'
         WRITE(*,*) 'O -- Orbital phase'
         WRITE(*,*) 'S -- Spin phase'
         WRITE(*,*) 'B -- Beat phase'
         WRITE(*,*) 'H -- Hump phase'
         WRITE(*,*) '1 -- Phase1'
         WRITE(*,*) '2 -- Phase2'
         WRITE(*,*) '3 -- Phase3'
         PHASE = 'O'
         GOTO 999
      END IF              
C     
C     Check spectra
C     
      NSAME = 0
      WARN  = .FALSE.
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF( NPIX(SLOT).GT.0) THEN
            IF(NPIX(SLOT).GT.MXWORK) THEN
               WRITE(*,*) 'Too many pixels for work array'
               WRITE(*,*) 'Slot ',SLOT,' has ',NPIX(SLOT),' pixels.'
               GOTO 999
            END IF
C     
C     Check and store phases
C     
            IF(PHASE.EQ.'O') THEN
               CALL HGETD('ORBITAL PHASE', PHASES(I), SLOT, MXSPEC, 
     &              NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
            ELSE IF(PHASE.EQ.'S') THEN
               CALL HGETD('SPIN PHASE', PHASES(I), SLOT, MXSPEC, 
     &              NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
            ELSE IF(PHASE.EQ.'B') THEN
               CALL HGETD('BEAT PHASE', PHASES(I), SLOT, MXSPEC, 
     &              NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
            ELSE IF(PHASE.EQ.'H') THEN
               CALL HGETD('HUMP PHASE', PHASES(I), SLOT, MXSPEC, 
     &              NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
            ELSE IF(PHASE.EQ.'1') THEN
               CALL HGETD('PHASE1', PHASES(I), SLOT, MXSPEC, 
     &              NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
            ELSE IF(PHASE.EQ.'2') THEN
               CALL HGETD('PHASE2', PHASES(I), SLOT, MXSPEC, 
     &              NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
            ELSE IF(PHASE.EQ.'3') THEN
               CALL HGETD('PHASE3', PHASES(I), SLOT, MXSPEC, 
     &              NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
            END IF
            IF(IFAIL.NE.0) THEN
               WRITE(*,*) 'Could not find phase in slot ',SLOT
               GOTO 999
            END IF
C     
            IF(METHOD.EQ.'D') THEN
               CALL HGETR('DWELL', W, SLOT, MXSPEC, NMREAL,
     &              HDREAL, NREAL, MXREAL, IFAIL)
               IF(IFAIL.NE.0) THEN
                  WRITE(*,*) 'No dwell for slot ',SLOT
                  GOTO 999
               END IF
            END IF 
C     
            IF(NSAME.EQ.0) THEN
               NSAME  = NPIX(SLOT)
               NASAM = NARC(SLOT)
               IV    = SLOT
            ELSE IF(NSAME.NE.NPIX(SLOT)) THEN
               WRITE(*,*) 'Spectra are not all of the same length.'
               GOTO 999
            ELSE IF(NARC(SLOT).NE.NASAM) THEN
               WARN = .TRUE.
            ELSE
               DO J = 1, ABS(NASAM)
                  WARN = WARN .OR. 
     &                 ABS(ARC(J,SLOT)-ARC(J,IV)).GT.
     &                 1.D-5*ABS(ARC(J,IV))
               END DO
            END IF
         END IF
      END DO
      IF(WARN) THEN
         WRITE(*,*) '** Wavelength scales are not identical.'     
         WRITE(*,*) 'will carry on however.'
      END IF
C     
      CALL CHAR_IN('Averaging method (U,D,R,V)', SPLIT, 
     &     NSPLIT, MXSPLIT, NCOM, DEFAULT, METHOD, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      CALL UPPER_CASE(METHOD)
      IF(METHOD.NE.'U' .AND. METHOD.NE.'D' .AND. METHOD.NE.'R'
     &     .AND. METHOD.NE.'V') THEN
         WRITE(*,*) 'Invalid averaging method'
         WRITE(*,*) 'Possibilities are:'
         WRITE(*,*) 'U -- Unit weights.'
         WRITE(*,*) 'D -- Dwell weights.'
         WRITE(*,*) 'R -- Response weights.'
         WRITE(*,*) 'V -- Variance weights.'
         METHOD = 'U'
         GOTO 999
      END IF
      FILENAME = ' '
      CALL CHAR_IN('File of weights', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, FILENAME, IFAIL)
      IF(FILENAME.NE.' ') THEN
         OPEN(UNIT=47,FILE=FILENAME,STATUS='OLD',IOSTAT=IFAIL)
         IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Failed to open ',FILENAME
            GOTO 999
         END IF
         IFAIL = 0
         DO I = 1, NSLOTS
            SLOT = SLOTS(I)
            IF( NPIX(SLOT).GT.0) THEN
               READ(47,*,IOSTAT=IFAIL) WSLOTS(I)
               IF(IFAIL.NE.0) THEN
                  WRITE(*,*) 'Failed to read a weight for spectrum ',
     &                 SLOT
                  CLOSE(UNIT=47)
                  GOTO 999
               END IF
            END IF
         END DO
         CLOSE(UNIT=47)
         WRITE(*,*) 'Read weights'
      END IF
C     
C     Now loop through bins.
C     
      NS = 0
      DO NB = 1, NPHASE
C     
C     Compute limits of bin
C     
         PLO = START + (END-START)*REAL(NB-1)/REAL(NPHASE)
         PHI = START + (END-START)*REAL(NB  )/REAL(NPHASE)
C     
C     Loop through list
C     
         IF(.NOT.MUTE) WRITE(*,*) 'Phase bin: ',NB,' ',PLO,' to ',PHI
C     
C     Initialise
C     
         DO I = 1, MIN(MXWORK, MAXPX)
            WORK1(I) = 0.
            WORK2(I) = 0.
            WORK3(I) = 0.
            WORK4(I) = 0.
         END DO
         NVAL  = 0
         WONE = -1.
         DO I = 1, NSLOTS
            SLOT = SLOTS(I)
            WEIGHTS(I) = -1.
            IF( NPIX(SLOT).GT.0 .AND.
     &           SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, 
     &           HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, 
     &           NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC,
     &           NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, 
     &           NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, 
     &           MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN
C     
               PHS = PHASES(I)
C     
C     Check whether phase is in range
C     
               PHS = PHS - DBLE(NINT(PHS))
               IF(PHS.LT.0.D0) PHS = PHS + 1.D0
               X = PLO - FLOAT(NINT(PLO))
               Y = PHI - FLOAT(NINT(PLO))
               IF(X.LT.0.) THEN
                  X = X + 1.
                  Y = Y + 1.
               END IF
               IF((PHS.GT.X .AND. PHS.LE.Y) .OR. 
     &              (PHS+1.).LE.Y) THEN
                  NVAL = NVAL + 1
C     
C     Compute weight for this spectrum
C     
                  IF(FILENAME.NE.' ') THEN
                     WINIT = WSLOTS(I)
                  ELSE
                     WINIT = 1.
                  END IF
                  IF(METHOD.EQ.'U') THEN
                     W = WINIT
                  ELSE IF(METHOD.EQ.'D') THEN
                     CALL HGETR('DWELL', W, SLOT, MXSPEC, NMREAL,
     &                    HDREAL, NREAL, MXREAL, IFAIL)
                     W = WINIT*W
                  ELSE IF(METHOD.EQ.'V') THEN
                     SUM1 = 0.D0
                     SUM2 = 0.D0
                     DO J = 1, NSAME
                        IF(ERRORS(J,SLOT).GT.0.) THEN
                           SUM1 = SUM1 + GET_FLX(COUNTS(J,SLOT), 
     &                          FLUX(J,SLOT))
                           SUM2 = SUM2 + GET_ERF(COUNTS(J,SLOT), 
     &                          ERRORS(J,SLOT), FLUX(J,SLOT))**2
                        END IF
                     END DO
                     W = REAL(WINIT*SUM1/SUM2)
                  END IF
C     
C     Add into work array
C     
                  SUM1 = 0.
                  NW = 0
                  DO J = 1, NSAME
                     IF(ERRORS(J,SLOT).GT.0.) THEN
                        IF(METHOD.EQ.'R') THEN
                           W = WINIT*CFRAT(COUNTS(J,SLOT), FLUX(J,SLOT))
                        END IF
                        SUM1 = SUM1 + W
                        NW = NW + 1
                        WORK1(J) = WORK1(J) + W
                        WORK2(J) = WORK2(J) + W*GET_FLX(COUNTS(J,SLOT), 
     &                       FLUX(J,SLOT))
                        VAR = (W*GET_ERF(COUNTS(J,SLOT), ERRORS(J,SLOT),
     &                       FLUX(J,SLOT)))**2
                        WORK3(J) = WORK3(J) + VAR
                        WORK4(J) = WORK4(J) + W/CFRAT(COUNTS(J,SLOT), 
     &                       FLUX(J,SLOT))
                     END IF
                  END DO
                  IF(NW.GT.0) THEN
                     IF(WONE.LT.0.) WONE = REAL(SUM1/FLOAT(NW))
                     WEIGHTS(I) = REAL(SUM1/FLOAT(NW)/WONE)
                     IF(.NOT.MUTE) WRITE(*,'(A,I5,A,F8.4,A,F7.5)')
     &                    ' Added in slot ',SLOT,', weight ',WEIGHTS(I),
     &                    ', phase ',PHS
                  ELSE 
                     NVAL = NVAL - 1
                  END IF
               END IF
            END IF
         END DO
         IF(MUTE) WRITE(*,'(1X,I4,A,I4,A,F8.6,A,F8.6)') 
     &        NVAL,' spectra added to bin: ',NB,' ',PLO,' to ',PHI
         IF(NVAL.LE.0) THEN
            IF(.NOT.MUTE) 
     &           WRITE(*,*) 'No valid spectra in this phase range'
            GOTO 200
         END IF
         NS = NS + 1
C     
C     Store result in output slot
C     
         SLT = SLOT3 + NS - 1
         DO I = 1, NSAME
            IF(WORK3(I).GT.0.) THEN
               COUNTS(I,SLT) = WORK2(I)/WORK4(I)
               ERRORS(I,SLT) = SQRT(WORK3(I))/WORK4(I)
               IF(COUNTS(I,SLT).EQ.0.) THEN
                  FLUX(I,SLT) = WORK1(I)/WORK4(I)
               ELSE
                  FLUX(I,SLT) = WORK2(I)/WORK1(I)
               END IF
            ELSE
               ERRORS(I,SLT) = -1.
            END IF
         END DO
C     
C     Average headers
C     
         CALL HEDAVE(SLT, SLOTS, WEIGHTS, NSLOTS, MXSPEC, NPIX, 
     &        ARC, NARC, MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, 
     &        HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, 
     &        MXCHAR, MXDOUB, MXINTR, MXREAL, IFAIL)
C     
         IF(.NOT.MUTE) THEN
            CALL SL_INF(SLT, MXSPEC, NPIX, NMCHAR, NMDOUB, NMINTR, 
     &           NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &           NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, STRING, 
     &           IFAIL)
            WRITE(*,*) 'Result stored in'
            WRITE(*,*) STRING(:LENSTR(STRING))
         END IF
C     
 200     CONTINUE
      END DO
C     
C     Give some warnings
C     
      WRITE(*,*) NS,' phase bins were filled.'
      WRITE(*,*) NPHASE-NS,' phase bins were empty.'
C     
 999  RETURN
      END
