*WNDF
* WNDF File N1 N2 -- Writes spectra to NDF files. Masked data will be
*                     set to the bad-pixel value.
*
* Parameters:
* 
*            FILE  -- Filename if one spectrum is to be dumped or root
*                     name to which '_1', '_2' etc will be added.
*            N1    -- First slot to write out
*            N2    -- Last slot to write out
*
* Header items are written into an extension called 'molly'. Data written by
* this routine can be read back in with 'LNDF'.
*
* Related command: LNDF
*
*WNDF
      SUBROUTINE NDFDMP(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, 
     &NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &MXREAL, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, 
     &NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, 
     &MXSDOUB, MXSINTR, MXSREAL, SLOTS, MXSLOTS, 
     &WORK1, WORK2, WORK3, MXWORK, IFAIL)
*
* Dumps spectra to an NDF file.
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
* >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
* >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
* >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
* >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
* >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
* >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
* >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
* >  I     NSCHAR             -- Number of character selection items.
* >  I     NSDOUB             -- Number of double precsion selection items.
* >  I     NSINTR             -- Number of integer selection items.
* >  I     NSREAL             -- Number of real selection items.
* >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
* >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
* >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
* >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
*    I     SLOTS(MXSLOTS)
*    I     MXSLOTS
*    R     WORK1(MXWORK)
*    R     WORK2(MXWORK)
*    R     WORK3(MXWORK)
*    I     IWORK(MXWORK)
*    I     MXWORK
*
      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INCLUDE 'DAT_PAR'
      INCLUDE 'PRM_PAR'
      INCLUDE 'CNF_PAR'
*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL, MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Search parameters, names then values.
*
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
      INTEGER MXWORK
      REAL WORK1(MXWORK), WORK2(MXWORK)
      REAL WORK3(MXWORK)
*
* Local variables
*
      CHARACTER*64 FILENAME
      CHARACTER*32 CVAL
      REAL RVAL, GET_FLX, GET_ERF
      DOUBLE PRECISION DVAL
      INTEGER IVAL, SLOT1, SLOT2, IFAIL, N, NV
      INTEGER I, J, MAXSPEC, NCOM, L, STATUS
      INTEGER MOLL, PLACE, DPTR, EL, EPTR, XPTR
      LOGICAL SELECT, DEFAULT
      CHARACTER*(DAT__SZLOC) LOC
C
C Functions
C     
      INTEGER LENSTR
      DOUBLE PRECISION ANGST
*     
      DATA FILENAME/'spec'/
      DATA SLOT1, SLOT2/1,1/
*     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
      CALL CHAR_IN('File name', SPLIT, NSPLIT, MXSPLIT, NCOM,
     &     DEFAULT, FILENAME, IFAIL)
      CALL INTR_IN('First slot to dump', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to dump', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST.GT.0) THEN
            CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
         ELSE
            WRITE(*,*) 'Enter list of spectra to dump'
            CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &           NSLOTS, MXSLOTS)
         END IF
         IF(NSLOTS.EQ.0) THEN
            IFAIL = 1
            GOTO 999
         END IF
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
C     
C     Count valid spectra
C     
      NV = 0
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF(NPIX(SLOT).GT.0 .AND. NARC(SLOT).NE.0 .AND. 
     &        SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, 
     &        HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &        NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &        MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, 
     &        VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &        NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN
            NV = NV + 1
         END IF
      END DO
      IF(NV.EQ.0) THEN
         WRITE(*,*) 'No valid spectra selected'
         GOTO 999
      END IF
C     
      STATUS = SAI__OK
      N = 0
      L = LENSTR(FILENAME)
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF(NPIX(SLOT).LE.0 .OR. NARC(SLOT).EQ.0 .OR. 
     &        .NOT.SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, 
     &        HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &        NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &        MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, 
     &        VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &        NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN
            WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
         ELSE
C     
C     Load work arrays
C     
            DO J = 1, NPIX(SLOT)
               WORK3(J) = REAL(ANGST(REAL(J),NPIX(SLOT),NARC(SLOT),
     &              ARC(1,SLOT), MXARC))
               IF(ERRORS(J,SLOT).GT.0) THEN
                  WORK1(J) = GET_FLX(COUNTS(J,SLOT), FLUX(J,SLOT))
                  WORK2(J) = GET_ERF(COUNTS(J,SLOT), ERRORS(J,SLOT), 
     &                 FLUX(J,SLOT))
               ELSE
                  WORK1(J) = VAL__BADR
                  WORK2(J) = VAL__BADR
               END IF
            END DO
C     
C     generate file name
C     
            N = N + 1
            IF(NV.GT.1 .AND. N.LE.9) THEN
               WRITE(FILENAME(L+1:L+2),'(A,I1)') '_',N
            ELSE IF(N.GT.9 .AND. N.LE.99) THEN
               WRITE(FILENAME(L+1:L+3),'(A,I2)') '_',N
            ELSE IF(N.GT.99 .AND. N.LE.999) THEN
               WRITE(FILENAME(L+1:L+4),'(A,I3)') '_',N
            ELSE IF(N.GT.999 .AND. N.LE.9999) THEN
               WRITE(FILENAME(L+1:L+5),'(A,I4)') '_',N
            END IF
C     
C     Open NDF file
C     
            CALL NDF_OPEN(DAT__ROOT,FILENAME,'WRITE','NEW',MOLL,
     &           PLACE,STATUS)
            CALL NDF_NEW('_REAL',1,1,NPIX(SLOT),PLACE,MOLL,STATUS)
            CALL NDF_MAP(MOLL,'Data','_REAL','WRITE',DPTR,EL,STATUS)
            CALL NDF_MAP(MOLL,'Error','_REAL','WRITE',EPTR,EL,STATUS)
            CALL NDF_AMAP(MOLL,'Centre',1,'_REAL','WRITE',XPTR,
     &           EL,STATUS)
C     
C     Transfer data
C     
            CALL DAT_MV(WORK1, %VAL(CNF_PVAL(DPTR)), NPIX(SLOT), STATUS)
            CALL DAT_MV(WORK2, %VAL(CNF_PVAL(EPTR)), NPIX(SLOT), STATUS)
            CALL DAT_MV(WORK3, %VAL(CNF_PVAL(XPTR)), NPIX(SLOT), STATUS)
C     
C     Set labels etc
C     
            CALL NDF_ACPUT('Angstroms',MOLL,'Units',1,STATUS)
            CALL NDF_ACPUT('Wavelength',MOLL,'Label',1,STATUS)
            CALL NDF_CPUT('milliJanskys',MOLL,'Units',STATUS)
            CALL NDF_CPUT('Flux',MOLL,'Label',STATUS)
C     
C     Create molly extension, dump as many standard header items as poss.
C     
            CALL NDF_XNEW(MOLL,'MOLLY','Ext',0,0,LOC,STATUS)
C     
C     Object name
C     
            CALL HGETC('Object', CVAL, SLOT, MXSPEC, NMCHAR, HDCHAR,
     &           NCHAR, MXCHAR, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'OBJECT',  '_CHAR*32', 0, 0, STATUS)
               CALL CMP_PUT0C(LOC,'OBJECT',CVAL,STATUS)
            END IF
C     
C     UT at centre of exposure
C     
            CALL HGETD('UTC', DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'UTC',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'UTC',DVAL,STATUS)
            END IF        
C     
C     Equinox
C     
            CALL HGETD('Equinox', DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'EQUINOX',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'EQUINOX',DVAL,STATUS)
            END IF        
C     
C     RA
C     
            CALL HGETD('RA', DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'RA',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'RA',DVAL,STATUS)
            END IF        
C     
C     Declination
C     
            CALL HGETD('Dec', DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'DEC',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'DEC',DVAL,STATUS)
            END IF        
C     
C     Longitude
C     
            CALL HGETD('Longitude', DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'LONGITUDE',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'LONGITUDE',DVAL,STATUS)
            END IF        
C     
C     Latitude
C     
            CALL HGETD('Latitude', DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'LATITUDE',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'LATITUDE',DVAL,STATUS)
            END IF        
C     
C     Height
C     
            CALL HGETD('Height', DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'HEIGHT',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'HEIGHT',DVAL,STATUS)
            END IF        
C     
C     RJD
C     
            CALL HGETD('RJD', DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'RJD',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'RJD',DVAL,STATUS)
            END IF        
C     
C     HJD
C     
            CALL HGETD('HJD', DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'HJD',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'HJD',DVAL,STATUS)
            END IF        
C     
C     Delay
C     
            CALL HGETD('DELAY', DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'DELAY',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'DELAY',DVAL,STATUS)
            END IF        
C     
C     VEARTH
C     
            CALL HGETD('VEARTH', DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'VEARTH',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'VEARTH',DVAL,STATUS)
            END IF        
C     
C     Sidereal time
C     
            CALL HGETD('Sidereal time', DVAL, SLOT, MXSPEC, NMDOUB, 
     &           HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'SIDEREAL_TIME',  '_DOUBLE', 0, 
     &              0, STATUS)
               CALL CMP_PUT0D(LOC,'SIDEREAL_TIME',DVAL,STATUS)
            END IF        
C     
C     Airmass
C     
            CALL HGETD('Airmass', DVAL, SLOT, MXSPEC, NMDOUB, 
     &           HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'AIRMASS',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'AIRMASS',DVAL,STATUS)
            END IF        
C     
C     Hour angle
C     
            CALL HGETD('Hour angle', DVAL, SLOT, MXSPEC, NMDOUB, 
     &           HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'HOUR_ANGLE',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'HOUR_ANGLE',DVAL,STATUS)
            END IF        
C     
C     Altitude
C     
            CALL HGETD('Altitude', DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'Altitude',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'Altitude',DVAL,STATUS)
            END IF        
C     
C     Azimuth
C     
            CALL HGETD('Azimuth', DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'Azimuth',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'Azimuth',DVAL,STATUS)
            END IF        
C     
C     Orbital phase
C     
            CALL HGETD('Orbital phase', DVAL, SLOT, MXSPEC, NMDOUB, 
     &           HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'ORBITAL_PHASE',  '_DOUBLE', 
     &              0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'ORBITAL_PHASE',DVAL,STATUS)
            END IF        
C     
C     Zero point of orbital ephemeris
C     
            CALL HGETD('ZeroO', DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'ZEROO',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'ZEROO',DVAL,STATUS)
            END IF        
C     
C     Orbital period
C     
            CALL HGETD('PeriodO', DVAL, SLOT, MXSPEC, NMDOUB, HDDOUB,
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'PERIODO',  '_DOUBLE', 0, 0, STATUS)
               CALL CMP_PUT0D(LOC,'PERIODO',DVAL,STATUS)
            END IF        
C
C     Run number
C     
            CALL HGETI('Record', IVAL, SLOT, MXSPEC, NMINTR, HDINTR,
     &           NINTR, MXINTR, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'RECORD',  '_INTEGER', 0, 0, STATUS)
               CALL CMP_PUT0i(LOC,'RECORD',IVAL,STATUS)
            END IF
C     
C     Day
C     
            CALL HGETI('Day', IVAL, SLOT, MXSPEC, NMINTR, HDINTR,
     &           NINTR, MXINTR, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'DAY',  '_INTEGER', 0, 0, STATUS)
               CALL CMP_PUT0I(LOC,'DAY',IVAL,STATUS)
            END IF
C
C     Month
C
            CALL HGETI('Month', IVAL, SLOT, MXSPEC, NMINTR, HDINTR,
     &           NINTR, MXINTR, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'MONTH',  '_INTEGER', 0, 0, STATUS)
               CALL CMP_PUT0I(LOC,'MONTH',IVAL,STATUS)
            END IF
C
C     Year
C
            CALL HGETI('Year', IVAL, SLOT, MXSPEC, NMINTR, HDINTR,
     &           NINTR, MXINTR, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'YEAR',  '_INTEGER', 0, 0, STATUS)
               CALL CMP_PUT0i(LOC,'YEAR',IVAL,STATUS)
            END IF
C
C     Night number
C     
            CALL HGETI('Night', IVAL, SLOT, MXSPEC, NMINTR, HDINTR,
     &           NINTR, MXINTR, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'NIGHT',  '_INTEGER', 0, 0, STATUS)
               CALL CMP_PUT0i(LOC,'NIGHT',IVAL,STATUS)
            END IF
C     
C     Exposure time
C     
            CALL HGETR('Dwell', RVAL, SLOT, MXSPEC, NMREAL, HDREAL,
     &           NREAL, MXREAL, IFAIL)
            IF(IFAIL.EQ.0) THEN
               CALL CMP_MOD(LOC, 'DWELL',  '_REAL', 0, 0, STATUS)
               CALL CMP_PUT0R(LOC,'DWELL',RVAL,STATUS)
            END IF
C
            CALL DAT_ANNUL(LOC, STATUS)
C     
C     Finish with NDF
C     
            CALL NDF_ANNUL(MOLL, STATUS)
            WRITE(*,*) 'Dumped slot ',SLOT,' to ',
     &           FILENAME(:LENSTR(FILENAME))
         END IF
      END DO                  
*     
 999  CONTINUE
      RETURN
      END	

      SUBROUTINE DAT_MV(INPUT, OUTPUT, N, STATUS)
      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INTEGER I, N, STATUS
      REAL INPUT(N), OUTPUT(N)
      IF(STATUS.NE.SAI__OK) RETURN
      DO I = 1, N
         OUTPUT(I) = INPUT(I)
      END DO
      RETURN
      END
