CLOG
C LOG N1 N2 N3 -- Takes natural log of spectra.
C
C Parameters: 
C     
C  N1  -- Start slot of first group to add
C  N2  -- End slot of first group to add
C  N3  -- First slot for results 
C
C
C Selection criteria apply. Negative pixels on the input spectrum are
C masked on output but otherwise left unchanged. For good pixels the
C new uncertainties become = error/flux where error is the orginal
C error and flux the original flux. This is the first order approx
C for small relative errors.
C
C Related commands: EXP
C
CLOG
CEXP
C EXP N1 N2 N3 -- Takes exponential of spectra.
C
C Parameters: 
C     
C  N1  -- Start slot of first group to add
C  N2  -- End slot of first group to add
C  N3  -- First slot for results 
C
C
C Selection criteria apply. Masked pixels are untouched. Pixels > 60
C are masked but otherwise left untouched to avoid possible overflow. 
C For good pixels the uncertainties become =  exp(flux)*error. 
C
C Related commands: LOG
C
CEXP
      SUBROUTINE MATHS(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL,
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     METHOD, SLOTS, MXSLOTS, MUTE, IFAIL)
C     
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     >  C     METHOD    -- TRUE for adding, FALSE for subtracting
C     I     SLOTS1(MXSLOTS)
C     I     SLOTS2(MXSLOTS)
C     I     MXSLOTS
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE

C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      CHARACTER*(*) METHOD
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Local variables
C     
      INTEGER I, L, N, LENSTR
      REAL CFRAT, GET_FLX, GET_ERF
      CHARACTER*100 STRING
      INTEGER SLOT1, SLOT2, SLOT3, SLOT, OUT
      INTEGER IFAIL
      INTEGER MAXSPEC, NCOM
      REAL FLX, RAT, ERR
      LOGICAL DEFAULT
      LOGICAL MUTE
      DATA SLOT1, SLOT2, SLOT3, NLIST/1,1,2,0/
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      NCOM  = 0
      IFAIL = 0
      CALL INTR_IN('First spectrum to process', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      IF(SLOT1.EQ.0) SLOT2 = 0
      CALL INTR_IN('Last spectrum to process', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST.GT.0) THEN
            CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, 
     &           NSLOTS, MXSLOTS)
         ELSE
            WRITE(*,*) 'Enter list of spectra to process'
            CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &           NSLOTS, MXSLOTS)
         END IF
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
C     
      CALL INTR_IN('First output slot', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, SLOT3, 1, MAXSPEC-NSLOTS+1, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
C     
      N = 0
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF( NPIX(SLOT).LE.0) THEN
            IF(.NOT.MUTE) THEN
               WRITE(*,*) 'Slot ',SLOT,' is empty and will be skipped.'
            END IF
         ELSE
C     
C     Slot number of output
C     
            OUT = SLOT3 + N
            N   = N + 1
C     
C     Set headers of output to headers of input spectrum
C     
            CALL SET_HEAD(OUT, SLOT, MXSPEC, NPIX, ARC, NARC, MXARC, 
     &           NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &           HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &           MXDOUB, MXINTR, MXREAL, IFAIL)
C     
            DO L = 1, NPIX(SLOT)
               ERRORS(L,OUT) = ERRORS(L,SLOT)
               IF(ERRORS(L,SLOT).GT.0.) THEN
                  RAT = CFRAT(COUNTS(L,SLOT),   FLUX(L,SLOT))
                  FLX = GET_FLX(COUNTS(L,SLOT), FLUX(L,SLOT))
                  ERR = GET_ERF(COUNTS(L,SLOT), ERRORS(L,SLOT), 
     &                 FLUX(L,SLOT))
C     
                  IF(METHOD.EQ.'L') THEN
                     IF(FLX.GT.0) THEN
                        ERR = ERR/FLX
                        FLX = LOG(FLX)
                     ELSE
                        ERR = -ABS(ERR)
                     END IF
                  ELSE IF(METHOD.EQ.'E') THEN
                     IF(FLX.LT.60.) THEN
                        FLX = EXP(FLX)
                        ERR = FLX*ERR
                     ELSE
                        ERR = -ABS(ERR)
                     END IF
                  END IF
C     
                  FLUX(L,OUT)   = FLX
                  ERRORS(L,OUT) = RAT*ERR
                  COUNTS(L,OUT) = RAT*FLX
                  IF(COUNTS(L,OUT).EQ.0.) FLUX(L,OUT) = RAT
               ELSE 
                  FLUX(L,OUT)   = FLUX(L,SLOT)
                  COUNTS(L,OUT) = COUNTS(L,SLOT)
               END IF
            END DO  
            IF(.NOT.MUTE) THEN
               IF(METHOD.EQ.'L') THEN
                  WRITE(*,*) 'Slot ',OUT,' = log(',SLOT,')'
               ELSE IF(METHOD.EQ.'E') THEN
                  WRITE(*,*) 'Slot ',OUT,' = exp(',SLOT,')'
               END IF
               CALL SL_INF(OUT, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &              NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &              NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &              MXINTR, MXREAL, STRING, IFAIL)  
               WRITE(*,*) STRING(:LENSTR(STRING))
            END IF
         END IF
      END DO
      WRITE(*,*) 'Finished'
 999  RETURN
      END
