      SUBROUTINE MASKIT(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &     NVMASK, MXMASK, COUNTS, ERRORS, FLUX, MXBUFF, MAXPX,
     &     NPIX, MXSPEC, NARC, ARC, MXARC, NMCHAR, NMDOUB, NMINTR,
     &     NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB,
     &     NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, PLOT1, 
     &     PLOT2, PLOT3, MXPLOT, LMASK)
C
C     Sets up spectrum mask for use in continuum fitting etc.
C
C     I PMASK(2,MXMASK) -- Pixels ranges masked (NPMASK of them)
C     R WMASK(2,MXMASK) -- Wavelength ranges masked (NWMASK of them)
C     R VMASK(3,MXMASK) -- Velocity ranges masked (NVMASK of them)
C     The third parameter is the central wavelength
C     used.
C
       IMPLICIT NONE
      INTEGER MXBUFF, MAXPX, MXSPEC, MXARC, MXPLOT
      REAL PLOT1(MXPLOT), PLOT2(MXPLOT), PLOT3(MXPLOT)
      LOGICAL LMASK(MXPLOT)
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
      INTEGER NPIX(MXSPEC), NARC(MXSPEC)
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
      INTEGER MXCHAR, MXDOUB, MXINTR, MXREAL
      INTEGER NCHAR(MXSPEC), NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC), NREAL(MXSPEC)
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
      INTEGER MXMASK, NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
C
      INTEGER MXSPLIT, NSPLIT
      PARAMETER (MXSPLIT=5)
      CHARACTER*64 SPLIT(MXSPLIT)
      CHARACTER*1 UDEF(1), UCOM(1)
C
      INTEGER IFAIL, SLOT, MAXSPEC, NPLOT, LENSTR
      LOGICAL RECOG, SAMECI, ESET, PLOT, DEFAULT
      CHARACTER*16 XAXIS, YAXIS
      CHARACTER*100 TLABEL, XLABEL
      CHARACTER*1 REPLY
      CHARACTER*8 CURS, HOW*10
      INTEGER PGBAND, I1, I2, I, NFIND, NCOM, L
      REAL X1, X2, Y1, Y2, X, Y, W0
      REAL YLO, YHI, DELTA
      DOUBLE PRECISION VEARTH
      LOGICAL COK, MASK, CONFRM
      COMMON/INGET/CONFRM
      CHARACTER*8 COMMS(8)
      CHARACTER*6 PROMPT
      SAVE SLOT, W0, HOW
      DATA SLOT,W0/1,5000./
      DATA COMMS/'CLEAR','DUMP','LOAD','MASK','UNMASK',
     &     'SHOW','PLOT','QUIT'/
      DATA HOW/'W'/

C     
C     No parameters passed by normal route. Interactive routine.
C     
      PLOT = .FALSE.
      COK  = .FALSE.
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
C     
      CALL SHMASK(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &     NVMASK, MXMASK)
C     
C     Command menu
C     
 100  WRITE(*,*) ' '
      WRITE(*,*) 'Masker options:'
      WRITE(*,*) ' '
      WRITE(*,*) ' clear   -- Clear the mask.'
      WRITE(*,*) ' dump    -- Dump mask to disk.'
      WRITE(*,*) ' load    -- Load mask from disk.'
      WRITE(*,*) ' mask    -- Mask.'
      WRITE(*,*) ' unmask  -- Unmask.'
      WRITE(*,*) ' show    -- Show mask.'
      WRITE(*,*) ' plot    -- Plot a spectrum for cursor.'
      WRITE(*,*) ' quit    -- Quit.'
C     
 101  WRITE(*,*) ' '
C     
C     NB Dynamic prompt because of C routines called
C     by 'CONTROL'. g77 does not work otherwise.
C     
      PROMPT = 'mask> '
      CALL CONTROL(NFIND, SPLIT, NSPLIT, MXSPLIT, COMMS, 
     &     8, UCOM, UDEF, 0, 1, CONFRM, ' ',' ', PROMPT, IFAIL)

      IF(SAMECI(COMMS(NFIND),'CLEAR')) THEN
         NPMASK = 0
         NWMASK = 0
         NVMASK = 0
      ELSE IF(SAMECI(COMMS(NFIND),'DUMP')) THEN
         CALL WRMASK(SPLIT, NSPLIT, MXSPLIT, PMASK, WMASK, 
     &        VMASK, NPMASK, NWMASK, NVMASK, MXMASK, IFAIL)
      ELSE IF(SAMECI(COMMS(NFIND),'LOAD')) THEN
         CALL RDMASK(SPLIT, NSPLIT, MXSPLIT, PMASK, WMASK, 
     &        VMASK, NPMASK, NWMASK, NVMASK, MXMASK, IFAIL)
      ELSE IF(SAMECI(COMMS(NFIND),'MASK') .OR.
     &        SAMECI(COMMS(NFIND),'UNMASK')) THEN
         IF(SAMECI(COMMS(NFIND),'MASK')) THEN
            MASK = .TRUE.
         ELSE
            MASK = .FALSE.
         END IF
         DEFAULT = .FALSE.
         IFAIL   = 0
         NCOM    = 0
         IF(COK)THEN
            CURS = 'C'
            CALL CHAR_IN('Set mask via C(ursor) or T(erminal)?', 
     &           SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, CURS, IFAIL)
            IF(.NOT.SAMECI(CURS,'C') .AND. 
     &           .NOT.SAMECI(CURS,'T')) THEN
               WRITE(*,*) 'Must use either C(ursor) or T(erminal)'
               GOTO 101
            END IF
         ELSE
            WRITE(*,*) 'Terminal input only available.'
            WRITE(*,*) 'You need to plot to a cursor-enabled device'
            WRITE(*,*) 'within ''masker'' to use a cursor.'
            CURS = 'T'
         END IF
         IF(SAMECI(CURS,'T')) THEN
            CALL CHAR_IN(
     &           'Mask in P(ixels), W(avelength) or V(elocity)?',
     &           SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, HOW, IFAIL)
            IF(HOW.EQ.' ') HOW = 'W'
            IF(.NOT.SAMECI(HOW,'P') .AND. 
     &           .NOT.SAMECI(HOW,'W') .AND.
     &           .NOT.SAMECI(HOW,'V')) THEN
               WRITE(*,*) 'Must be P, W or V.'
               GOTO 101
            END IF
            IF(SAMECI(HOW,'V')) THEN
               CALL REAL_IN('Central wavelength', SPLIT, NSPLIT, 
     &              MXSPLIT, NCOM, DEFAULT, W0, 1.E-2, 1.E6, IFAIL)
            END IF
         END IF
C     
C     Now get regions
C     
         IF(SAMECI(CURS,'C')) THEN
            WRITE(*,*) ' '
            WRITE(*,*) 
     &           'Select ranges by positioning cursor'//
     &           'and hitting any key except Q.'
            WRITE(*,*) 'Hitting Q will exit immediately.'
            WRITE(*,*) ' '
         END IF
 45      CONTINUE
         IF(SAMECI(CURS,'C')) THEN
            CALL PGSCI(2)
            WRITE(*,*) 'First position (Q to quit)'
            IFAIL = PGBAND(6, 1, 0., 0., X1, Y, REPLY)
            IF(SAMECI(REPLY,'Q')) GOTO 101
            WRITE(*,*) 'Second position (Q to quit)'
            X2 = X1
            IFAIL = PGBAND(6, 1, 0., 0., X2, Y, REPLY)
            IF(SAMECI(REPLY,'Q')) GOTO 101
            IF(CONFRM) WRITE(*,*) X1, X2
C     
C     Draw lines showing marked range
C     
            Y   = (Y1+Y2)/2.
            YLO = Y - (Y2-Y1)/50.
            YHI = Y + (Y2-Y1)/50.
            CALL PGSLS(2)
            CALL PGSCI(2)
            CALL PGMOVE(X1, Y)
            CALL PGDRAW(X2, Y)
            CALL PGSLS(1)
            CALL PGMOVE(X1, YLO)
            CALL PGDRAW(X1, YHI)
            CALL PGMOVE(X2, YLO)
            CALL PGDRAW(X2, YHI)
            CALL PGSCI(2)       
         ELSE
            IF(SAMECI(HOW,'P')) THEN
               WRITE(*,'(A,$)') 
     &              'Enter pixel range (0 0 to quit): '
            ELSE IF(SAMECI(HOW,'W')) THEN
               WRITE(*,'(A,$)') 
     &              'Enter angstrom range (0 0 to quit): '
            ELSE IF(SAMECI(HOW,'V')) THEN
               WRITE(*,'(A,$)') 
     &              'Enter velocity range (km/s) (0 0 to quit): '
            END IF
            READ(*,*,ERR=100) X1, X2
            IF(CONFRM) WRITE(*,*) X1, X2
            IF(X1.EQ.0. .AND. X2.EQ.0.) GOTO 101
         END IF
C     
C     Unmasked regions have X1 less than X2 (except
C     for pixel ranges which are just made negative
C     
         IF(SAMECI(HOW,'P')) THEN
            X1 = MAX(0.5, X1)
            X2 = MAX(0.5, X2)
         END IF
         IF(.NOT.MASK .AND. SAMECI(HOW,'P')) THEN
            IF(X2.LT.X1) THEN
               X  = -X2
               X2 = -X1
               X1 = X
            ELSE
               X1 = -X1
               X2 = -X2
            END IF
         ELSE IF((MASK .AND. X2.LT.X1) .OR. (.NOT.MASK
     &           .AND. X1.LT.X2)) THEN
            X = X2
            X2 = X1
            X1 = X
         END IF
         IF(SAMECI(HOW,'P')) THEN
            IF(NPMASK.EQ.MXMASK) THEN
               WRITE(*,*) 'Filled all pixel ranges ',MXMASK
               GOTO 101
            END IF
            NPMASK = NPMASK + 1
            PMASK(1,NPMASK) = NINT(X1)          
            PMASK(2,NPMASK) = NINT(X2)          
         ELSE IF(SAMECI(HOW,'W')) THEN
            IF(NWMASK.EQ.MXMASK) THEN
               WRITE(*,*) 'Filled all Angstrom ranges ',MXMASK
               GOTO 101
            END IF
            NWMASK = NWMASK + 1
            WMASK(1,NWMASK) = X1
            WMASK(2,NWMASK) = X2
         ELSE IF(SAMECI(HOW,'V')) THEN
            IF(NVMASK.EQ.MXMASK) THEN
               WRITE(*,*) 'Filled all velocity ranges ',MXMASK
               GOTO 101
            END IF
            NVMASK = NVMASK + 1
            VMASK(1,NVMASK) = X1
            VMASK(2,NVMASK) = X2
            VMASK(3,NVMASK) = W0
         END IF
         X1 = X2
         GOTO 45
      ELSE IF(SAMECI(COMMS(NFIND),'SHOW')) THEN
         CALL SHMASK(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &        NVMASK, MXMASK)
      ELSE IF(SAMECI(COMMS(NFIND),'PLOT')) THEN
         DEFAULT = .FALSE.
         IFAIL   = 0
         NCOM    = 0
         CALL INTR_IN('Plot which slot?', SPLIT, NSPLIT, MXSPLIT, 
     &        NCOM, DEFAULT, SLOT, 1, MAXSPEC, IFAIL)
         IF(IFAIL.NE.0) GOTO 101
         IF(NPIX(SLOT).LE.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' is empty.'
            GOTO 101
         END IF
         CALL SL_INF(SLOT, MXSPEC, NPIX, NMCHAR, NMDOUB, 
     &        NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &        NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &        MXINTR, MXREAL, TLABEL, IFAIL)
         WRITE(*,*) TLABEL(:LENSTR(TLABEL))
C     
         IF(NARC(SLOT).NE.0) THEN
            CALL CHAR_IN(
     &           'Plot in P(ixels), W(avelength) or V(elocity)?',
     &           SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, HOW, IFAIL)
            IF(SAMECI(HOW,'V')) THEN
               XAXIS = 'KM/S'
               CALL REAL_IN('Central wavelength', SPLIT, NSPLIT, 
     &              MXSPLIT, NCOM, DEFAULT, W0, 1.E-2, 1.E6, IFAIL)
            ELSE IF(SAMECI(HOW,'W')) THEN
               XAXIS = 'ANGSTROMS'
            ELSE IF(SAMECI(HOW,'P')) THEN
               XAXIS = 'PIXELS'
            ELSE
               WRITE(*,*) 'Must be pixels, wavelength or velocity.'
               GOTO 101
            END IF
         ELSE
            HOW   = 'P'
            XAXIS = 'PIXELS'
         END IF
         YAXIS = 'MILLIJANSKYS'
         CALL HGETD('Vearth', VEARTH, SLOT, MXSPEC, NMDOUB, 
     &        HDDOUB, NDOUB, MXDOUB, IFAIL)
         IFAIL = 0
C     
C     Load plot arrays
C     
         CALL PLOAD(PLOT1, PLOT2, PLOT3, NPLOT, MXPLOT, SLOT, 
     &        COUNTS, ERRORS, FLUX, MXBUFF, MAXPX, MXSPEC, NPIX, 
     &        ARC, NARC, MXARC, VEARTH, XAXIS, YAXIS, W0, 0., 
     &        0., ESET, DELTA, 0., IFAIL)
         IF(NPLOT.LE.0 .OR. IFAIL.NE.0) THEN
            WRITE(*,*) 'Failure in PLOAD'
            GOTO 101
         END IF
C     
C     Simple plot, leaves plot open at end. Close any plot
C     already open
C     
         IF(PLOT) CALL DEV_CLOSE(0,IFAIL)
         PLOT = .FALSE.
         CALL XTYPE(XAXIS, XLABEL, RECOG)
         CALL QPLOT(PLOT1, PLOT2, PLOT3, NPLOT, ESET,
     &        XLABEL, 'f\\d\\gn\\u (mJy)', TLABEL, IFAIL)
         IF(IFAIL.NE.0) GOTO 101
C     
C     Get mask
C     
         CALL APPMASK(LMASK,NPIX(SLOT),ARC(1,SLOT),NARC(SLOT),
     &        MXARC,PMASK,NPMASK,WMASK,NWMASK,VMASK,NVMASK,MXMASK,
     &        .TRUE.,VEARTH,IFAIL)
C     
C     Plot over masked regions in red and draw dashed lines
C     
         CALL PGQWIN(X1, X2, Y1, Y2)
         Y = (Y1+Y2)/2.
         YLO = Y - (Y2-Y1)/50.
         YHI = Y + (Y2-Y1)/50.
         CALL PGSCI(2)
         I1 = 0
         DO I = 1, NPIX(SLOT)
            IF(LMASK(I)) THEN
               IF(I1.EQ.0) I1 = I
               I2 = I
            ELSE IF(I1.GT.0) THEN
               CALL PGBIN(I2-I1+1,PLOT1(I1),PLOT2(I1),.TRUE.)
               X1 = PLOT1(I1)
               X2 = PLOT1(I2)
               CALL PGSLS(2)
               CALL PGMOVE(X1, Y)
               CALL PGDRAW(X2, Y)
               CALL PGSLS(1)
               CALL PGMOVE(X1, YLO)
               CALL PGDRAW(X1, YHI)
               CALL PGMOVE(X2, YLO)
               CALL PGDRAW(X2, YHI)
               I1 = 0
            END IF
         END DO
         IF(I1.GT.0) THEN
            CALL PGBIN(I2-I1+1,PLOT1(I1),PLOT2(I1),.TRUE.)
            X1 = PLOT1(I1)
            X2 = PLOT1(I2)
            CALL PGSLS(2)
            CALL PGMOVE(X1, Y)
            CALL PGDRAW(X2, Y)
            CALL PGSLS(1)
            CALL PGMOVE(X1, YLO)
            CALL PGDRAW(X1, YHI)
            CALL PGMOVE(X2, YLO)
            CALL PGDRAW(X2, YHI)
         END IF
C     
C     Plot over negative error regions in red, no dashed lines
C     
         I1 = 0
         DO I = 1, NPIX(SLOT)
            IF(ERRORS(I,SLOT).LE.0.) THEN
               IF(I1.EQ.0) I1 = I
               I2 = I
            ELSE IF(I1.GT.0) THEN
               CALL PGBIN(I2-I1+1,PLOT1(I1),PLOT2(I1),.TRUE.)
               I1 = 0
            END IF
         END DO
         IF(I1.GT.0) CALL PGBIN(I2-I1+1,PLOT1(I1),PLOT2(I1),.TRUE.)
         CALL PGSCI(1)     
         PLOT = .TRUE.
         CALL PGQINF('CURSOR',CURS,L)
         COK  = CURS.EQ.'YES'
         IF(COK) THEN
            CALL PGQWIN(X1, X2, Y1, Y2)
            X1  = (X1+X2)/2.
            Y   = (Y1+Y2)/2.
         END IF
      ELSE IF(SAMECI(COMMS(NFIND),'QUIT')) THEN
         IF(PLOT) CALL DEV_CLOSE(0,IFAIL)
         PLOT = .FALSE.
         RETURN
      ELSE 
         GOTO 100
      END IF
      GOTO 101
      END      

      SUBROUTINE APPMASK(MASK,NPIX,ARC,NARC,MXARC,
     &     PMASK,NPMASK,WMASK,NWMASK,VMASK,NVMASK,MXMASK,
     &     STATE,VSHIFT,IFAIL)
C     
C     Routine returns a logical array MASK(NPIX) with STATE for all
C     pixels defined by the mask arrays and .NOT.STATE for the others
C     where STATE is a user specified logical variable. 
C     Requires ARC coefficients if either NWMASK or NVMASK .gt. 0
C     
C     VSHIFT is a spurious velocity as introduced by Earth's motion for
C     example, which will be shifted out (KM/S)
C     
      IMPLICIT NONE
      INTEGER MXARC, MXMASK, NPMASK, NWMASK, NVMASK
      INTEGER NARC, NPIX, I, J, I1, I2, IFAIL
      LOGICAL MASK(NPIX), STATE, WHAT
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
      DOUBLE PRECISION ARC(MXARC), PIXL, W, W1, W2
      INTEGER MAXARC
      PARAMETER (MAXARC=20)
      DOUBLE PRECISION VSHIFT, ANEW(MAXARC)
      REAL CGS, VLIGHT
C     
      VLIGHT = CGS('C')/1.E5
      IF((NARC.EQ.0 .AND. (NWMASK.GT.0 .OR.
     &     NVMASK.GT.0)) .OR. ABS(NARC).GT.MAXARC) THEN
         IFAIL = 1
         RETURN
      END IF
      IFAIL = 0
C     
C     Fudge arc coefficients to remove this velocity to get
C     heliocentric wavelength scale
C     
      IF(ABS(NARC).GT.0) THEN
         DO J = 1, ABS(NARC)
            ANEW(J) = ARC(J)
         END DO
         IF(NARC.GT.0) THEN
            DO J = 1, NARC
               ANEW(J) = ANEW(J)*(1.-VSHIFT/VLIGHT)
            END DO
         ELSE
            ANEW(1) = ANEW(1) + LOG(1.D0- DBLE(VSHIFT/VLIGHT))
         END IF
      END IF
C     
C     Initialise
C     
      DO I = 1, NPIX
         MASK(I) = .NOT.STATE
      END DO
C     
C     Apply pixel mask. Mask is applied in the
C     order of setting up. Thus later settings
C     will always supercede the earliest.
C     
      DO J = 1, NPMASK
         IF(PMASK(1,J).LT.0) THEN
            WHAT = .NOT.STATE
            I1 = MAX(1, -PMASK(1,J))
            I1 = MIN(NPIX, I1)
            I2 = MAX(1, -PMASK(2,J))
            I2 = MIN(NPIX, I2)
         ELSE 
            WHAT = STATE
            I1 = MAX(1, PMASK(1,J))
            I1 = MIN(NPIX, I1)
            I2 = MAX(1, PMASK(2,J))
            I2 = MIN(NPIX, I2)
         END IF
         DO I = I1, I2
            MASK(I) = WHAT
         END DO
      END DO
C     
C     Apply wavelength mask
C     
      DO J = 1, NWMASK
         W1 = WMASK(1,J)
         W2 = WMASK(2,J)
         IF(W1.GT.W2) THEN
            WHAT = .NOT.STATE
            W  = W2
            W2 = W1
            W1 = W
         ELSE
            WHAT = STATE
         END IF
         I1 = NINT(PIXL(W1, NPIX, NARC, ANEW, MXARC))
         I2 = NINT(PIXL(W2, NPIX, NARC, ANEW, MXARC))
         I1 = MAX(1, I1)
         I1 = MIN(NPIX, I1)
         I2 = MAX(1, I2)
         I2 = MIN(NPIX, I2)
         IF(I1.GT.I2) THEN
            I = I1
            I1 = I2
            I2 = I
         END IF
         DO I = I1, I2
            MASK(I) = WHAT
         END DO
      END DO
C     
C     Apply velocity mask
C     
      DO J = 1, NVMASK
         W1 = VMASK(3,J)*(1.+VMASK(1,J)/VLIGHT)
         W2 = VMASK(3,J)*(1.+VMASK(2,J)/VLIGHT)
         IF(W1.GT.W2) THEN
            WHAT = .NOT.STATE
            W  = W2
            W2 = W1
            W1 = W
         ELSE
            WHAT = STATE
         END IF
         I1 = NINT(PIXL(W1, NPIX, NARC, ANEW, MXARC))
         I2 = NINT(PIXL(W2, NPIX, NARC, ANEW, MXARC))
         I1 = MAX(1, I1)
         I1 = MIN(NPIX, I1)
         I2 = MAX(1, I2)
         I2 = MIN(NPIX, I2)
         IF(I1.GT.I2) THEN
            I = I1
            I1 = I2
            I2 = I
         END IF
         DO I = I1, I2
            MASK(I) = WHAT
         END DO
      END DO
      RETURN
      END

      SUBROUTINE SHMASK(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &     NVMASK, MXMASK)
C     
C     Shows current mask.
C     
      IMPLICIT NONE
      INTEGER I
      INTEGER MXMASK, NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
C     
      WRITE(*,*) ' '
      IF(NPMASK.EQ.0 .AND. NWMASK.EQ.0 .AND.
     &     NVMASK.EQ.0) THEN
         WRITE(*,*) 'No mask set'
         RETURN
      END IF
      WRITE(*,*) 'Currently masked regions'
      WRITE(*,*) ' '
      DO I = 1, NPMASK
         IF(PMASK(1,I).LT.0) THEN
            WRITE(*,'(1X,A,I5,A,I5)') 'Unmasked pixels ',
     &           -PMASK(1,I),' to ',-PMASK(2,I)
         ELSE
            WRITE(*,'(1X,A,I5,A,I5)') 'Masked pixels ',
     &           PMASK(1,I),' to ',PMASK(2,I)
         END IF
      END DO
      DO I = 1, NWMASK
         IF(WMASK(1,I).LE.WMASK(2,I)) THEN
            WRITE(*,'(1X,A,G10.4,A,G10.4)') 
     &           'Masked Angstroms: ',WMASK(1,I),' to ',WMASK(2,I)
         ELSE
            WRITE(*,'(1X,A,G10.4,A,G10.4)') 
     &           'Unmasked Angstroms: ',WMASK(2,I),' to ',WMASK(1,I)
         END IF
      END DO
      DO I = 1, NVMASK
         IF(VMASK(1,I).LE.VMASK(2,I)) THEN
            WRITE(*,'(1X,A,G11.4,A,G11.4,A,G10.4,A)') 
     &           'Masked velocity ',VMASK(1,I),' to ',VMASK(2,I),
     &           ' wrt ',VMASK(3,I),' A.'
         ELSE
            WRITE(*,'(1X,A,G11.4,A,G11.4,A,G10.4,A)') 
     &           'Unmasked velocity ',VMASK(2,I),' to ',VMASK(1,I),
     &           ' wrt ',VMASK(3,I),' A.'
         END IF
      END DO
      RETURN
      END      

      SUBROUTINE WRMASK(SPLIT, NSPLIT, MXSPLIT, PMASK, WMASK, 
     &     VMASK, NPMASK, NWMASK, NVMASK, MXMASK, IFAIL)
C     
C     Writes mask to disk
C     
      IMPLICIT NONE
      INTEGER I, J, IFAIL, NSPLIT, MXSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
      CHARACTER*100 FILENAME
      INTEGER MXMASK, NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
      INTEGER LUNIT, NCOM
      LOGICAL CLOBBER, CONFRM, DEFAULT
      COMMON/INGET/CONFRM
      COMMON/MASK1/CLOBBER
      DATA LUNIT/24/
      DATA FILENAME/'lines.msk'/
C     
      IF(NPMASK.EQ.0 .AND. NWMASK.EQ.0 .AND.
     &     NVMASK.EQ.0) THEN
         WRITE(*,*) 'No mask set'
         IFAIL = 1
         RETURN
      END IF
      DEFAULT = .FALSE.
      IFAIL   = 0
      NCOM    = 0
      CALL CHAR_IN('Mask output file', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, FILENAME, IFAIL)
      IF(CLOBBER) THEN
         OPEN(UNIT=LUNIT,FILE=FILENAME,STATUS='UNKNOWN',
     &        FORM='FORMATTED',IOSTAT=IFAIL)
      ELSE
         OPEN(UNIT=LUNIT,FILE=FILENAME,STATUS='NEW',
     &        FORM='FORMATTED',IOSTAT=IFAIL)
      END IF
      IF(IFAIL.NE.0) THEN
         WRITE(*,*) 'Could not open ',FILENAME
         GOTO 998
      END IF
      WRITE(LUNIT,*,ERR=999) NPMASK, NWMASK, NVMASK
      WRITE(LUNIT,*,ERR=999) ((PMASK(I,J),I=1,2),J=1,NPMASK)     
      WRITE(LUNIT,*,ERR=999) ((WMASK(I,J),I=1,2),J=1,NWMASK)     
      WRITE(LUNIT,*,ERR=999) ((VMASK(I,J),I=1,3),J=1,NVMASK)     
      IFAIL = 0
 998  CLOSE(UNIT=LUNIT)
      RETURN
 999  CLOSE(UNIT=LUNIT)
      WRITE(*,*) 'Error writing to disc'
      IFAIL = 1
      RETURN
      END      

      SUBROUTINE RDMASK(SPLIT, NSPLIT, MXSPLIT, PMASK, WMASK, 
     &     VMASK, NPMASK, NWMASK, NVMASK, MXMASK, IFAIL)
C     
C     Reads mask from disk
C     
      IMPLICIT NONE
      INTEGER I, J, IFAIL, NSPLIT, MXSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
      CHARACTER*100 FILENAME
      INTEGER MXMASK, NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK), NCOM
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
      INTEGER LUNIT
      LOGICAL CONFRM, DEFAULT
      COMMON/INGET/CONFRM
      DATA LUNIT/24/
      DATA FILENAME/' '/
C     
      DEFAULT = .FALSE.
      IFAIL   = 0
      NCOM    = 0
      CALL CHAR_IN('Mask input file', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, FILENAME, IFAIL)
      OPEN(UNIT=LUNIT,FILE=FILENAME,STATUS='OLD',
     &     FORM='FORMATTED',IOSTAT=IFAIL)
      IF(IFAIL.NE.0) THEN
         WRITE(*,*) 'Could not open ',FILENAME
         GOTO 998
      END IF
      READ(LUNIT,*,ERR=999) NPMASK, NWMASK, NVMASK
      IF(NPMASK.GT.MXMASK .OR. NWMASK.GT.MXMASK .OR.
     &     NVMASK.GT.MXMASK) THEN
         WRITE(*,*) 'Mask too large for buffer ',MXMASK
         GOTO 998
      END IF
      READ(LUNIT,*,ERR=999) ((PMASK(I,J),I=1,2),J=1,NPMASK)     
      READ(LUNIT,*,ERR=999) ((WMASK(I,J),I=1,2),J=1,NWMASK)     
      READ(LUNIT,*,ERR=999) ((VMASK(I,J),I=1,3),J=1,NVMASK)     
 998  CLOSE(UNIT=LUNIT)
      RETURN
 999  CLOSE(UNIT=LUNIT)
      WRITE(*,*) 'Error reading from disc'
      RETURN
      END      

      SUBROUTINE SMASK(NPMASK, NWMASK, NVMASK, SET)
C     
C     Sets SET = 'YES' if no mask present, else 'NO'
C     
      INTEGER NPMASK, NWMASK, NVMASK
      CHARACTER*(*) SET
C    
      IF(NPMASK.EQ.0 .AND. NWMASK.EQ.0 .AND.
     &     NVMASK.EQ.0) THEN
         SET = 'YES'
      ELSE
         SET = 'NO'
      END IF
      RETURN
      END
