*LABEL
* LABEL File LW CH LEN FONT ANGLE JUST -- Labels a plot according to 
*                                      contents of a file.
*
*        Parameters:
*        
*          FILE  -- Filename with X,Y positions.
*          LW    -- Line width (integer)
*          CH    -- Character height as multiple of default.
*          LEN   -- Length of line as multiple of default. 0 or less to ignore.
*          FONT  -- Integer (PGPLOT fonts)
*          ANGLE -- Angle of label.
*          JUST  -- Justification (0=left,1=right) 
*
* The routine reads a table of X, Y positions and optionally a label and
* draws a short line with the label (or the X position if no label is 
* found) written at the end of the line.
* The output from 'CURSOR' can be used to label a plot. 
*
*LABEL
      SUBROUTINE LABEL(SPLIT, NSPLIT, MXSPLIT, IFAIL)
*
* Interactive routine for labelling plots. Assumes plot is open.
* 
* Arguments:
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE
*
* Local variables
*
      INTEGER IFAIL,  NSPLIT, MXSPLIT, FONT, FO, NCOM
      INTEGER NSTR, LW, LWO
      CHARACTER*(*) SPLIT(MXSPLIT)
      CHARACTER*64 FILE
      REAL X, Y, Z, CH, LINE, CHO, X1, X2, Y1, Y2
      REAL DASH, ANGLE, JUST
      LOGICAL DEFAULT
      CHARACTER*64 LAB, STRING, STR(3)
      DATA LW,CH,LINE,FONT,ANGLE,JUST/1,1.,1.,1,0.,0./
*
      IFAIL = 0
      NCOM  = 0
      DEFAULT = .FALSE.
      CALL CHAR_IN('File containing positions', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, FILE, IFAIL)
      OPEN(UNIT=31,FILE=FILE,STATUS='OLD',IOSTAT=IFAIL)
      IF(IFAIL.NE.0) THEN
        WRITE(*,*) 'Could not open ',FILE
        RETURN
      END IF
      CALL INTR_IN('Line width', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, LW, 1, 20, IFAIL)
      CALL REAL_IN('Character height', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, CH, 0., 1000., IFAIL)
      CALL REAL_IN('Line length', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, LINE, 0., 1000., IFAIL)
      CALL INTR_IN('Font (1-4)', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, FONT, 1, 4, IFAIL)
      CALL REAL_IN('Angle of label', SPLIT, NSPLIT, MXSPLIT, 
     &NCOM, DEFAULT, ANGLE, 0., 360., IFAIL)
      CALL REAL_IN('Justification (0=left,1=right)', SPLIT, 
     &NSPLIT, MXSPLIT, NCOM, DEFAULT, JUST, 0., 1., IFAIL)
*
      CALL PGQCH(CHO)
      CALL PGQCF(FO)
      CALL PGQLW(LWO)
      CALL PGSCF(FONT)
      CALL PGSCH(CH)
      CALL PGSLW(LW)
      CALL PGQWIN(X1, X2, Y1, Y2)
      DASH = LINE*(Y2-Y1)/20.
100   READ(31,'(A)',IOSTAT=IFAIL) STRING
      IF(IFAIL.LT.0) THEN
        WRITE(*,*) 'Reached end of file'
        IFAIL = 0
      ELSE IF(IFAIL.GT.0) THEN
        WRITE(*,*) 'Failed to read from file'
      ELSE
        CALL CSPLIT(STRING, STR, NSTR, 3, IFAIL)
        IF(IFAIL.NE.0) THEN
          WRITE(*,*) 'Failed to split ',STRING
          GOTO 999
        ELSE IF(NSTR.NE.2 .AND. NSTR.NE.3) THEN
          WRITE(*,*) 'Could not understand ',STRING
          GOTO 999
        END IF
        READ(STR(1),*,IOSTAT=IFAIL) X
        IF(IFAIL.NE.0) THEN
          WRITE(*,*) 'Could not understand X ',STR(1)
          GOTO 999
        END IF
        READ(STR(2),*,IOSTAT=IFAIL) Y
        IF(IFAIL.NE.0) THEN
          WRITE(*,*) 'Could not understand Y ',STR(2)
          GOTO 999
        END IF
        IF(LINE.GT.0.) THEN
          CALL PGMOVE(X,Y)
          Z = Y + DASH
          CALL PGDRAW(X,Z)
          Z = Y + DASH + CH*(Y2-Y1)/40.
        ELSE
          Z = Y
        END IF
        IF(NSTR.EQ.2) THEN
          WRITE(LAB,'(G13.7)') X
          CALL PGPTEXT(X,Z,ANGLE,JUST,LAB)
        ELSE
          CALL PGPTEXT(X,Z,ANGLE,JUST,STR(3))
        END IF
        GOTO 100
      END IF
999   CLOSE(UNIT=31)
      CALL PGSCH(CHO)
      CALL PGSCF(FO)
      CALL PGSLW(LWO)
      RETURN
      END
