*LHST
* LHST File N -- Loads HST ascii spectra
*
* Parameters
*         File -- File to load
*         N    -- First slot to read into
*
* LHST is rather specific to one format and may well not work on all
* ASCII data from HST.
*LHST
      SUBROUTINE HSTASC(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC,
     &NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &MXREAL, WORK1, WORK2, WORK3, MXWORK, IFAIL)
*
* Reads in HST ASCII files.
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  I     IFAIL     -- O if read ok
*
      IMPLICIT NONE
*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Work arrays
*
      INTEGER MXWORK
      DOUBLE PRECISION WORK1(MXWORK), WORK2(MXWORK)
      DOUBLE PRECISION WORK3(MXWORK)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Local variables
*
      CHARACTER*64 FILENAME
      INTEGER SLOT1,  IFAIL, LUNIT
      INTEGER I, J,  MAXSPEC
      INTEGER NS, N, NOLD, SLOT, NP
      REAL W, F, E, WAV, EMIN
      LOGICAL  DEFAULT
      REAL  VLIGHT, CGS, FAC, CFAC
      INTEGER NPOLY, MPOLY, NCOM, MAXPOLY
      PARAMETER (MAXPOLY=20)
      DOUBLE PRECISION FIT(MAXPOLY), XM(MAXPOLY,2*MAXPOLY+3)
      DOUBLE PRECISION FRACTION, RMS, CHISQ, POLY
*
* Functions
*
*
      DATA FILENAME/'SPECTRUM.MOL'/
      DATA SLOT1/1/
      DATA LUNIT/23/
*
      DEFAULT = .FALSE.
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      IFAIL = 0
      NCOM  = 0
      CALL CHAR_IN('File name', SPLIT, NSPLIT, MXSPLIT, NCOM,
     &DEFAULT, FILENAME, IFAIL)
      CALL INTR_IN('First slot to load into', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT1, 1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) RETURN
*
***************************************************************************
*
* Open file for reading
*
      OPEN(UNIT=LUNIT,FILE=FILENAME,FORM='FORMATTED',
     &     STATUS='OLD',IOSTAT=IFAIL)
      IF(IFAIL.NE.0) THEN
        WRITE(*,*) 'Could not open ',FILENAME
        RETURN
      END IF
*
* Start to read files, checking headers as we go.
*
      VLIGHT = CGS('C')
      CFAC = 1.E18/VLIGHT
      NOLD = 0
      SLOT = SLOT1
100   READ(LUNIT,*,IOSTAT=IFAIL) NS, N, W, F, E
      IF(NOLD.EQ.0) NOLD = NS
*
      IF((IFAIL.EQ.0 .AND. NOLD.NE.NS) .OR.
     &    IFAIL.LT.0) THEN
*
* Have reached end of spectrum.
* Store number of pixels, fit wavelength scale,
* convert to mJy.
*
        IF(WORK2(NP/2).GT.10.) THEN
          NPIX(SLOT) = NP
          EMIN = 1.E30
          DO I = 1, NP
            IF(ERRORS(I,SLOT).GT.0.) EMIN = MIN(EMIN, ERRORS(I,SLOT))
          END DO
          DO I = 1, NP
            IF(ERRORS(I,SLOT).LE.0.) ERRORS(I,SLOT) = EMIN 
          END DO
          DO I = 1, NP
            WORK1(I) = WORK1(I)/DBLE(NP)
          END DO
          NPOLY = 1
          MPOLY = MAX(NP-1, MAXPOLY)
          FRACTION = 1.D-2
150       CONTINUE
          NPOLY = NPOLY + 1
          CALL LEASQ(WORK1, WORK2, WORK3, NP, NPOLY, 
     &    FIT, CHISQ, XM, 1)
          RMS = 0.D0
          DO I = 1, NP
            RMS = RMS + (WORK2(I)-
     &          POLY(FIT,NPOLY,WORK1(I)))**2
            RMS = SQRT(RMS/DBLE(NP-NPOLY))
            RMS = RMS*DBLE(NP)/ABS(WORK2(NP)-WORK2(1))
          END DO
          WRITE(*,*) 'Slot ',SLOT,', NPOLY = ',NPOLY,
     &    ', RMS= ',SNGL(RMS),' pixels.'
          IF(RMS.GT.FRACTION .AND. NPOLY.LT.MPOLY) GOTO 150
          IF(RMS.GT.FRACTION) THEN
            WRITE(*,*) 'Could not fit X scale'
            WRITE(*,*) 'Will assume pixel scale instead'
            NARC(SLOT) = 0
          ELSE
            WRITE(*,*) 'Acceptable fit found'
            NARC(SLOT) = NPOLY
            DO I = 1, NPOLY
              ARC(I,SLOT) = FIT(I)
            END DO
          END IF
          DO J = 1, NPIX(SLOT)
            WAV = REAL(WORK2(J))
            FAC = CFAC*WAV**2
            FLUX(J,SLOT)   = FAC*FLUX(J,SLOT)
            ERRORS(J,SLOT) = FAC*ERRORS(J,SLOT)
            IF(FLUX(J,SLOT).EQ.0) THEN
              FLUX(J,SLOT) = 1.
              COUNTS(J,SLOT) = 0.
            ELSE
              COUNTS(J,SLOT) = FLUX(J,SLOT)
            END IF
          END DO
          WRITE(*,*) 'Spectrum stored in slot ',SLOT
          SLOT = SLOT + 1
          NOLD = NS
        ELSE
          WRITE(*,*) 'Invalid spectrum. Not stored.'
        END IF
      END IF
*
      IF(IFAIL.EQ.0) THEN
*
* Store another point, return for more.
*
        NP = N
        WORK1(N)      = DBLE(N)
        WORK2(N)      = W
        WORK3(N)      = 1.D0
        FLUX(N,SLOT)   = F
        ERRORS(N,SLOT) = E
        GOTO 100
      ELSE IF(IFAIL.LT.0) THEN
        WRITE(*,*) 'Finished reading spectra'
      ELSE IF(IFAIL.GT.0) THEN
        WRITE(*,*) 'Error during read'
      END IF
      IFAIL = 0
      CLOSE(UNIT=LUNIT)
      RETURN
      END
