CCHEAD
C CHEAD N1 N2 N3 WHICH TYPE -- Copies the headers of one set of spectra to 
C                  another, but preserves the wavelength scale of the spectra
C                  which receive the headers.
C
C Parameters: 
C     
C  N1    -- Slot number of first spectrum to copy headers from
C  N2    -- Slot number of last spectrum to copy headers from
C  N3    -- First slot to copy headers to. Only slots containing
C           valid spectra are affected.
C  WHICH -- Name of header item to be copied. 'all' for everything
C  TYPE  -- Data type of header item to be copied (if WHICH.NE.'all')
C           'C','D','I','R' for CHARACTER etc.
C
C Selection not applied.
CCHEAD
      SUBROUTINE HEDTRN(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &     SLOTS, MXSLOTS, IFAIL)
C     
C     Transfers headers
C     
C     Arguments:
C     
C     >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
C     >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
C     zero in which case defaults are used.
C     >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
C     <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
C     <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
C     <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
C     >  I     MXBUFF            -- Size of spectrum buffers in calling routine
C     >  I     MXSPEC           -- Maximum number of spectra allowed by size
C     of header buffers. 
C     >  I     MAXPX            -- Maximum number of pixels/spectrum
C     <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
C     <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
C     <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
C     >  I     MXARC            -- Maximum number of arc coefficients/spectrum
C     <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
C     <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
C     <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
C     <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
C     <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
C     <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
C     <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
C     <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
C     <  I     NCHAR(MXSPEC)  -- Number of character header items.
C     <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
C     <  I     NINTR(MXSPEC)  -- Number of integer items.
C     <  I     NREAL(MXSPEC)  -- Number of real items.
C     >  I     MXCHAR    -- Maximum number of character header items/spec
C     >  I     MXDOUB    -- Maximum number of double precsion header items/spec
C     >  I     MXINTR    -- Maximum number of integer header items/spec
C     >  I     MXREAL    -- Maximum number of real headers items/spec
C     I     SLOTS(MXSLOTS) -- Work array for list of slots
C     I     MXSLOTS
C     <  I     IFAIL              -- Error return.
C     
      IMPLICIT NONE

C     
C     Integer parameters
C     
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C     
C     Data arrays
C     
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL   FLUX(MAXPX,MXBUFF/MAXPX)
C     
C     Numbers of header items
C     
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C     
C     Names of header items
C     
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C     
C     Values of header items
C     
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C     
C     Arc coefficients
C     
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C     
C     Command parameters
C     
      INTEGER MXSPLIT, NSPLIT, NCOM
      CHARACTER*(*) SPLIT(MXSPLIT)
C     
C     Slot lists
C     
      INTEGER MXSLOTS, NSLOTS, SLOT, OUT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
C     
C     Local variables
C     
      INTEGER I, J, NAOLD, NV, NP, LENSTR
      CHARACTER*100 STRING
      CHARACTER*16 WHICH, DTYPE*3
      CHARACTER*32 CVAL
      DOUBLE PRECISION DVAL
      REAL RVAL
      INTEGER IVAL
      INTEGER SLOT1, SLOT2, SLOT3
      INTEGER IFAIL, MAXSPEC, MXIN
      LOGICAL DEFAULT, ESAMECI
      PARAMETER (MXIN=30)
      DOUBLE PRECISION STORE(MXIN), VEARTH
C     
      DATA SLOT1, SLOT2, SLOT3/1,1,2/
      DATA WHICH,DTYPE/'all','R'/
C     
C***********************************************************************
C     
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
C     
C     First slot
C     
      CALL INTR_IN('First spectrum defining headers', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
C     
C     Second slot
C     
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last spectrum defining headers', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         WRITE(*,*) 'Enter list of spectra to get headers from'
         CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &        NSLOTS, MXSLOTS)
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
      NV = 0
      DO I = 1, NSLOTS
         IF(NPIX(SLOTS(I)).GT.0) NV = NV + 1
      END DO
C     
C     First slot for output
C     
      CALL INTR_IN('First spectrum for headers', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT3, 1, MAXSPEC-NV+1, IFAIL)
      CALL CHAR_IN('Which header item to copy (''all'' for the lot)',
     &     SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, WHICH, IFAIL)
      IF(.NOT.ESAMECI(WHICH,'ALL')) THEN
         CALL CHAR_IN('What data type? (C,D,I,R)', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, DTYPE, IFAIL)
         IF(.NOT.ESAMECI(DTYPE,'C') .AND. 
     &        .NOT.ESAMECI(DTYPE,'D') .AND.
     &        .NOT.ESAMECI(DTYPE,'R') .AND.
     &        .NOT.ESAMECI(DTYPE,'I')) THEN
            WRITE(*,*) 'Must be C,D,R or I'
            DTYPE = 'R'
            GOTO 999
         END IF
      END IF
      IF(IFAIL.NE.0) GOTO 999
C     
C     Loop through spectra
C     
      NV = 0      
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF( NPIX(SLOT).LE.0) THEN
            WRITE(*,*) 'Slot ',SLOT,' empty; skipped.'
         ELSE
C     
C     Get output slot
C     
            NV = NV + 1
            OUT = SLOT3 + NV - 1
            IF(NPIX(OUT).GT.0) THEN
C     
C     Store arc and number of pixels
C     
               NAOLD = NARC(OUT)
               DO J = 1, ABS(NAOLD)
                  STORE(J) = ARC(J,OUT)
               END DO
               CALL HGETD('Vearth', VEARTH, OUT, MXSPEC, NMDOUB, 
     &              HDDOUB, NDOUB, MXDOUB, IFAIL)
               IFAIL = 0
               NP = NPIX(OUT)
               IF(ESAMECI(WHICH,'ALL')) THEN
C     
C     Set headers equal to those of input spectrum 
C     
                  CALL SET_HEAD(OUT, SLOT, MXSPEC, NPIX, ARC, NARC, 
     &                 MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, 
     &                 HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, 
     &                 NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, IFAIL)
               ELSE IF(ESAMECI(DTYPE,'C')) THEN
                  CALL HGETC(WHICH, CVAL, SLOT, MXSPEC, NMCHAR, 
     &                 HDCHAR, NCHAR, MXCHAR, IFAIL)
                  IF(IFAIL.NE.0) THEN
                     WRITE(*,*) WHICH,' not found in slot ',SLOT
                  ELSE
                     CALL HSETC(WHICH, CVAL, OUT, MXSPEC, NMCHAR, 
     &                    HDCHAR, NCHAR, MXCHAR, IFAIL)
                     IF(IFAIL.NE.0) THEN
                        WRITE(*,*) 'Could not set ',WHICH,' in slot ',
     &                       OUT
                     ELSE
                        IFAIL = 0
                     END IF
                  END IF
               ELSE IF(ESAMECI(DTYPE,'D')) THEN
                  CALL HGETD(WHICH, DVAL, SLOT, MXSPEC, NMDOUB, 
     &                 HDDOUB, NDOUB, MXDOUB, IFAIL)
                  IF(IFAIL.NE.0) THEN
                     WRITE(*,*) WHICH,' not found in slot ',SLOT
                  ELSE
                     CALL HSETD(WHICH, DVAL, OUT, MXSPEC, NMDOUB, 
     &                    HDDOUB, NDOUB, MXDOUB, IFAIL)
                     IF(IFAIL.NE.0) THEN
                        WRITE(*,*) 'Could not set ',WHICH,' in slot ',
     &                       OUT
                     ELSE
                        IFAIL = 0
                     END IF
                  END IF
               ELSE IF(ESAMECI(DTYPE,'I')) THEN
                  CALL HGETI(WHICH, IVAL, SLOT, MXSPEC, NMINTR, 
     &                 HDINTR, NINTR, MXINTR, IFAIL)
                  IF(IFAIL.NE.0) THEN
                     WRITE(*,*) WHICH,' not found in slot ',SLOT
                  ELSE
                     CALL HSETI(WHICH, IVAL, OUT, MXSPEC, NMINTR, 
     &                    HDINTR, NINTR, MXINTR, IFAIL)
                     IF(IFAIL.NE.0) THEN
                        WRITE(*,*) 'Could not set ',WHICH,' in slot ',
     &                       OUT
                     ELSE
                        IFAIL = 0
                     END IF
                  END IF
               ELSE IF(ESAMECI(DTYPE,'R')) THEN
                  CALL HGETR(WHICH, RVAL, SLOT, MXSPEC, NMREAL, 
     &                 HDREAL, NREAL, MXREAL, IFAIL)
                  IF(IFAIL.NE.0) THEN
                     WRITE(*,*) WHICH,' not found in slot ',SLOT
                  ELSE
                     CALL HSETR(WHICH, RVAL, OUT, MXSPEC, NMREAL, 
     &                    HDREAL, NREAL, MXREAL, IFAIL)
                     IF(IFAIL.NE.0) THEN
                        WRITE(*,*) 'Could not set ',WHICH,' in slot ',
     &                       OUT
                     ELSE
                        IFAIL = 0
                     END IF
                  END IF
               END IF
               IFAIL = 0
C     
C     Retrieve arc
C     
               CALL HSETD('Vearth', VEARTH, OUT, MXSPEC, NMDOUB, 
     &              HDDOUB, NDOUB, MXDOUB, IFAIL)
               IFAIL = 0
               NARC(OUT) = NAOLD
               DO J = 1, ABS(NAOLD)
                  ARC(J,OUT) = STORE(J) 
               END DO
               NPIX(OUT) = NP
               CALL SL_INF(OUT, MXSPEC, NPIX, NMCHAR, NMDOUB, NMINTR, 
     &              NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, 
     &              NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL,
     &              STRING, IFAIL)
               WRITE(*,*) STRING(:LENSTR(STRING))
            ELSE
               WRITE(*,*) 'Output empty; skipped'
            END IF
         END IF
      END DO
 999  RETURN
      END
