*HEDPLT
* HEDPLT N1 N2 Xname Xerr Xtype Yname Yerr Ytype 
*         -- Plots one header parameter versus another.
*
* Parameters
*
*  N1    -- First slot 
*  N2    -- Last slot 
*  Xname -- Name of header parameter for X axis. If entered on the command 
*           line and it has blanks or commas, it must be enclosed in quotes.
*           If the string NONE is entered, then a sequentially increasing
*           number will be plotted along the X axis.
*
*  Xerr  -- Header item to get 1-sigma uncertainty on X (plotted as
*           horizontal bar). <CR> to ignore.
*            
*  Xtype -- Data type D=Double precision,I=Integer,R=Real (Only if Xname not
*           'NONE'). Xerr is assumed to have same type.
*
*  Yname -- Name of header parameter for Y axis. If entered on the command 
*           line and it has blanks or commas, it must be enclosed in quotes.
*
*  Yerr  -- Header item to get 1-sigma uncertainty on Y (plotted as
*           vertical bar). <CR> to ignore.
*            
*  Ytype -- Data type D=Double precision,I=Integer,R=Real.
*           Yerr is assumed to have same type.                      
*
* Selection criteria apply.
*
*HEDPLT
      SUBROUTINE HEDPLT(SPLIT, NSPLIT, MXSPLIT, COUNTS,
     &     ERRORS, FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC,
     &     MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB,
     &     HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &     MXDOUB, MXINTR, MXREAL, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &     NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &     NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL, LW, LABCOL, 
     &     AXCOL, LABFON, LSIZE, ASIZE, ASPECT, CLOSE, X1, X2, Y1, 
     &     Y2, SLOTS, MXSLOTS, PLOT1, PLOT2, PLOT3, PLOT4, MXWORK, 
     &     IFAIL)
*
* Plots header parameters against each other
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
* >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
* >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
* >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
* >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
* >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
* >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
* >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
* >  I     NSCHAR             -- Number of character selection items.
* >  I     NSDOUB             -- Number of double precsion selection items.
* >  I     NSINTR             -- Number of integer selection items.
* >  I     NSREAL             -- Number of real selection items.
* >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
* >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
* >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
* >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
*                                incremented and returned by routine.
* >  I     LW                 -- Line width for plot.
* >  I     LABCOL, AXCOL, LABFON
* >  L     CLOSE              -- TRUE means plot will be closed before exiting
*                                routine
* >  I     SLOTS(MXSLOTS)       -- List of slots
* >  I     MXSLOTS             -- Maximum number in list
* >  R     PLOT1(MXWORK)      -- Plotting work array
* >  R     PLOT2(MXWORK)      -- Plotting work array
* >  R     PLOT3(MXWORK)      -- Plotting work array
* >  R     PLOT4(MXWORK)      -- Plotting work array
* >  I     MXWORK             -- Work array dimension
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE

*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL, MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
      LOGICAL CLOSE
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
      INTEGER MAXARC
      PARAMETER (MAXARC=20)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT, NCOM
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Search parameters, names then values.
*
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*
* Work arrays 
*
      INTEGER MXWORK 
      REAL PLOT1(MXWORK), PLOT2(MXWORK)
      REAL PLOT3(MXWORK), PLOT4(MXWORK)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
*
* Plot parameters
*
      INTEGER LW, LABCOL, AXCOL, LABFON, ASIZE
      REAL ASPECT, LSIZE
*
* Local variables
*
      INTEGER I,  NV, L, SLOT1, SLOT2, IFAIL, MAXSPEC
      INTEGER IVAL1, IVAL2, ILOW, LENSTR
      REAL X1, X2, Y1, Y2, RANGE, XR1, XR2, YR1, YR2
      REAL RVAL1, RVAL2
      LOGICAL SELECT, ESAMECI, DEFAULT, NEW
      DOUBLE PRECISION DVAL1, DVAL2
      DOUBLE PRECISION DXLOW, DXONE, DYLOW, DYONE
      CHARACTER*16 XNAME, XDTYP*1, YNAME, YDTYP*1     
      CHARACTER*16 XERR, YERR
      CHARACTER*64 XLABEL, YLABEL
*
      SAVE SLOT1, SLOT2, XNAME, XERR, XDTYP, YNAME, YERR, YDTYP
      DATA SLOT1, SLOT2/1,1/
      DATA XNAME, XERR, XDTYP/'HJD', ' ', 'D'/
      DATA YNAME, YERR, YDTYP/'HJD', ' ', 'D'/
C
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
      CALL INTR_IN('First slot for header plot', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot for header plot', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST.GT.0) THEN
            CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
         ELSE
            WRITE(*,*) 'Enter list of spectra for header plot'
            CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &           NSLOTS, MXSLOTS)
         END IF
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
*     
      CALL CHAR_IN('X axis header item', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, XNAME, IFAIL)
      IF(.NOT.ESAMECI(XNAME,'NONE')) THEN
         CALL CHAR_IN('X axis error header item (CR> to skip', 
     &        SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, XERR, IFAIL)
         CALL CHAR_IN('Data type of X header item (D,I, or R)',
     &        SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, XDTYP, IFAIL)
         IF(.NOT.ESAMECI(XDTYP,'D') .AND. .NOT.ESAMECI(XDTYP,'I')
     &        .AND. .NOT.ESAMECI(XDTYP,'R')) THEN
            WRITE(*,*) 'Must be either'
            WRITE(*,*) ' D = Double precision'
            WRITE(*,*) ' I = Integer'
            WRITE(*,*) ' R = Real'
            XDTYP = 'D'
            XNAME = 'HJD'
            GOTO 999
         END IF
      END IF
      CALL CHAR_IN('Y axis header item', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, YNAME, IFAIL)
      CALL CHAR_IN('Y axis error header item (CR> to skip', 
     &     SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, YERR, IFAIL)
      CALL CHAR_IN('Data type of Y header item (D,I, or R)',
     &     SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, YDTYP, IFAIL)
      IF(.NOT.ESAMECI(YDTYP,'D') .AND. .NOT.ESAMECI(YDTYP,'I')
     &     .AND. .NOT.ESAMECI(YDTYP,'R')) THEN
         WRITE(*,*) 'Must be either'
         WRITE(*,*) ' D = Double precision'
         WRITE(*,*) ' I = Integer'
         WRITE(*,*) ' R = Real'
         YDTYP = 'D'
         YNAME = 'HJD'
         GOTO 999
      END IF
*     
*     Get header values
*     
      NV = 0
      DXLOW = 1.D31
      DYLOW = 1.D31
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
*     
         IF(NPIX(SLOT).GT.0 .AND. 
     &        SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, 
     &        HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, 
     &        MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC, NMSCHAR, 
     &        VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &        VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, 
     &        MXSDOUB, MXSINTR, MXSREAL)) THEN
*     
            IF(ESAMECI(XNAME,'NONE')) THEN
               IF(NV.EQ.MXWORK) THEN
                  WRITE(*,*) 'Histogram buffer filled'
                  WRITE(*,*) 'Too many spectra'
                  GOTO 999
               END IF
               PLOT1(NV+1) = REAL(NV+1)
               IFAIL = 0
            ELSE
               IF(ESAMECI(XDTYP,'D')) THEN
                  CALL HGETD(XNAME,DVAL1,SLOT,MXSPEC,
     &                 NMDOUB,HDDOUB,NDOUB,MXDOUB,IFAIL)        
                  IF(IFAIL.EQ.0) THEN
                     IF(DXLOW.GT.1.D30) DXONE = DVAL1
                     DXLOW = MIN(DXLOW, DVAL1)
                     DVAL1 = DVAL1 - DXONE
                     IF(XERR.NE.' ') 
     &                    CALL HGETD(XERR,DVAL2,SLOT,MXSPEC,
     &                    NMDOUB,HDDOUB,NDOUB,MXDOUB,IFAIL)        
                  END IF
               ELSE IF(ESAMECI(XDTYP,'R')) THEN
                  CALL HGETR(XNAME,RVAL1,SLOT,MXSPEC,
     &                 NMREAL,HDREAL,NREAL,MXREAL,IFAIL)        
                  IF(IFAIL.EQ.0 .AND. XERR.NE.' ') THEN
                     CALL HGETR(XERR,RVAL2,SLOT,MXSPEC,
     &                    NMREAL,HDREAL,NREAL,MXREAL,IFAIL)        
                  END IF
               ELSE IF(ESAMECI(XDTYP,'I')) THEN
                  CALL HGETI(XNAME,IVAL1,SLOT,MXSPEC,
     &                 NMINTR,HDINTR,NINTR,MXINTR,IFAIL)        
                  IF(IFAIL.EQ.0 .AND. XERR.NE.' ') THEN
                     CALL HGETI(XERR,IVAL2,SLOT,MXSPEC,
     &                    NMINTR,HDINTR,NINTR,MXINTR,IFAIL)        
                  END IF
               END IF
               IF(IFAIL.EQ.0) THEN
                  IF(NV+1.GT.MXWORK) THEN
                     WRITE(*,*) 'Histogram buffer filled'
                     WRITE(*,*) 'Too many spectra'
                     GOTO 999
                  END  IF
                  IF(ESAMECI(XDTYP,'D')) THEN
                     PLOT1(NV+1) = REAL(DVAL1)
                     IF(XERR.NE.' ') PLOT2(NV+1) = REAL(DVAL2)
                  ELSE IF(ESAMECI(XDTYP,'R')) THEN
                     PLOT1(NV+1) = RVAL1
                     IF(XERR.NE.' ') PLOT2(NV+1) = RVAL2
                  ELSE IF(ESAMECI(XDTYP,'I')) THEN
                     PLOT1(NV+1) = REAL(IVAL1)
                     IF(XERR.NE.' ') PLOT2(NV+1) = REAL(IVAL2)
                  END IF
               END IF
            END IF
            IF(IFAIL.EQ.0) THEN  
               IF(ESAMECI(YDTYP,'D')) THEN
                  CALL HGETD(YNAME,DVAL1,SLOT,MXSPEC,
     &                 NMDOUB,HDDOUB,NDOUB,MXDOUB,IFAIL)        
                  IF(IFAIL.EQ.0) THEN
                     IF(DYLOW.GT.1.D30) DYONE = DVAL1
                     DYLOW = MIN(DYLOW, DVAL1)
                     DVAL1 = DVAL1 - DYONE
                     IF(YERR.NE.' ') 
     &                    CALL HGETD(YERR,DVAL2,SLOT,MXSPEC,
     &                    NMDOUB,HDDOUB,NDOUB,MXDOUB,IFAIL)        
                  END IF
               ELSE IF(ESAMECI(YDTYP,'R')) THEN
                  CALL HGETR(YNAME,RVAL1,SLOT,MXSPEC,
     &                 NMREAL,HDREAL,NREAL,MXREAL,IFAIL)        
                  IF(IFAIL.EQ.0 .AND. YERR.NE.' ') THEN
                     CALL HGETR(YERR,RVAL2,SLOT,MXSPEC,
     &                    NMREAL,HDREAL,NREAL,MXREAL,IFAIL)        
                  END IF
               ELSE IF(ESAMECI(YDTYP,'I')) THEN
                  CALL HGETI(YNAME,IVAL1,SLOT,MXSPEC,
     &                 NMINTR,HDINTR,NINTR,MXINTR,IFAIL)        
                  IF(IFAIL.EQ.0 .AND. YERR.NE.' ') THEN
                     CALL HGETI(YERR,IVAL2,SLOT,MXSPEC,
     &                    NMINTR,HDINTR,NINTR,MXINTR,IFAIL)        
                  END IF
               END IF
               IF(IFAIL.EQ.0) THEN
                  NV = NV + 1
                  IF(ESAMECI(YDTYP,'D')) THEN
                     PLOT3(NV) = REAL(DVAL1)
                     IF(YERR.NE.' ') PLOT4(NV) = REAL(DVAL2)
                  ELSE IF(ESAMECI(YDTYP,'R')) THEN
                     PLOT3(NV) = RVAL1
                     IF(YERR.NE.' ') PLOT4(NV) = RVAL2
                  ELSE IF(ESAMECI(YDTYP,'I')) THEN
                     PLOT3(NV) = REAL(IVAL1)
                     IF(YERR.NE.' ') PLOT4(NV) = REAL(IVAL2)
                  END IF
               END IF
            END IF  
         END IF
      END DO
      IF(NV.LE.0) THEN
         WRITE(*,*) 'No valid points found. Either the header'
         WRITE(*,*) 'items are not present or there are multiple'
         WRITE(*,*) 'matches to the names you specified.'
         RETURN
      END IF      
      IF(.NOT.ESAMECI(XNAME,'NONE')) THEN
         L = INDEX(XNAME,'_D')
         IF(L.GT.1) THEN
            XLABEL = XNAME(:L-1)
         ELSE
            XLABEL = XNAME
         END IF
         IF(ESAMECI(XDTYP,'D')) THEN
            ILOW = NINT(DXLOW-5.D-1)
            DXLOW = DBLE(ILOW)
            L = LENSTR(XLABEL)
            IF(ILOW.GT.0) THEN
               XLABEL(L+1:L+3) = ' - '
            ELSE
               XLABEL(L+1:L+3) = ' + '
               ILOW = - ILOW
            END IF
            WRITE(XLABEL(L+4:),*) ILOW
            DO I = 1, NV
               PLOT1(I) = PLOT1(I) + REAL(DXONE-DXLOW)
            END DO
         END IF
      END IF
      L = INDEX(YNAME,'_D')
      IF(L.GT.1) THEN
         YLABEL = YNAME(:L-1)
      ELSE
         YLABEL = YNAME
      END IF
      IF(ESAMECI(YDTYP,'D')) THEN
         ILOW = NINT(DYLOW-5.D-1)
         DYLOW = DBLE(ILOW)
         L = LENSTR(XLABEL)
         IF(ILOW.GT.0) THEN
            YLABEL(L+1:L+3) = ' - '
         ELSE
            YLABEL(L+1:L+3) = ' + '
            ILOW = - ILOW
         END IF
         WRITE(YLABEL(L+4:),*) ILOW
         DO I = 1, NV
            PLOT3(I) = PLOT3(I) + REAL(DYONE-DYLOW)
         END DO
      END IF
      IF(X1.EQ.X2) THEN
         XR1 = PLOT1(1)
         XR2 = XR1
         DO I = 1, NV
            XR1 = MIN(XR1, PLOT1(I))
            XR2 = MAX(XR2, PLOT1(I))
         END DO
         RANGE = XR2 - XR1
         XR1 =  XR1-RANGE/20.
         XR2 =  XR2+RANGE/20.
      ELSE
         XR1 = X1
         XR2 = X2
      END IF
      IF(Y1.EQ.Y2) THEN
         YR1 = PLOT3(1)
         YR2 = YR1
         DO I = 1, NV
            YR1 = MIN(YR1, PLOT3(I))
            YR2 = MAX(YR2, PLOT3(I))
         END DO
         RANGE = YR2 - YR1
         YR1 =  YR1-RANGE/20.
         YR2 =  YR2+RANGE/20.
      ELSE
         YR1 = Y1
         YR2 = Y2 
      END IF
      IF(.NOT.DEFAULT) THEN
         CALL SET_LIM(XR1, XR2, YR1, YR2, IFAIL)
         IF(IFAIL.NE.0) RETURN
      END IF
C     
C     Plot
C     
      CALL DEV_OPEN(.TRUE.,NEW,IFAIL)
      IF(IFAIL.NE.0) RETURN
      IF(NEW) THEN
         CALL VPSET(XR1, XR2, YR1, YR2, LW, AXCOL, LABFON, 
     &        ASIZE, ASPECT)
         CALL PGSCI(LABCOL)
         CALL PGSCH(LSIZE)
         IF(ESAMECI(XNAME,'NONE')) THEN
            CALL PGLABEL('Spectrum number',YLABEL,' ')
         ELSE
            CALL PGLABEL(XLABEL,YLABEL,' ')
         END IF
         CALL PGSCI(1)
         CALL PGSCH(1.)
         CALL PGIDEN
      ELSE
         CALL VPSET(XR1, XR2, YR1, YR2, LW, AXCOL, LABFON, 
     &        ASIZE, ASPECT)
         CALL PGSCH(1.)
         CALL PGSCI(1)
      END IF
      CALL PGPT(NV, PLOT1, PLOT3, 17)
      IF(XERR.NE.' ') THEN
         DO I = 1, NV
            CALL PGMOVE(PLOT1(I)-PLOT2(I),PLOT3(I))
            CALL PGDRAW(PLOT1(I)+PLOT2(I),PLOT3(I))
         END DO
      END IF
      IF(YERR.NE.' ') THEN
         DO I = 1, NV
            CALL PGMOVE(PLOT1(I),PLOT3(I)-PLOT4(I))
            CALL PGDRAW(PLOT1(I),PLOT3(I)+PLOT4(I))
         END DO
      END IF
      IFAIL = 0
      IF(CLOSE) CALL DEV_CLOSE(0,IFAIL)      
      RETURN
999   IFAIL = 1
      RETURN
      END
