*HEDHIST
* HEDHIST N1 N2 Name Type V1 V2 NBIN -- Plots histogram of a header parameter
*
* Parameters
*
*  N1    -- First slot 
*  N2    -- Last slot 
*  Name  -- Name of header parameter. If entered on the command line and
*           it has blanks or commas, it must be enclosed in quotes.
*  Type  -- Data type D=Double precision,I=Integer,R=Real
*  V1, V2 - Range of histogram from centre of first to centre of last bin.
*  NBIN  -- Number of bins.
*
* Selection criteria apply.
*
*HEDHIST
      SUBROUTINE HEDHIST(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &     FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, 
     &     NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &     HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &     MXINTR, MXREAL, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, 
     &     NMSINTR, VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &     NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL, X1, X2, Y1, Y2,
     &     LW, LS, DCOL, LABCOL, AXCOL, LABFON, LSIZE, ASIZE, ASPECT,
     &     ID, XLABEL, YLABEL, TLABEL, CLOSE, SLOTS, MXSLOTS, 
     &     PLOT1, PLOT2, MXWORK, IFAIL)
*
* Plots histograms of header parameters
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
* >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
* >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
* >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
* >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
* >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
* >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
* >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
* >  I     NSCHAR             -- Number of character selection items.
* >  I     NSDOUB             -- Number of double precsion selection items.
* >  I     NSINTR             -- Number of integer selection items.
* >  I     NSREAL             -- Number of real selection items.
* >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
* >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
* >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
* >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
*                                incremented and returned by routine.
* >  I     LW                 -- Line width for plot.
* >  I     LABCOL, AXCOL, LABFON
* >  L     CLOSE              -- TRUE means plot will be closed before exiting
*                                routine
* >  I     SLOTS(MXSLOTS)       -- List of slots
* >  I     MXSLOTS             -- Maximum number in list
* >  R     PLOT1(MXWORK)      -- Plotting work array
* >  R     PLOT2(MXWORK)      -- Plotting work array
* >  I     MXWORK             -- Work array dimension
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE

*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL, MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
      LOGICAL CLOSE
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
      INTEGER MAXARC
      PARAMETER (MAXARC=20)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT, NCOM
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Search parameters, names then values.
*
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*
* Work arrays 
*
      INTEGER MXWORK 
      REAL PLOT1(MXWORK), PLOT2(MXWORK)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
*
* Plot parameters
*
      REAL X1, X2, Y1, Y2, LSIZE, ASIZE, ASPECT
      LOGICAL ID
      INTEGER DCOL, LS, LW, LABCOL, AXCOL, LABFON
      CHARACTER*(*) XLABEL, YLABEL, TLABEL
      CHARACTER*100 XLAB, YLAB, TLAB
*
* Local variables
*
      INTEGER I, J,  NV, NBIN, SLOT1, SLOT2, IFAIL, MAXSPEC
      INTEGER LENSTR, LN
      REAL XP1, XP2, YP1, YP2, RX1, RX2, R1, R2, RVAL
      LOGICAL SELECT, DEFAULT, NEW
      DOUBLE PRECISION DVAL
      INTEGER IVAL
      CHARACTER*32 NAME, DTYP*1     
C
      SAVE SLOT1, SLOT2, NBIN, NAME, DTYP, RX1, RX2
      DATA SLOT1, SLOT2, NBIN/1,1,10/
      DATA NAME, DTYP/'Dwell', 'R'/
      DATA RX1, RX2/0.,0./
*
************************************************************************
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
      CALL INTR_IN('First slot for histogram', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot for histogram', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
        WRITE(*,*) 'Only 0,0 to get list option'
        GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
        IF(DEFAULT .AND. NLIST.GT.0) THEN
          CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
        ELSE
          WRITE(*,*) 'Enter list of spectra for histogram'
          CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &    NSLOTS, MXSLOTS)
        END IF
        IF(NSLOTS.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &  NSLOTS, MXSLOTS)
      END IF
*
      CALL CHAR_IN('Name of header item', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, NAME, IFAIL)
      LN = LENSTR(NAME)
*
      CALL CHAR_IN('Data type of header item (D,I, or R)',
     &SPLIT, NSPLIT, MXSPLIT, NCOM, DEFAULT, DTYP, IFAIL)
      CALL UPPER_CASE(DTYP)
      IF(DTYP.NE.'D' .AND. DTYP.NE.'I' .AND. DTYP.NE.'R') THEN
        WRITE(*,*) 'Muust be either'
        WRITE(*,*) ' D = Double precision'
        WRITE(*,*) ' I = Integer'
        WRITE(*,*) ' R = Real'
        DTYP = 'R'
        GOTO 999
      END IF
*
* Find header values
*
      NV = 0
      DO I = 1, NSLOTS
        SLOT = SLOTS(I)
*
        IF(NPIX(SLOT).GT.0 .AND. 
     &    SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, 
     &    HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, 
     &    MXCHAR, MXDOUB, MXINTR, MXREAL, MXSPEC, NMSCHAR, 
     &    VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, NMSREAL, 
     &    VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, 
     &    MXSDOUB, MXSINTR, MXSREAL)) THEN
*
          IF(DTYP.EQ.'D') THEN
            CALL HGETD(NAME(:LN),DVAL,SLOT,MXSPEC,NMDOUB,
     &      HDDOUB,NDOUB,MXDOUB,IFAIL)        
          ELSE IF(DTYP.EQ.'R') THEN
            CALL HGETR(NAME(:LN),RVAL,SLOT,MXSPEC,NMREAL,
     &      HDREAL,NREAL,MXREAL,IFAIL)        
          ELSE IF(DTYP.EQ.'I') THEN
            CALL HGETI(NAME(:LN),IVAL,SLOT,MXSPEC,NMINTR,
     &      HDINTR,NINTR,MXINTR,IFAIL)        
          END IF
          IF(IFAIL.EQ.0) THEN
            NV = NV + 1
            IF(NV.GT.MXWORK) THEN
              WRITE(*,*) 'Histogram buffer filled'
              WRITE(*,*) 'Too many spectra'
              GOTO 999
            END IF
            IF(DTYP.EQ.'D') THEN
              PLOT1(NV) = REAL(DVAL)
            ELSE IF(DTYP.EQ.'R') THEN
              PLOT1(NV) = RVAL
            ELSE IF(DTYP.EQ.'I') THEN
              PLOT1(NV) = REAL(IVAL)
            END IF
          END IF
        END IF
      END DO
      IF(NV.LE.0) THEN
        WRITE(*,*) 'No valid cases of ',NAME(:LN)
        WRITE(*,*) 'Either there are none or there'//
     &             ' are multiple matches'
        RETURN
      END IF      
      RX1 = PLOT1(1)
      RX2 = X1
      DO I = 1, NV
        RX1 = MIN(RX1, PLOT1(I))
        RX2 = MAX(RX2, PLOT1(I))
      END DO
      WRITE(*,*) NV,' instances of ',NAME(:LN)
      WRITE(*,*) 'They range from ',RX1,' to ',RX2
      IF(X1.NE.X2) THEN
        R1 = X1
        R2 = X2
      ELSE IF(R1.EQ.R2) THEN
        R1 = RX1 - (RX2-RX1)/20.
        R2 = RX2 + (RX2-RX1)/20.
      END IF
      CALL REAL_IN('Lower limit of histogram', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, R1, -1.E30, 1.E30, IFAIL)
      CALL REAL_IN('Upper limit of histogram', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, R2, R1, 1.E30, IFAIL)
      IF(R1.EQ.R2) THEN
         WRITE(*,*) 'Null range entered'
         GOTO 999
      END IF
      XP1 = R1
      XP2 = R2
      CALL INTR_IN('Number of bins', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, NBIN, 1, MXWORK, IFAIL)
*     
*     Now load up histogram
*     
      DO I = 1, NV
         PLOT2(I) = 0.
      END DO
      DO I = 1, NV
         J = 1+NINT(REAL(NBIN-1)*(PLOT1(I)-R1)/(R2-R1))
         IF(J.GE.1 .AND. J.LE.NBIN) PLOT2(J) = PLOT2(J) + 1.
         PLOT1(I) = R1+(R2-R1)*REAL(I-1)/REAL(MAX(1,NBIN-1))
      END DO
*     
      IF(Y1.EQ.Y2) THEN
         YP2 = 1.
         DO I = 1, NV
            YP2 = MAX(YP2, PLOT2(I))
         END DO
         YP1 =  0.
         YP2 = 1.5*YP2
      ELSE
         YP1 = Y1
         YP2 = Y2
      END IF
      IF(.NOT.DEFAULT) THEN
         CALL SET_LIM(XP1, XP2, YP1, YP2, IFAIL)
         IF(IFAIL.NE.0) RETURN
      END IF
C     
C     Plot
C     
      CALL DEV_OPEN(.TRUE.,NEW,IFAIL)
      IF(IFAIL.NE.0) RETURN
      IF(NEW) THEN
         CALL VPSET(XP1, XP2, YP1, YP2, LW, AXCOL, LABFON, 
     &        ASIZE, ASPECT)
         CALL PGSCH(LSIZE)
         CALL PGSCI(LABCOL)
         IF(XLABEL.EQ.'??') THEN
            XLAB = NAME
         ELSE
            XLAB = XLABEL
         END IF
         IF(YLABEL.EQ.'??') THEN
            YLAB = 'Number'
         ELSE
            YLAB = YLABEL
         END IF
         IF(TLABEL.EQ.'??') THEN
            TLAB = 'Histogram'
         ELSE
            TLAB = TLABEL
         END IF
         CALL PGLABEL(XLAB,YLAB,TLAB)
         CALL PGSCI(1)
         CALL PGSCH(1.)
         IF(ID) CALL PGIDEN
      ELSE
         CALL VPSET(XP1,XP2,YP1,YP2,LW,AXCOL,LABFON,ASIZE,ASPECT)
         CALL PGSCI(1)
         CALL PGSCH(1.)
      END IF
      CALL PGSLS(LS)
      CALL PGSLW(LW)
      CALL PGSCI(DCOL)
      CALL PGBIN(NBIN,PLOT1,PLOT2,.TRUE.)
      IFAIL = 0
      IF(CLOSE) CALL DEV_CLOSE(0,IFAIL)
      RETURN
999   IFAIL = 1
      RETURN
      END
