      SUBROUTINE HEDAVE(OUT, SLOT, WEIGHT, NSLOT, MXSPEC, NPIX, ARC, 
     &NARC, MXARC, NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, 
     &MXINTR, MXREAL, IFAIL)
*
* Sets header of OUT equal to first valid spectrum header then
* modified RJD, HJD etc to be average of all others (weighted by
* WEIGHT). If weight is less than or equal to zero, spectrum
* ignored.
* 
* Arguments:
*
* >  I     OUT              -- Output slot
* >  I     SLOT(NSLOT)      -- Slots to average headers 
* >  I     WEIGHT(NSLOT)    -- Weights to be given in averaging
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE
      INTEGER NSLOT, OUT
      INTEGER SLOT(NSLOT), SLT
      REAL WEIGHT(NSLOT)
*
* Integer parameters
*
      INTEGER MXSPEC, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Local variables
*
      INTEGER I
      DOUBLE PRECISION ARJD, AAMASS, AORB, NORM
      INTEGER IFAIL,   IV
      LOGICAL   GOOD, F1, F2, F3
      LOGICAL F4, F5, F6, F7, F8, F9, F10, F11
      INTEGER DAY, MONTH, YEAR
      REAL  ADWELL, W, RVAL
      DOUBLE PRECISION RA, DEC, LONG, LAT, UTC
      DOUBLE PRECISION HEIGHT, EQUINOX, PHASE
      DOUBLE PRECISION TEST, ASPIN, APHS1, APHS2
      DOUBLE PRECISION APHS3, ABEAT, AHUMP, AVEARTH
      DOUBLE PRECISION FORB, FSPIN, FBEAT, FP1, FP2, FP3
      DOUBLE PRECISION FHUMP, BIGO, BIGS, BIGB, BIGH
      DOUBLE PRECISION BIG1, BIG2, BIG3, DVAL
*
* 'FRUIT' parameters
*
      DOUBLE PRECISION RJD, HJD, TDELAY, VHELC
      DOUBLE PRECISION SIDTIM, HA, EL, AZ, ELR
      DOUBLE PRECISION AIRMSS
      COMMON/FRUIT7/RJD,HJD,TDELAY,VHELC
      COMMON/FRUIT8/SIDTIM,HA
      COMMON/FRUIT9/EL,AZ,ELR,AIRMSS
* 
      NORM = 0.D0
      F1 = .TRUE.
      F2 = .TRUE.
      F3 = .TRUE.
      F4 = .TRUE.
      F5 = .TRUE.
      F6 = .TRUE.
      F7 = .TRUE.
      F8 = .TRUE.
      F9 = .TRUE.
      F10= .TRUE.
      F11= .TRUE.
      ADWELL = 0.
      ARJD   = 0.D0
      AORB   = 0.D0
      AAMASS = 0.D0
      ASPIN  = 0.D0
      ABEAT  = 0.D0
      AHUMP  = 0.D0
      APHS1  = 0.D0
      APHS2  = 0.D0
      APHS3  = 0.D0
      AVEARTH = 0.D0
      BIGO =  0.D0
      BIGS =  0.D0
      BIGB =  0.D0
      BIGH =  0.D0
      BIG1 =  0.D0
      BIG2 =  0.D0
      BIG3 =  0.D0
      IV = 0
      DO I = 1, NSLOT
        SLT = SLOT(I)
        W   = WEIGHT(I)
        IF( W.GT.0 .AND. NPIX(SLT).GT.0) THEN
          IF(IV.EQ.0) IV = SLT
          NORM  = NORM  + W
          IF(F1) THEN
             CALL HGETR('Dwell', RVAL, SLT, MXSPEC, NMREAL, HDREAL, 
     &            NREAL, MXREAL, IFAIL)
            IF(IFAIL.NE.0) THEN
              F1 = .FALSE.
            ELSE
              ADWELL = ADWELL + W*RVAL
            END IF
          END IF
          IF(F2) THEN
             CALL HGETD('RJD', DVAL, SLT, MXSPEC, NMDOUB, HDDOUB, 
     &            NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.NE.0) THEN
              F2 = .FALSE.
            ELSE
              ARJD  = ARJD + W*DVAL
            END IF
          END IF
          IF(F3) THEN
             CALL HGETD('Orbital phase', DVAL, SLT, MXSPEC, NMDOUB, 
     &            HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.NE.0) THEN
              F3 = .FALSE.
            ELSE
	      PHASE = DVAL
              BIGO  = BIGO + W*PHASE
              PHASE = PHASE - NINT( PHASE )
	      IF( PHASE.LT.0.D0 ) PHASE = PHASE + 1.D0
              IF(SLT.EQ.IV) FORB = PHASE
              IF(PHASE.GT.FORB+0.5) PHASE = PHASE - 1.D0
              IF(PHASE.LT.FORB-0.5) PHASE = PHASE + 1.D0
              AORB = AORB  + W*PHASE 
            END IF
          END IF
          IF(F4) THEN
             CALL HGETD('Airmass', DVAL, SLT, MXSPEC, NMDOUB, 
     &            HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.NE.0) THEN
              F4 = .FALSE.
            ELSE
              AAMASS = AAMASS + W*DVAL
            END IF
          END IF
          IF(F5) THEN
             CALL HGETD('Spin phase', DVAL, SLT, MXSPEC, NMDOUB, 
     &            HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.NE.0) THEN
              F5 = .FALSE.
            ELSE
	      PHASE = DVAL
              BIGS  = BIGS  + W*PHASE
              PHASE = PHASE - NINT( PHASE )
	      IF( PHASE.LT.0.D0 ) PHASE = PHASE + 1.D0
              IF(SLT.EQ.IV) FSPIN = PHASE
              IF(PHASE.GT.FSPIN+0.5) PHASE = PHASE - 1.D0
              IF(PHASE.LT.FSPIN-0.5) PHASE = PHASE + 1.D0
              ASPIN = ASPIN + W*PHASE 
            END IF
          END IF
          IF(F6) THEN
             CALL HGETD('Beat phase', DVAL, SLT, MXSPEC, NMDOUB, 
     &            HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.NE.0) THEN
              F6 = .FALSE.
            ELSE
	      PHASE = DVAL
              BIGB  = BIGB  + W*PHASE
              PHASE = PHASE - NINT( PHASE )
	      IF( PHASE.LT.0.D0 ) PHASE = PHASE + 1.D0
              IF(SLT.EQ.IV) FBEAT = PHASE
              IF(PHASE.GT.FBEAT+0.5) PHASE = PHASE - 1.D0
              IF(PHASE.LT.FBEAT-0.5) PHASE = PHASE + 1.D0
              ABEAT = ABEAT + W*PHASE 
            END IF
          END IF
          IF(F7) THEN
             CALL HGETD('Hump phase', DVAL, SLT, MXSPEC, NMDOUB, 
     &            HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.NE.0) THEN
              F7 = .FALSE.
            ELSE
	      PHASE = DVAL
              BIGH  = BIGH  + W*PHASE
              PHASE = PHASE - NINT( PHASE )
	      IF( PHASE.LT.0.D0 ) PHASE = PHASE + 1.D0
              IF(SLT.EQ.IV) FHUMP = PHASE
              IF(PHASE.GT.FHUMP+0.5) PHASE = PHASE - 1.D0
              IF(PHASE.LT.FHUMP-0.5) PHASE = PHASE + 1.D0
              AHUMP = AHUMP + W*PHASE 
            END IF
          END IF
          IF(F8) THEN
             CALL HGETD('Phase1', DVAL, SLT, MXSPEC, NMDOUB, 
     &            HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.NE.0) THEN
              F8 = .FALSE.
            ELSE
	      PHASE = DVAL
              BIG1  = BIG1  + W*PHASE
              PHASE = PHASE - NINT( PHASE )
	      IF( PHASE.LT.0.D0 ) PHASE = PHASE + 1.D0
              IF(SLT.EQ.IV) FP1 = PHASE
              IF(PHASE.GT.FP1+0.5) PHASE = PHASE - 1.D0
              IF(PHASE.LT.FP1-0.5) PHASE = PHASE + 1.D0
              APHS1 = APHS1 + W*PHASE 
            END IF
          END IF
          IF(F9) THEN
             CALL HGETD('Phase2', DVAL, SLT, MXSPEC, NMDOUB, 
     &            HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.NE.0) THEN
              F9 = .FALSE.
            ELSE
	      PHASE = DVAL
              BIG2  = BIG2  + W*PHASE
              PHASE = PHASE - NINT( PHASE )
	      IF( PHASE.LT.0.D0 ) PHASE = PHASE + 1.D0
              IF(SLT.EQ.IV) FP2 = PHASE
              IF(PHASE.GT.FP2+0.5) PHASE = PHASE - 1.D0
              IF(PHASE.LT.FP2-0.5) PHASE = PHASE + 1.D0
              APHS2 = APHS2 + W*PHASE 
            END IF
          END IF
          IF(F10) THEN
             CALL HGETD('Phase3', DVAL, SLT, MXSPEC, NMDOUB, 
     &            HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.NE.0) THEN
              F10 = .FALSE.
            ELSE
	      PHASE = DVAL
              BIG3  = BIG3  + W*PHASE
              PHASE = PHASE - NINT( PHASE )
	      IF( PHASE.LT.0.D0 ) PHASE = PHASE + 1.D0
              IF(SLT.EQ.IV) FP3 = PHASE
              IF(PHASE.GT.FP3+0.5) PHASE = PHASE - 1.D0
              IF(PHASE.LT.FP3-0.5) PHASE = PHASE + 1.D0
              APHS3 = APHS3 + W*PHASE 
            END IF
          END IF
          IF(F11) THEN
             CALL HGETD('Vearth', DVAL, SLT, MXSPEC, NMDOUB, 
     &            HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.NE.0) THEN
              F11 = .FALSE.
            ELSE
              AVEARTH = AVEARTH + W*DVAL
            END IF
          END IF
        END IF
      END DO
*
* Store results in output slot.
*
      CALL SET_HEAD(OUT, IV, MXSPEC, NPIX, ARC, NARC, MXARC, 
     &NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, 
     &HDINTR, HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &MXDOUB, MXINTR, MXREAL, IFAIL)
*
* Modify various items to weighted sum 
*
      IF(F1) THEN
        ADWELL = REAL(ADWELL/NORM)
        CALL HSETR('Dwell', ADWELL, OUT, MXSPEC, NMREAL, HDREAL, 
     &  NREAL, MXREAL, IFAIL)
      END IF
      IF(F2) THEN
        ARJD   = ARJD/NORM
        CALL HSETD('RJD', ARJD, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
      END IF
      IF(F3) THEN
        AORB = AORB/NORM
        BIGO = BIGO/NORM
        IF(AORB.LT.0.) AORB = AORB + 1.D0
        IF(AORB.GT.1.) AORB = AORB - 1.D0
        AORB = DBLE(NINT(BIGO-5.D-1))+AORB
        CALL HSETD('Orbital phase', AORB, OUT, MXSPEC, NMDOUB, 
     &  HDDOUB, NDOUB, MXDOUB, IFAIL)
      END IF
      IF(F4) THEN
        AAMASS = AAMASS/NORM
        CALL HSETD('Airmass', AAMASS, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
      END IF
      IF(F5) THEN
        ASPIN = ASPIN/NORM
        BIGS  = BIGS/NORM
        IF(ASPIN.LT.0.) ASPIN = ASPIN + 1.D0
        IF(ASPIN.GT.1.) ASPIN = ASPIN - 1.D0
        ASPIN = DBLE(NINT(BIGS-5.D-1))+ASPIN
        CALL HSETD('Spin phase', ASPIN, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
      END IF
      IF(F6) THEN
        ABEAT = ABEAT/NORM
        BIGB  = BIGB/NORM
        IF(ABEAT.LT.0.) ABEAT = ABEAT + 1.D0
        IF(ABEAT.GT.1.) ABEAT = ABEAT - 1.D0
        ABEAT = DBLE(NINT(BIGB-5.D-1))+ABEAT
        CALL HSETD('Beat phase', ABEAT, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
      END IF
      IF(F7) THEN
        AHUMP = AHUMP/NORM
        BIGH  = BIGH/NORM
        IF(AHUMP.LT.0.) AHUMP = AHUMP + 1.D0
        IF(AHUMP.GT.1.) AHUMP = AHUMP - 1.D0
        AHUMP = DBLE(NINT(BIGH-5.D-1))+AHUMP
        CALL HSETD('Hump phase', AHUMP, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
      END IF
      IF(F8) THEN
        APHS1 = APHS1/NORM
        BIG1  = BIG1/NORM
        IF(APHS1.LT.0.) APHS1 = APHS1 + 1.D0
        IF(APHS1.GT.1.) APHS1 = APHS1 - 1.D0
        APHS1 = DBLE(NINT(BIG1-5.D-1))+APHS1
        CALL HSETD('Phase1', APHS1, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
      END IF
      IF(F9) THEN
        APHS2 = APHS2/NORM
        BIG2  = BIG2/NORM
        IF(APHS2.LT.0.) APHS2 = APHS2 + 1.D0
        IF(APHS2.GT.1.) APHS2 = APHS2 - 1.D0
        APHS2 = DBLE(NINT(BIG2-5.D-1))+APHS2
        CALL HSETD('Phase2', APHS2, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
      END IF
      IF(F10) THEN
        APHS3 = APHS3/NORM
        BIG3  = BIG3/NORM
        IF(APHS3.LT.0.) APHS3 = APHS3 + 1.D0
        IF(APHS3.GT.1.) APHS3 = APHS3 - 1.D0
        APHS3 = DBLE(NINT(BIG3-5.D-1))+APHS3
        CALL HSETD('Phase3', APHS3, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
      END IF
      IF(F11) THEN
        AVEARTH = AVEARTH/NORM
        CALL HSETD('Vearth', AVEARTH, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
      END IF
*
*  Compute date and UT from average RJD
*
      IF(F2) CALL CALENDAR( ARJD, MONTH, DAY, YEAR, UTC )
*
* Search for RA, dec etc to compute HJD, DELAY
* Adapted from RUBY
*
      GOOD = F2
      CALL HGETD('RA', RA, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &     NDOUB, MXDOUB, IFAIL)
      IF(IFAIL.NE.0) GOOD = .FALSE.
      CALL HGETD('Dec', DEC, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &     NDOUB, MXDOUB, IFAIL)
      IF(IFAIL.NE.0) GOOD = .FALSE.
      CALL HGETD('Equinox', EQUINOX, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &     NDOUB, MXDOUB, IFAIL)
      IF(IFAIL.NE.0) GOOD = .FALSE.
      CALL HGETD('Longitude', LONG, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &     NDOUB, MXDOUB, IFAIL)
      IF(IFAIL.NE.0) GOOD = .FALSE.
      CALL HGETD('Latitude', LAT, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &     NDOUB, MXDOUB, IFAIL)
      IF(IFAIL.NE.0) GOOD = .FALSE.
      CALL HGETD('Height', HEIGHT, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &     NDOUB, MXDOUB, IFAIL)
      IF(IFAIL.NE.0) GOOD = .FALSE.
*                  
      IF(GOOD) THEN
10      CALL FRUIT( LONG, LAT, HEIGHT, EQUINOX, RA, DEC,
     &  YEAR, MONTH, DAY, UTC )
	TEST = RJD - ARJD
        IF( ABS(TEST).GT.1.D-6 ) THEN
	  UTC = UTC - (RJD-ARJD)*24.D0
	  WRITE(*,*) 
     &    '** ''CALENDAR'' botched the date by', TEST, ' days.'
	  WRITE(*,*) '** UTC corrected.'
	  GOTO 10
        END IF
*
        CALL HSETI('Year', YEAR, OUT, MXSPEC, NMINTR, HDINTR, 
     &  NINTR, MXINTR, IFAIL)
        IF(IFAIL.NE.0) WRITE(*,*) 'Could not set YEAR'
        CALL HSETI('Month', MONTH, OUT, MXSPEC, NMINTR, HDINTR, 
     &  NINTR, MXINTR, IFAIL)
        IF(IFAIL.NE.0) WRITE(*,*) 'Could not set MONTH'
        CALL HSETI('Day', DAY, OUT, MXSPEC, NMINTR, HDINTR, 
     &  NINTR, MXINTR, IFAIL)
        IF(IFAIL.NE.0) WRITE(*,*) 'Could not set DAY'
*
        CALL HSETD('UTC', UTC, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
        IF(IFAIL.NE.0) WRITE(*,*) 'Could not set UTC'
*
        CALL HSETD('Sidereal time', SIDTIM, OUT, MXSPEC, 
     &  NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
        IF(IFAIL.NE.0) 
     &  WRITE(*,*) 'Could not set SIDEREAL TIME'
*
        CALL HSETD('Hour angle', HA, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
        IF(IFAIL.NE.0) 
     &  WRITE(*,*) 'Could not set HOUR ANGLE'
*
        CALL HSETD('Altitude', EL, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
        IF(IFAIL.NE.0) WRITE(*,*) 'Could not set ALTITUDE'
*
        CALL HSETD('Azimuth', AZ, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
        IF(IFAIL.NE.0) WRITE(*,*) 'Could not set AZIMUTH'
*
        CALL HSETD('HJD', HJD, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
        IF(IFAIL.NE.0) WRITE(*,*) 'Could not set HJD'
*
        CALL HSETD('Delay', TDELAY, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &  NDOUB, MXDOUB, IFAIL)
        IF(IFAIL.NE.0) WRITE(*,*) 'Could not set DELAY'
*
        IF(.NOT.F11) THEN
          CALL HSETD('Vearth', VHELC, OUT, MXSPEC, NMDOUB, HDDOUB, 
     &    NDOUB, MXDOUB, IFAIL)
          IF(IFAIL.NE.0) WRITE(*,*) 'Could not set VEARTH'
        END IF
      END IF
      RETURN
      END	
