C
C     Include file for gaussian fitting routine
C     
      INTEGER MAXPOLY, MAXGAUSS, MAXACT, MAXPAR, MAXVAR, MAXSMR
      INTEGER MAXEPH, MAXCVAR, MAXCON
      PARAMETER (MAXPOLY  =  5)
      PARAMETER (MAXEPH   =  3)
      PARAMETER (MAXGAUSS = 50)
      PARAMETER (MAXACT   = 128)
      PARAMETER (MAXVAR   = 200)
      PARAMETER (MAXCON   = 200)
      PARAMETER (MAXSMR   = 21)
      PARAMETER (MAXCVAR  = 8)
C
C     Derived maximum number of parameters (+1 allows for resolution)
C
      PARAMETER (MAXPAR=MAXPOLY+(8+MAXEPH)*MAXGAUSS+1)
C
C     Variable meanings:
C
C     1) ACTION array holds specifications for deciding the values of
C        every parameter. It has the order:
C     
C        POLY(1),POLY(2)..POLY(MAXPOLY),RES,G1(1),G1(2),..G1(6),G2(1)..
C        etc where POLY(1) etc are the polynomial coefficients, RES 
C        is the FWHM resolution, G1 is the first gaussian etc. 
C     
C     2) NMVAR contains the names of the NVAR variables.
C
C     3) PAR is for storage of parameter values.
C
C     4) DPBYDV stores values of derivatives of parameters with respect
C        to variables.
C
C     5) VARPAR logical array to show which parameters are variable at all.
C
C     6) DEPAR logical array showing which parameters depend on which
C        variable. DEPAR(I,J) = .TRUE. implies that parameter J does
C        vary with variable I.
C
C     7) EPHEM says whether an ephemeris is used
C
C     8) RESSPEC says whether a resolution parameter was specified.
C
C
      INTEGER NPOLY, NGAUSS, NSBINT, NEPH, NCON
      CHARACTER*(MAXACT) ACTION
      CHARACTER*(MAXCVAR) NMVAR, NMCON
      DOUBLE PRECISION PAR, DPDV, YFIT, DYDV, PIVOT
      DOUBLE PRECISION PHASE, COS1P, SIN1P, CON, COS2P, SIN2P
      LOGICAL VARPAR, DEPAR, EPHEM, RESSPEC
C     
      COMMON/GSFIT01/NPOLY, NGAUSS, NSBINT, NCON, NEPH(MAXGAUSS)
      COMMON/GSFIT02/ACTION(MAXPAR)
      COMMON/GSFIT03/NMVAR(MAXVAR),NMCON(MAXCON)
      COMMON/GSFIT04/PAR(MAXPAR),DPDV(MAXVAR,MAXPAR),PIVOT
      COMMON/GSFIT05/VARPAR(MAXPAR),DEPAR(MAXVAR,MAXPAR),EPHEM,RESSPEC
      COMMON/GSFIT06/YFIT,DYDV(MAXVAR),CON(MAXCON)
      COMMON/GSFIT07/PHASE(MAXGAUSS,MAXSMR),
     &     COS1P(MAXGAUSS,MAXSMR),SIN1P(MAXGAUSS,MAXSMR),
     &     COS2P(MAXGAUSS,MAXSMR),SIN2P(MAXGAUSS,MAXSMR)









