      SUBROUTINE GETLIS(LIST, NLIST, MXLIST, MXSPEC, 
     &SLOT, NSLOT, MXSLOT)
*
* Interactively gets a list of spectra. Returns
* NLIST entries specifying range of slots. Slots must
* lies from 1 to MXSPEC inclusive. NSLOT contains number of slots
* chosen, and their values are contained in the first NSLOT
* elements of SLOT(MXSLOT)
*
      IMPLICIT NONE
      INTEGER NLIST, MXSPEC, MXLIST, NSLOT, MXSLOT
      INTEGER SLOT(MXSLOT), NF, NL
      INTEGER LIST(2,MXLIST), N1, N2, I, J, N, J1, J2
      CHARACTER*5 REPLY
      LOGICAL START, ESAMECI
*
      START = .TRUE.
*
* Make sure that slot list is consistent with LIST
*
      NSLOT = 0
      DO I = 1, NLIST
        IF(LIST(2,I).GT.0) THEN
          NL = LIST(2,I)
        ELSE
          NL = LIST(1,I) - LIST(2,I) - 1
          NF = NSLOT 
        END IF
        DO N = LIST(1,I), NL
          NSLOT = NSLOT + 1
          IF(LIST(2,I).GT.0) THEN
            SLOT(NSLOT) = N
          ELSE
            SLOT(NSLOT) = LIST(1,I)
          END IF
          IF(NSLOT.EQ.MXSLOT) THEN
            NLIST = I
            IF(LIST(2,NLIST).GT.0) THEN
              LIST(2,NLIST) = N
            ELSE
              LIST(2,NLIST) = NF - MXSLOT
            END IF
            GOTO 300
          END IF
        END DO                  
      END DO
      GOTO 300
100   WRITE(*,*) ' '
      WRITE(*,*) 'Options:'
      WRITE(*,*) ' '
      WRITE(*,*) ' s -- Show current selection.'
      WRITE(*,*) ' c -- Clear selection.'
      WRITE(*,*) ' p -- Pick slots.'
      WRITE(*,*) ' q -- Quit.'
180   WRITE(*,*) ' '
      WRITE(*,'(A,$)') 'pick> '
      READ(*,'(A)') REPLY
*
      IF(ESAMECI(REPLY,'S')) THEN
300     IF(NLIST.EQ.0) THEN
          WRITE(*,*) 'No slots chosen at present'
          IF(START) THEN
            START = .FALSE.
            GOTO 390
          ELSE
            GOTO 100
          END IF
        ELSE 
          WRITE(*,*) 'Slots selected currently are: '
          WRITE(*,*) ' '
          DO I = 1, NSLOT, 15
            J1 = I
            J2 = MIN(I+14, NSLOT)
            WRITE(*,'(1X,15(I4,1X))') (SLOT(J), J= J1, J2)
          END DO
          GOTO 180
        END IF
      ELSE IF(ESAMECI(REPLY,'C')) THEN
        NLIST = 0
        NSLOT = 0
        WRITE(*,*) 'List cleared'
        GOTO 180
      ELSE IF(ESAMECI(REPLY,'P')) THEN
390     NLIST = 0
        NSLOT = 0
        WRITE(*,*) 'Enter series of slot ranges'
400     WRITE(*,*) 'N,-M for M copies of spectrum N; 0,0 to stop'
        READ(*,*,ERR=100) N1, N2
        IF(N1.EQ.0 .AND. N2.EQ.0) THEN
          WRITE(*,*) 'Entry finished'
        ELSE IF(N1.LT.0 .OR. N2.EQ.0 .OR. (N2.LT.N1 .AND.
     &    N2.GT.0) .OR. N1.GT.MXSPEC .OR. N2.GT.MXSPEC) THEN
          WRITE(*,*) 'Slots out of range'
          GOTO 400
        ELSE 
          NLIST = NLIST + 1
          LIST(1,NLIST) = N1
          LIST(2,NLIST) = N2
          IF(N2.GT.0) THEN
            NL = N2
          ELSE
            NL = N1 - N2 - 1
            NF = NSLOT
          END IF
          DO N = N1, NL
            NSLOT = NSLOT + 1
            IF(N2.GT.0) THEN
              SLOT(NSLOT) = N
            ELSE
              SLOT(NSLOT) = N1
            END IF
            IF(NSLOT.EQ.MXSLOT) THEN
              WRITE(*,*) 'Slot buffer filled ',MXSLOT
              IF(N2.GT.0) THEN
                LIST(2,NLIST) = N
                WRITE(*,*) 'Last entry = ',N
              ELSE
                LIST(2,NLIST) = NF-MXSLOT
                WRITE(*,*) 'Spectrum repeat cut to ',MXSLOT-NF
              END IF
              GOTO 180
            END IF
          END DO                  
          IF(NLIST.EQ.MXLIST) THEN
            WRITE(*,*) 'List full with ',MXLIST,' entries.'
            GOTO 180
          END IF
          GOTO 400
        END IF
        GOTO 180
      ELSE IF(ESAMECI(REPLY,'Q')) THEN
        WRITE(*,*) NSLOT,' slots chosen.'
        RETURN
      ELSE
        GOTO 100
      END IF
      END

      SUBROUTINE SETSLOT(LIST, NLIST, MXLIST, SLOT, NSLOT, MXSLOT)
*
* Sets slots equivalent to LIST
*
      INTEGER NLIST, MXLIST, NSLOT, MXSLOT, I, N, NL, NF
      INTEGER SLOT(MXSLOT), LIST(2,MXLIST), J1, J2
*
      NSLOT = 0
      DO I = 1, NLIST
        IF(LIST(2,I).GT.0) THEN
          NL = LIST(2,I)
        ELSE
          NL = LIST(1,I) - LIST(2,I) - 1
          NF = NSLOT
        END IF
        DO N = LIST(1,I), NL
          NSLOT = NSLOT + 1
          IF(LIST(2,I).GT.0) THEN
            SLOT(NSLOT) = N
          ELSE
            SLOT(NSLOT) = LIST(1,I)
          END IF
          IF(NSLOT.EQ.MXSLOT) THEN
            NLIST = I
            IF(LIST(2,NLIST).GT.0) THEN
              LIST(2,NLIST) = N
            ELSE
              LIST(2,NLIST) = NF - MXSLOT
            END IF
            GOTO 300
          END IF
        END DO                  
      END DO
300   WRITE(*,*) 'Slots selected are: '
      WRITE(*,*) ' '
      DO I = 1, NSLOT, 15
        J1 = I
        J2 = MIN(I+14, NSLOT)
        WRITE(*,'(1X,15(I4,1X))') (SLOT(J), J= J1, J2)
      END DO
      RETURN
      END

      SUBROUTINE SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, 
     &SLOT, NSLOT, MXSLOT)
*
* Sets a list of spectra according to entries SLOT1 and SLOT2
*
      IMPLICIT NONE
      INTEGER NLIST,  MXLIST, NSLOT, MXSLOT
      INTEGER SLOT(MXSLOT), SLOT1, SLOT2
      INTEGER LIST(2,MXLIST), I
*
      NLIST = 1
      LIST(1,1) = SLOT1
      NSLOT = MIN(SLOT2-SLOT1+1, MXSLOT)
      DO I = 1, NSLOT
        SLOT(I) = SLOT1 + I - 1
      END DO
      LIST(2,1) = SLOT(NSLOT)
      IF(NSLOT.EQ.MXSLOT) THEN
        WRITE(*,*) 'List full with ',MXSLOT,' entries.'
        WRITE(*,*) 'Last slot = ',SLOT(NSLOT)
      END IF
      RETURN
      END
