*FCAL
* FCAL N1 N2 NF NT GREY RAYLEIGH TEX REBIN FUDGE NFL NFS SET
*
* FCAL applies flux calibration generated by FLUX. NB. FCAL checks that
* the spectra to be calibrated do not contain the header item TYPE equal 
* to 'FLUX' since that indicates that the spectrum is a flux calibration
* spectrum. 
*
* Parameters:
*
*   N1, N2 -- Range of spectra to flux calibrate
*   NF     -- Flux star slot (0 to remove flux cal, -1 to retain current flux star)
*   NT     -- Telluric star slot (0 to remove telluric cal)
*   GREY   -- Grey extinction mags/airmass
*   RAYLEIGH- Mutiplier to scale Palomar Rayleigh scattering extinction
*             It is assumed that the flux star has the same values of
*             GREY and RAYLEIGH unless Real header items GREY and RAYLEIGH
*             are set which will override the above values. This does not
*             apply to the spectra to be calibrated which will use the
*             above values whatever.
*   TEX    -- Exponent for scaling telluric absorption. Because the
*             telluric lines are saturated, the extinction is not linearly
*             proportional to airmass. TEX tries to account for this.
*             Note that it only really works for low-medium resolution data.
*   REBIN  -- Rebinning method to apply telluric cal (Q probably best)
*   FUDGE  -- TRUE = Telluric cal scaled to minimise scatter rather than
*             simple exponent scaling. 
*   NFL, NFS - Smoothing parameters for the fudging process.
*   SET    -- Define mask showing where telluric lines are for fudging.
*
* The routine sets the values of GREY and RAYLEIGH used in the headers
*
* Related command: FLUX
*
*FCAL
      SUBROUTINE FLCAL(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, FLUX, 
     &     MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &     NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &     NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &     MXREAL, SLOTS, MXSLOTS, WORK1, WORK2, WORK3, WORK4, 
     &     WORK5, WORK6, WORK7, MASK, MXWORK, IFAIL)
*
* Applies flux/extinction calibrations
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)   -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)   -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)     -- Equivalent fluxes to COUNTS
* >  I     MXBUFF           -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
*    I     SLOTS(MXSLOTS) -- List buffer.
*    I     MXSLOTS
*    R     WORK1(MXWORK) - Work arrays
*    R     WORK2(MXWORK)
*    R     WORK3(MXWORK)
*    R     WORK4(MXWORK)
*    R     WORK5(MXWORK)
*    R     WORK6(MXWORK)
*    R     WORK7(MXWORK)
*    L     MASK(MXWORK)
*    I     MXWORK
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE
C
C     Integer parameters
C
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
C
C     Data arrays
C
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
C
C     Numbers of header items
C
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
C
C     Names of header items
C
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
C
C     Values of header items
C
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
C
C     Arc coefficients
C
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
C
C     Work arrays
C
      INTEGER MXWORK
      REAL WORK1(MXWORK), WORK2(MXWORK)
      REAL WORK3(MXWORK), WORK4(MXWORK)
      REAL WORK5(MXWORK), WORK6(MXWORK)
      REAL WORK7(MXWORK)
      LOGICAL MASK(MXWORK)
      INTEGER MXMASK
      PARAMETER (MXMASK=50)
      INTEGER NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
C
C     Command parameters
C
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
C
C     Slot lists
C
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
      DOUBLE PRECISION FAIR, AIRMASS, WAIR, VEARTH
      CHARACTER*32 WHAT, METHOD*3, FUDGE*3, SET*3
C
C     Local variables
C
      INTEGER I, J
      REAL   DWELL, AIR
      DOUBLE PRECISION ANGST
      REAL  GREY, RAYLEIGH, GRFL, RAYFL
      REAL WATER, FDWELL,  RATIO
      REAL RLO, RHI, TOL
      INTEGER SLOT1, SLOT2, SLOT3, SLOT4
      INTEGER  MAXSPEC,  NFL, NFS, NCOM
      INTEGER   IFAIL
      LOGICAL  SAMECI,  DEFAULT
      REAL    WAT, EXT, EMAG, WAVE, WFAC
      INTEGER RECORD
C
C     Functions
C
      REAL GET_FLX, EXTINC, CFRAT
C
      DATA SLOT1, SLOT2, SLOT3, SLOT4/1, 1, 2, 3/
      DATA GREY, RAYLEIGH, WATER/0.,1.,0.5/
      DATA NPMASK, NWMASK, NVMASK/0,0,0/
      DATA METHOD, FUDGE, SET/'Q', 'Y', 'Y'/
      DATA NFL,NFS,WFAC/31,3,1./
C
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      NCOM = 0
      IFAIL = 0
      CALL INTR_IN('First slot to calibrate', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to calibrate', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         WRITE(*,*) 'Enter list of spectra to calibrate'
         CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &        NSLOTS, MXSLOTS)
         IF(NSLOTS.EQ.0) GOTO 999
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
*     
      CALL INTR_IN('Flux star slot', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT3, -1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT3.EQ.0) THEN
         WRITE(*,*) 'No flux calibration will be applied'
      ELSE IF(SLOT3.EQ.-1) THEN
         WRITE(*,*) 'Current flux calibration will be retained'
      ELSE
         IF(NPIX(SLOT3).LE.0) THEN
            WRITE(*,*) 'No spectrum present in slot ',SLOT3
            GOTO 999
         ELSE IF(NARC(SLOT3).EQ.0) THEN
            WRITE(*,*) 'No arc calibration in slot ',SLOT3
            GOTO 999
         END IF
         CALL HGETC('TYPE', WHAT, SLOT3, MXSPEC, NMCHAR, HDCHAR,
     &        NCHAR, MXCHAR, IFAIL)
         IF(IFAIL.NE.0 .OR. .NOT.SAMECI(WHAT,'FLUX')) THEN
            WRITE(*,*) 'Flux star chosen does not have TYPE= ''FLUX'''
            GOTO 999
         END IF
         CALL HGETR('Dwell', FDWELL, SLOT3, MXSPEC, NMREAL, HDREAL, 
     &        NREAL, MXREAL, IFAIL)
         IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'No dwell found for flux star'
            GOTO 999
         END IF
         CALL HGETD('Airmass', FAIR, SLOT3, MXSPEC, NMDOUB, 
     &        HDDOUB, NDOUB, MXDOUB, IFAIL)
         IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'No airmass found for flux star'
            GOTO 999
         END IF
      END IF
C
      CALL INTR_IN('Telluric star slot', SPLIT, NSPLIT, MXSPLIT, 
     &     NCOM, DEFAULT, SLOT4, 0, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT4.GT.0) THEN
         IF(NPIX(SLOT4).LE.0) THEN
            WRITE(*,*) 'No spectrum present in slot ',SLOT4
            GOTO 999
         ELSE IF(NARC(SLOT4).EQ.0) THEN
            WRITE(*,*) 'No arc calibration in slot ',SLOT4
            GOTO 999
         END IF
         CALL HGETD('Airmass', WAIR, SLOT4, MXSPEC, NMDOUB, HDDOUB, 
     &        NDOUB, MXDOUB, IFAIL)
         IF(IFAIL.NE.0) THEN
            WRITE(*,*) 'Could not find any airmass in slot ',SLOT4
            GOTO 999
         END IF
      END IF
*
      IF(SLOT3.GT.0) THEN
         CALL REAL_IN('Grey extinction coefficient', SPLIT, NSPLIT,
     &        MXSPLIT, NCOM, DEFAULT, GREY, 0., 1000., IFAIL)
         CALL REAL_IN('Rayleigh extinction factor', SPLIT, NSPLIT,
     &        MXSPLIT, NCOM, DEFAULT, RAYLEIGH, 0., 1000., IFAIL)
C
C     Look for override values for the flux standard
C
         CALL HGETR('Grey', GRFL, SLOT3, MXSPEC, NMREAL, HDREAL,
     &        NREAL, MXREAL, IFAIL)
         IF(IFAIL.NE.0) GRFL = GREY
         IFAIL = 0
         CALL HGETR('Rayleigh', RAYFL, SLOT3, MXSPEC, NMREAL,
     &        HDREAL, NREAL, MXREAL, IFAIL)
         IF(IFAIL.NE.0) RAYFL = RAYLEIGH
         IFAIL = 0
      END IF
      IF(SLOT4.GT.0) THEN
         CALL REAL_IN('Telluric scaling exponent', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, WATER, -1000., 1000., IFAIL)
         CALL CHAR_IN('Rebinning method (L,Q,S)', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, METHOD, IFAIL)
         IF(IFAIL.NE.0) GOTO 999
         CALL UPPER_CASE(METHOD)
         IF(METHOD.NE.'L' .AND. METHOD.NE.'Q' .AND. 
     &        METHOD.NE.'S') THEN
            WRITE(*,*) 'Possible methods are:'
            WRITE(*,*) ' '
            WRITE(*,*) ' L -- Linear'
            WRITE(*,*) ' Q -- Quadratic'
            WRITE(*,*) ' S -- Sinc'
            METHOD = 'Q'
            GOTO 999
         END IF
         CALL CHAR_IN('Fudge telluric extinction?', SPLIT, NSPLIT, 
     &        MXSPLIT, NCOM, DEFAULT, FUDGE, IFAIL)  
         CALL UPPER_CASE(FUDGE)
         IF(FUDGE.EQ.'Y') THEN
            CALL INTR_IN('Largescale filter width (odd)', SPLIT, NSPLIT,
     &           MXSPLIT, NCOM, DEFAULT, NFL, 3, 1001, IFAIL)
            NFS = MAX(1,MIN(NFS,NFL-2))
            CALL INTR_IN('Smallscale filter width (odd)', SPLIT, NSPLIT,
     &           MXSPLIT, NCOM, DEFAULT, NFS, 1, NFL-2, IFAIL)
            CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
            CALL CHAR_IN('Set mask?', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &           DEFAULT, SET, IFAIL)
            IF(IFAIL.NE.0) GOTO 999
            IF(SAMECI(SET,'YES')) THEN
               WRITE(*,*) 'Mask regions which show only telluric lines'
               CALL MASKIT(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &              NVMASK, MXMASK, COUNTS, ERRORS, FLUX, MXBUFF, 
     &              MAXPX, NPIX, MXSPEC, NARC, ARC, MXARC, NMCHAR, 
     &              NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &              HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, 
     &              MXDOUB, MXINTR, MXREAL, WORK1, WORK2, WORK3, 
     &              MXWORK, MASK)
            END IF
            CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
            IF(SAMECI(SET,'YES')) THEN
               WRITE(*,*) 'No regions masked'
               GOTO 999
            END IF
         ELSE IF(FUDGE.EQ.'N') THEN
            CALL REAL_IN('Ratio telluric-/air-mass', SPLIT, NSPLIT,
     &           MXSPLIT, NCOM, DEFAULT, WFAC, 0., 1.E5, IFAIL)
            IF(IFAIL.NE.0) GOTO 999
         ELSE
            WRITE(*,*) 'Must be either Y or N'
            FUDGE = 'Y'
            GOTO 999
         END IF
      END IF
C
C     Now start calibration.
C
C     First load up calibration arrays
C
      IF(SLOT3.GT.0) THEN
         DO I = 1, NPIX(SLOT3)
            WORK1(I) = FDWELL/CFRAT(COUNTS(I,SLOT3), FLUX(I,SLOT3))
         END DO
      END IF
      IF(SLOT4.NE.0) THEN
         DO I = 1, NPIX(SLOT4)
            WORK2(I) = GET_FLX(COUNTS(I,SLOT4), FLUX(I,SLOT4))
         END DO
      END IF
C
C     Now grind through the spectra
C
      WRITE(*,*) ' '
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
         IF(NPIX(SLOT).LE.0) THEN
            WRITE(*,*) 'Skipped slot ',SLOT,' as it is empty.'
            GOTO 500
         ELSE IF(NARC(SLOT).EQ.0) THEN
            WRITE(*,*) 'Skipped slot ',SLOT,
     &           ' as it has no wavelength calibration.'
            GOTO 500
         END IF
         CALL HGETC('TYPE', WHAT, SLOT, MXSPEC, NMCHAR, HDCHAR, 
     &        NCHAR, MXCHAR, IFAIL)
         IF(IFAIL.EQ.0 .AND. SAMECI(WHAT,'FLUX')) THEN
            WRITE(*,*) 'Spectrum ',SLOT,' has type FLUX and will'
            WRITE(*,*) 'not be altered. Edit TYPE parameter if you'
            WRITE(*,*) 'really want to change it.'
            GOTO 500
         END IF
         IF(SLOT3.GT.0 .OR. SLOT4.GT.0) THEN
            CALL HGETD('Airmass', AIRMASS, SLOT, MXSPEC, NMDOUB, 
     &           HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.NE.0) THEN
               WRITE(*,*) 'No airmass found.'
               GOTO 500
            END IF
            AIR = REAL(AIRMASS)
         END IF
         IF(SLOT3.GT.0) THEN
C
C     Need dwell for flux cal
C
            CALL HGETR('Dwell', DWELL, SLOT, MXSPEC, NMREAL, 
     &           HDREAL, NREAL, MXREAL, IFAIL)
            IF(IFAIL.NE.0) THEN
               WRITE(*,*) 'Skipped slot ',SLOT,' as it has no DWELL'
               GOTO 500
            END IF
C
C     Rebin flux standard onto same scale as object
C
            CALL REBIN(1, 1, WORK1, NPIX(SLOT3), WORK3, 
     &           NPIX(SLOT), 0., NARC(SLOT3), ARC(1,SLOT3), 
     &           NARC(SLOT), ARC(1,SLOT))     
        END IF
        IF(SLOT4.GT.0) THEN
C
C     Rebin water star onto same scale as object
C
           IF(METHOD.EQ.'L') THEN
              CALL REBIN(1, 0, WORK2, NPIX(SLOT4), WORK4, 
     &             NPIX(SLOT), 0., NARC(SLOT4), ARC(1,SLOT4), 
     &             NARC(SLOT), ARC(1,SLOT))
           ELSE IF(METHOD.EQ.'Q') THEN
              CALL REBIN(1, 1, WORK2, NPIX(SLOT4), WORK4, 
     &             NPIX(SLOT), 0., NARC(SLOT4), ARC(1,SLOT4), 
     &             NARC(SLOT), ARC(1,SLOT))
           ELSE IF(METHOD.EQ.'S') THEN
C
C Subtract 1 and then add back to avoid divide by zero problem later
C 19/07/2007
C
              DO J=1, NPIX(SLOT4)
                 WORK2(J) = WORK2(J) - 1.0
              END DO
              CALL SINCBIN(1, WORK2, NPIX(SLOT4), WORK4, 
     &             NPIX(SLOT), 0., NARC(SLOT4), ARC(1,SLOT4), 
     &             NARC(SLOT), ARC(1,SLOT), WORK5, WORK6)
              DO J=1, NPIX(SLOT4)
                 WORK4(J) = WORK4(J) + 1.0
                 WORK2(J) = WORK2(J) + 1.0
              END DO
           END IF
        END IF
C
C     Apply calibrations
C
        IF(SLOT4.GT.0.) THEN
           IF(FUDGE.EQ.'N') THEN
              RATIO = REAL((WFAC*AIR/WAIR)**WATER)
           ELSE
C
C     RLO =  0. equivalent to no correction
C     RHI =  5. equivalent to over correction (we hope)
C     RATIO our best shot
C
            RLO = 0.
            RHI = 8.
            RATIO = REAL((AIR/WAIR)**WATER)
C
C     Get mask
C
            CALL HGETD('Vearth', VEARTH, SLOT, MXSPEC, NMDOUB, 
     &           HDDOUB, NDOUB, MXDOUB, IFAIL)
            IFAIL = 0
            CALL APPMASK(MASK,NPIX(SLOT),ARC(1,SLOT),NARC(SLOT),
     &           MXARC,PMASK,NPMASK,WMASK,NWMASK,VMASK,NVMASK,MXMASK,
     &           .TRUE.,VEARTH,IFAIL)
C
C     Find value of ratio which minimises scatter
C
            TOL = 1.E-5

            CALL TEMIN( RLO, RATIO, RHI, TOL, COUNTS(1,SLOT),
     &           ERRORS(1,SLOT), MASK, WORK4, NPIX(SLOT), WORK5,
     &           WORK6, WORK7, NFL, NFS, IFAIL)
            AIR = REAL(WAIR*RATIO**(1./WATER))
C
C     Report effective airmass found
C
            WRITE(*,*) 'Effective watermass found = ',AIR
            WRITE(*,*) '      compared to airmass = ',SNGL(AIRMASS)
         END IF
      END IF
C
C     Flux star is effectively extinction corrected so need to
C     adjust by difference between flux and spectrum extinctions.
C
      DO J = 1, NPIX(SLOT)
         WAVE = REAL(ANGST(REAL(J), NPIX(SLOT), NARC(SLOT), 
     &        ARC(1,SLOT), MXARC))
         IF(SLOT3.GT.0) THEN
            EMAG = REAL(AIRMASS*GREY-FAIR*GRFL+
     &           (AIRMASS*RAYLEIGH-FAIR*RAYFL)*EXTINC(WAVE))
            EXT = WORK3(J)*10.**(EMAG/2.5)/DWELL
         ELSE IF(SLOT3.LT.0) THEN
            EXT = 1./CFRAT(COUNTS(J,SLOT),FLUX(J,SLOT))
         ELSE
            EXT = 1.
         END IF
         IF(SLOT4.GT.0.) THEN
            IF(WORK4(J).LE.0.) THEN
               WAT = 1.
            ELSE
               WAT = WORK4(J)**RATIO
            END IF
         ELSE
            WAT = 1.
         END IF
         IF(COUNTS(J,SLOT).EQ.0.) THEN
            FLUX(J,SLOT) = EXT/WAT
         ELSE
            FLUX(J,SLOT) = COUNTS(J,SLOT)*EXT/WAT
         END IF
      END DO
C
C     Set values of GREY and RAYLEIGH used.
C
      IF(SLOT3.GT.0) THEN
         CALL HSETR('Grey', GREY, SLOT, MXSPEC, NMREAL, HDREAL,
     &        NREAL, MXREAL, IFAIL)
         CALL HSETR('Rayleigh', RAYLEIGH, SLOT, MXSPEC, NMREAL,
     &        HDREAL, NREAL, MXREAL, IFAIL)
         CALL HGETI('Record', RECORD, SLOT3, MXSPEC,
     &        NMINTR, HDINTR, NINTR, MXINTR, IFAIL)
         IF(IFAIL.EQ.0) THEN
            CALL HSETI('Flux star', RECORD, SLOT, MXSPEC, 
     &           NMINTR, HDINTR, NINTR, MXINTR, IFAIL)
         END IF
         IFAIL = 0
      END IF
      IF(SLOT4.GT.0) THEN
         CALL HGETI('Record', RECORD, SLOT4, MXSPEC,
     &        NMINTR, HDINTR, NINTR, MXINTR, IFAIL)
         IF(IFAIL.EQ.0) THEN
            CALL HSETI('Telluric star', RECORD, SLOT, MXSPEC,
     &           NMINTR, HDINTR, NINTR, MXINTR, IFAIL)
         END IF
         IFAIL = 0
      END IF
      IF(SLOT3.GT.0 .AND. SLOT4.GT.0) THEN
         WRITE(*,*) 'Flux and telluric cal applied to slot ',SLOT
      ELSE IF(SLOT3.GT.0) THEN
         WRITE(*,*) 'Flux cal applied to slot ',SLOT
         CALL HDELI('Telluric star', SLOT, MXSPEC, NMINTR, HDINTR,
     &        NINTR, MXINTR, IFAIL)
      ELSE IF(SLOT4.GT.0) THEN
         WRITE(*,*) 'Telluric cal applied to slot ',SLOT
         IF(SLOT3.EQ.0) THEN
            CALL HDELI('Flux star', SLOT, MXSPEC, NMINTR, HDINTR,
     &           NINTR, MXINTR, IFAIL)
            CALL HDELR('Rayleigh', SLOT, MXSPEC, NMREAL, HDREAL,
     &           NREAL, MXREAL, IFAIL)
            CALL HDELR('Grey', SLOT, MXSPEC, NMREAL, HDREAL,
     &           NREAL, MXREAL, IFAIL)
         END IF
      ELSE
         WRITE(*,*) 'Calibrations removed from slot ',SLOT
         CALL HDELI('Telluric star', SLOT, MXSPEC, NMINTR, HDINTR,
     &        NINTR, MXINTR, IFAIL)
         IF(SLOT3.EQ.0) THEN
            CALL HDELI('Flux star', SLOT, MXSPEC, NMINTR, HDINTR,
     &           NINTR, MXINTR, IFAIL)
            CALL HDELR('Rayleigh', SLOT, MXSPEC, NMREAL, HDREAL,
     &           NREAL, MXREAL, IFAIL)
            CALL HDELR('Grey', SLOT, MXSPEC, NMREAL, HDREAL,
     &           NREAL, MXREAL, IFAIL)
         END IF
      END IF
 500  CONTINUE
      END DO
      IFAIL = 0
 999  RETURN
      END
