*FIXERR
* FIXERR N1 N2 NSECT CMAX SET -- Fixes error bars of low count number data
*
* Parameters
*           N1    -- First spectrum to fix
*           N2    -- Last spectrum to fix
*           NSECT -- Number of sections to split spectra into
*           CMAX  -- Error only corrected if number of counts in a pixel
*                 is below this threshold.
*           SET   -- Set mask to avoid bad regions of spectra
*
* With very small numbers of counts it can be difficult to assign good
* error bars. The obvious procedure of SQRT(Number of counts) is a bad
* idea since if there are no counts, an error bar of zero is assigned.
* If there are similar spectra taken at the same time (or better still the
* same phase), they can give some idea of the mean count rate and
* hence help in setting an error bar. This routine was designed with HST
* data in mind. The counts are collapsed in the spectral (--> mean spectrum) 
* and time directions (--> light curve) and then predicted counts are derived 
* by mutiplying the two for each spectrum. Bad spectral regions can be removed 
* from the light curve by setting a mask over them at the start. The light
* curve is formed separately in NSECT sections and linearly interpolated from
* one to the next to allow for possible colour variations.
*FIXERR
      SUBROUTINE FIXERR(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &MXWORK, SLOTS, MXSLOTS, WORK1, WORK2, WORK3, MASK, IFAIL)
*
* Fixs error bars of low count data
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  I     MXWORK             -- Size of work array
* >  I     SLOTS(MXSLOTS)       -- Work array for list of spectra
* >  I     MXSLOTS             -- Maximum number of entries
*    R     WORK1(MXWORK)
*    R     WORK2(MXWORK)
*    R     WORK3(MXWORK)
*    I     MXWORK
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE

*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
*
* Mask arrays
*
      INTEGER MXMASK
      PARAMETER (MXMASK=50)
      INTEGER NPMASK, NWMASK, NVMASK
      INTEGER PMASK(2,MXMASK)
      REAL WMASK(2,MXMASK)
      REAL VMASK(3,MXMASK)
*
      INTEGER MXWORK
      REAL WORK1(MXWORK), WORK2(MXWORK), WORK3(MXWORK)
      LOGICAL MASK(MXWORK)
*
* Local variables
*
      INTEGER I, J, K,  N, J1, J2
      DOUBLE PRECISION   SUM, SUM1, SUM2
      INTEGER SLOT1, SLOT2
      INTEGER  IFAIL,  NSAME
      INTEGER NSPEC, MAXSPEC,  NCOM
      LOGICAL  SAME
      LOGICAL DEFAULT
      INTEGER   NGROUP
      REAL  CMAX, X1, X2, LIG
      INTEGER    NSECT
      DOUBLE PRECISION VEARTH
      CHARACTER*3 SET
*
      DATA SLOT1, SLOT2/1,1/
      DATA CMAX, NSECT/100., 5/
      DATA NPMASK, NWMASK, NVMASK/0,0,0/
*
************************************************************************
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM = 0
*
* First slot
*
      CALL INTR_IN('First spectrum to fix', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
*
* Second slot
*
      SLOT2 = MAX(SLOT2, SLOT1)
      CALL INTR_IN('Last spectrum to fix', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
        WRITE(*,*) '0,0 only for list option'
        GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
        IF(DEFAULT .AND. NLIST.GT.0) THEN
          CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, 
     &    MXSLOTS)
        ELSE
          WRITE(*,*) 'Enter list of spectra to fix'
          CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &    NSLOTS, MXSLOTS)
        END IF
        IF(NSLOTS.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &  NSLOTS, MXSLOTS)
      END IF              
      CALL INTR_IN('Number of light curve sections', SPLIT, 
     &NSPLIT, MXSPLIT, NCOM, DEFAULT, NSECT, 1, 100, IFAIL)
      IF(NSLOTS*NSECT.GT.MXWORK) THEN
        WRITE(*,*) 'Need to store ',NSPEC*NSECT,' light curve point'
        WRITE(*,*) 'which is too many for buffer of ',MXWORK
        GOTO 999
      END IF
      CALL REAL_IN('Max number of counts to correct error', SPLIT, 
     &NSPLIT, MXSPLIT, NCOM, DEFAULT, CMAX, 0., 1.E10, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
      CALL CHAR_IN('Set mask?', SPLIT, NSPLIT, MXSPLIT, NCOM, 
     &DEFAULT, SET, IFAIL)
      IF(SAME(SET,'YES')) THEN
        WRITE(*,*) 'Mask bad spectral regions'
        CALL MASKIT(PMASK, WMASK, VMASK, NPMASK, NWMASK, 
     &       NVMASK, MXMASK, COUNTS, ERRORS, FLUX, MXBUFF, MAXPX,
     &       NPIX, MXSPEC, NARC, ARC, MXARC, NMCHAR, NMDOUB, NMINTR,
     &       NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB,
     &       NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, WORK1, 
     &       WORK2, WORK3, MXWORK, MASK)
        CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
        IF(SAME(SET,'YES')) WRITE(*,*) 'No regions masked'
      ELSE
        CALL SMASK(NPMASK,NWMASK,NVMASK,SET)
        IF(SAME(SET,'YES')) WRITE(*,*) 'No regions masked'
      END IF
***************************************************************************
*
* Now process
*
*
* Loop through spectra
*
      NSAME = 0      
      DO I = 1, NSLOTS
        SLOT = SLOTS(I)
        IF( NPIX(SLOT).LE.0) THEN
          WRITE(*,*) 'Slot ',SLOT,' empty; skipped.'
        ELSE IF(NSAME.EQ.0) THEN
          NSAME = NPIX(SLOT)             
        ELSE IF(NPIX(SLOT).NE.NSAME) THEN
          WRITE(*,*) 'Slot ',SLOT,' has ',NSAME,' pixels,'
          WRITE(*,*) 'incompatible with the first valid'
          WRITE(*,*) 'slot which had ',NSAME
          GOTO 999
        END IF
      END DO
*
* Collapse in time to get mean spectrum. If the routine TEMP
* has been run then the ERRORS**2 represent the true number of
* counts prior to background subtraction, except if COUNTS(J,SLOT)<0
* in which case original number of counts = 0
*
      DO I = 1, NSAME
        WORK1(I) = 0.
      END DO
      N = 0
      DO I = 1, NSLOTS
        SLOT = SLOTS(I)
        IF( NPIX(SLOT).GT.0) THEN
          SUM = 0.D0
          DO J = 1, NSAME
            IF(ERRORS(J,SLOT).GT.0. .AND. COUNTS(J,SLOT).GT.0.) THEN
              WORK1(J) = WORK1(J) + ERRORS(J,SLOT)**2
            END IF
          END DO
          N = N + 1
        END IF
      END DO
      NSPEC = N
      DO I = 1, NSAME
        WORK1(I) = WORK1(I)/REAL(NSPEC)
      END DO
*
* Collapse in wavelength sections to get NSECT light curves.
*
      DO I = 1, NSPEC*NSECT
        WORK2(I) = 0.
      END DO
      NGROUP = NSAME/NSECT
      DO K = 1, NSECT
        J1 = NGROUP*(K-1)+1
        J2 = NGROUP*K
        IF(K.EQ.NSECT) J2 = NSAME
        SUM1 = 0.D0
        DO J = J1, J2
          SUM1 = SUM1 + WORK1(J)
        END DO
        N = 0
        DO I = 1, NSLOTS
          SLOT = SLOTS(I)
          IF( NPIX(SLOT).GT.0) THEN
*
* Get mask
*
            CALL APPMASK(MASK,NPIX(SLOT),ARC(1,SLOT),NARC(SLOT),
     &      MXARC,PMASK,NPMASK,WMASK,NWMASK,VMASK,NVMASK,MXMASK,
     &      .FALSE.,VEARTH,IFAIL)
            SUM  = 0.D0
            SUM2 = 0.D0
            DO J = J1, J2
              IF(ERRORS(J,SLOT).GT.0. .AND. MASK(J) .AND.
     &          COUNTS(J,SLOT).GT.0.) THEN
                SUM = SUM   + ERRORS(J,SLOT)**2
              ELSE IF(ERRORS(J,SLOT).GT.0. .AND. MASK(J)) THEN
                SUM2 = SUM2 + ERRORS(J,SLOT)**2
              END IF
            END DO
            N = N + 1
            WORK2(NSPEC*(K-1)+N) = REAL(MAX(SUM, SUM2)/SUM1)
          END IF
        END DO  
      END DO
*
* Correct error bars by taking the true flux at each point as the product
* of the mean interpolated light curve times the mean spectrum. This is 
* obviously only approximate, but it is only applied if number of counts in 
* a pixel is below a user defined threshold. Beyond ends of interpolated
* section nearest neighbour interpolation is used.
*
      N = 0
      DO I = 1, NSLOTS
        SLOT = SLOTS(I)
        IF( NPIX(SLOT).GT.0) THEN
          N = N + 1
          DO K = 1, NSECT+1
            IF(K.EQ.1) THEN
              J1 = 1
              J2 = (1+NGROUP)/2
            ELSE IF(K.EQ.NSECT+1) THEN
              J1 = (NGROUP*(NSECT-1)+1+NSAME)/2+1
              J2 = NSAME
            ELSE
              J1 = (NGROUP*(2*K-3)+1)/2+1
              J2 = (NGROUP*(2*K-1)+1)/2
              X1 = REAL(NGROUP*(2*K-3)+1)/2.
              X2 = REAL(NGROUP*(2*K-1)+1)/2.
            END IF
            DO J = J1, J2
              IF(ERRORS(J,SLOT).GT.0. .AND.
     &           ERRORS(J,SLOT)**2.LT.CMAX) THEN
                IF(K.EQ.1) THEN
                  LIG = WORK2(N)
                ELSE IF(K.EQ.NSECT+1) THEN
                  LIG = WORK2(NSPEC*(NSECT-1)+N)
                ELSE
                  LIG = ((REAL(J)-X1)*WORK2(NSPEC*(K-1)+N)+
     &              (X2-REAL(J))*WORK2(NSPEC*(K-2)+N))/(X2-X1)
                END IF
                ERRORS(J,SLOT) = SQRT(LIG*WORK1(J))
              END IF
            END DO
          END DO
        END IF
      END DO
      WRITE(*,*) 'Error bars corrected'
999   RETURN
      END

