      REAL FUNCTION EXTINC(WAVE)
C
C     MONOCHROMATIC EXTINCTION IN MAGNITUDES FOR ONE AIRMASS AT PALOMAR
C     SOURCE : J. B. OKE
C     ONLY CONTINUUM EXTINCTION IS INCLUDED.
C     
C     MODIFIED TO USE HUNT, PFLM, SEP 99 
*     
      INTEGER NWAVE,IM
      PARAMETER (NWAVE=58)
      REAL*4 WV(NWAVE),EXT(NWAVE)
      SAVE IM
*     
      DATA WV/
     &     2999., 3100., 3110., 3120., 3130., 3140., 3150., 3160.,
     &     3180., 3200., 3220., 3240., 3260., 3280., 3300., 3320.,
     &     3340., 3360., 3380., 3400., 3450., 3500., 3550., 3600.,
     &     3700., 3800., 3900., 4000., 4100., 4200., 4300., 4400.,
     &     4500., 4600., 4700., 4800., 4900., 5000., 5200., 5400.,
     &     5600., 5800., 6000., 6100., 6200., 6500., 6820., 6980., 
     &     7140., 7340., 7570., 7680., 8100., 8350., 8900., 9860.,
     &     10800.,12500./
*     
      DATA EXT/
     &     5.000, 1.887, 1.758, 1.627, 1.509, 1.418, 1.344, 1.284,
     &     1.175, 1.084, 1.015, 0.951, 0.902, 0.874, 0.830, 0.798,
     &     0.772, 0.747, 0.727, 0.708, 0.662, 0.624, 0.591, 0.558,
     &     0.504, 0.456, 0.414, 0.376, 0.345, 0.317, 0.291, 0.269,
     &     0.249, 0.233, 0.218, 0.205, 0.193, 0.184, 0.169, 0.157,
     &     0.148, 0.141, 0.136, 0.131, 0.123, 0.100, 0.082, 0.076, 
     &     0.070, 0.065, 0.060, 0.058, 0.051, 0.048, 0.043, 0.036, 
     &     0.032, 0.030/
C     
      
      CALL HUNT(WV,NWAVE,WAVE,IM)
      
      IF (IM.EQ.-1) THEN
         IF (WAVE.GE.WV(NWAVE)) THEN
            EXTINC = EXT(NWAVE)
         ELSE
            EXTINC = EXT(1)
         ENDIF
         RETURN
      ENDIF
      
      PART = (WAVE-WV(IM)) / (WV(IM+1)-WV(IM))
      EXTINC = EXT(IM)*(1.-PART) + EXT(IM+1)*PART
      RETURN
      END
      
