*ECOPY
* ECOPY N1 N2 N3 N4 -- Copies error bars from one set of spectra to another.
*                    
* This routine is usefule in simulating data by getting exactly the same
* error bars as real data and then adding noise with NOISE
*
* Parameters: 
*     
*  N1    -- Slot number of first spectrum to copy errors INTO
*  N2    -- Slot number of last spectrum to copy errors INTO
*  N3    -- Slot number of first spectrum to get errors FROM
*  N4    -- Slot number of last spectrum to get errors FROM
*
* NB It is the absolute flux errors that are copied.
*ECOPY
      SUBROUTINE ECOPY(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, NMCHAR, 
     &NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, HDREAL, 
     &NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &SLOTS1, SLOTS2, MXSLOTS, IFAIL)
*
* Rebins spectra to a uniform velocity or wavelength scale.
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
*    I     SLOTS1(MXSLOTS) -- Work array for list of slots
*    I     SLOTS2(MXSLOTS) -- Work array for list of slots
*    I     MXSLOTS
* <  I     IFAIL              -- Error return.
*
      IMPLICIT NONE

*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL   FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*
* Command parameters
*
      INTEGER MXSPLIT, NSPLIT, NCOM
      CHARACTER*(*) SPLIT(MXSPLIT)
*
* Slot lists
*
      INTEGER MXSLOTS, NSLOTS1, NSLOTS2, SLOT
      INTEGER SLOTS1(MXSLOTS), SLOTS2(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST1, LIST1(2,MXLIST)
      INTEGER NLIST2, LIST2(2,MXLIST)
*
* Local variables
*
      INTEGER I, J
      REAL GET_FLX,  CFRAT, RATIO, FLX, ERR
      REAL GET_ERF, SET_ERF
      INTEGER SLOT1, SLOT2, SLOT3, SLOT4, IFAIL, MAXSPEC
      LOGICAL DEFAULT
      INTEGER TEMP
*
      DATA SLOT1, SLOT2, SLOT3, SLOT4/1,1,2,2/
*
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
*
* First slot
*
      CALL INTR_IN('First spectrum to copy errors to', SPLIT, 
     &NSPLIT, MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
*
* Second slot
*
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last spectrum to copy errors to', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
        WRITE(*,*) 'Only 0,0 to get list option'
        GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
        WRITE(*,*) 'Enter list of spectra to copy errors to'
        CALL GETLIS(LIST1, NLIST1, MXLIST, MAXSPEC, SLOTS1, 
     &  NSLOTS1, MXSLOTS)
        IF(NSLOTS1.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT1, SLOT2, LIST1, NLIST1, MXLIST, SLOTS1, 
     &  NSLOTS1, MXSLOTS)
      END IF
*
* First slot to provide errors
*
      CALL INTR_IN('First spectrum to get errors from', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT3, 0, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
*
* Second slot
*
      SLOT4 = MAX(SLOT3, SLOT4)
      CALL INTR_IN('Last spectrum to get errors from', SPLIT, NSPLIT, 
     &MXSPLIT, NCOM, DEFAULT, SLOT4, SLOT3, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT3.EQ.0 .AND. SLOT4.NE.0) THEN
        WRITE(*,*) 'Only 0,0 to get list option'
        GOTO 999
      ELSE IF(SLOT3.EQ.0 .AND. SLOT4.EQ.0) THEN
        WRITE(*,*) 'Enter list of spectra to get errors from'
        CALL GETLIS(LIST2, NLIST2, MXLIST, MAXSPEC, SLOTS2, 
     &  NSLOTS2, MXSLOTS)
        IF(NSLOTS2.EQ.0) GOTO 999
      ELSE
        CALL SETLIS(SLOT3, SLOT4, LIST2, NLIST2, MXLIST, 
     &  SLOTS2, NSLOTS2, MXSLOTS)
      END IF
      IF(NSLOTS2.NE.1 .AND. NSLOTS2.NE.NSLOTS1) THEN
        WRITE(*,*) 'Must either have the same number of spectra'
        WRITE(*,*) 'or just a single spectrum to get errors from'
        GOTO 999
      END IF
      IF(IFAIL.NE.0) GOTO 999
*
* Now transfer errors
*
      DO I = 1, NSLOTS1
        SLOT = SLOTS1(I)
        IF( NPIX(SLOT).LE.0) THEN
          WRITE(*,*) 'Slot ',SLOT,' is empty.'
          WRITE(*,*) 'Aborting error transfer.'
          GOTO 999
        END IF
        IF(NSLOTS2.EQ.1) THEN
          TEMP = SLOTS2(1)
        ELSE
          TEMP = SLOTS2(I)
        END IF
        IF(NPIX(TEMP).LE.0) THEN
          WRITE(*,*) 'Template slot ',TEMP,' is empty.'
          WRITE(*,*) 'Aborting error transfer.'
          GOTO 999
        END IF
        IF(NPIX(TEMP).NE.NPIX(SLOT)) THEN
          WRITE(*,*) 'Slot ',SLOT,' and template ',TEMP
          WRITE(*,*) 'have diffferent numbers of pixels.'
          WRITE(*,*) 'Aborting error transfer.'
          GOTO 999
        END IF
        DO J = 1, NPIX(SLOT)
          RATIO = CFRAT(COUNTS(J,SLOT),FLUX(J,SLOT))
          FLX = GET_FLX(COUNTS(J,SLOT),FLUX(J,SLOT))
          ERR = GET_ERF(COUNTS(J,TEMP),ERRORS(J,TEMP),
     &                  FLUX(J,TEMP))        
          ERRORS(J,SLOT) = SET_ERF(COUNTS(J,SLOT),FLX,ERR,RATIO)
        END DO
      END DO
      IFAIL = 0
      WRITE(*,*) 'Finished error transfer.'
999   RETURN
      END




