*WDOPP
* WDOPP File N1 N2 HJD0 PERIOD -- Writes spectra to an NDF file designed
*                                 for the NDF doppler routines.
*
* Parameters:
* 
*            FILE   -- Filename
*            N1     -- First slot to write out
*            N2     -- Last slot to write out
*            HJD0   -- HJD of const in ephemeris to be used
*            PERIOD -- Period to be used.
*            FACTOR -- Factor to multiply negative error bars by. Use this
*                      to avoid possible problems in 'memit' by setting
*                      to a large negative value, e.g. -1.e6. Set = 1 to
*                      leave such errors unchanged.
*
* This writes out to a 2D NDF file with an extension containing various header
* info needed by the Doppler imaging programs. Only the wavelength scale of the 
* first spectrum is stored and so they should be all the same for useful results, 
* although this is not forced.
*
* WDOPP replaces WRHDS
*
*WDOPP
      SUBROUTINE DOPPDMP(SPLIT, NSPLIT, MXSPLIT, COUNTS, ERRORS, 
     &FLUX, MXBUFF, MXSPEC, MAXPX, NPIX, ARC, NARC, MXARC, 
     &NMCHAR, NMDOUB, NMINTR, NMREAL, HDCHAR, HDDOUB, HDINTR, 
     &HDREAL, NCHAR, NDOUB, NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, 
     &MXREAL, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, VSINTR, 
     &NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL, MXSCHAR, 
     &MXSDOUB, MXSINTR, MXSREAL, SLOTS, MXSLOTS, 
     &WORK1, WORK2, WORK3, DWORK1, DWORK2, MXWORK, IFAIL)
*
* Dumps spectra to a Doppler FIGARO-type file.
* 
* Arguments:
*
* >  C*(*) SPLIT(MXSPLIT)   -- Command parameters. See below.
* >  I     NSPLIT           -- Actual number of entries in SPLIT. Can be
*                              zero in which case defaults are used.
* >  I     MXSPLIT          -- Dimension of SPLIT in calling routine.
* <  R     COUNTS(MXBUFF)    -- Array for spectra in counts 
* <  R     ERRORS(MXBUFF)    -- 1-sigma uncertainties in counts
* <  R     FLUX(MXBUFF)      -- Equivalent fluxes to COUNTS
* >  I     MXBUFF            -- Size of spectrum buffers in calling routine
* >  I     MXSPEC           -- Maximum number of spectra allowed by size
*                              of header buffers. 
* >  I     MAXPX            -- Maximum number of pixels/spectrum
* <  I     NPIX(MXSPEC)     -- Number of pixels for each spectrum
* <  D     ARC(MXARC,MXSPEC)-- Arc coefficient buffers
* <  I     NARC(MXSPEC)     -- Number of coefficients for each spectrum
* >  I     MXARC            -- Maximum number of arc coefficients/spectrum
* <  C*(*) NMCHAR(MXCHAR,MXSPEC) -- Names of character header items.
* <  C*(*) NMDOUB(MXDOUB,MXSPEC) -- Names of double precision header items.
* <  C*(*) NMINTR(MXINTR,MXSPEC) -- Names of integer header items.
* <  C*(*) NMREAL(MXREAL,MXSPEC) -- Names of real header items.
* <  C*(*) HDCHAR(MXCHAR,MXSPEC) -- Character header items
* <  D     HDDOUB(MXDOUB,MXSPEC) -- Double precision header items
* <  I     HDINTR(MXINTR,MXSPEC) -- Integer header items
* <  R     HDREAL(MXREAL,MXSPEC) -- Real header items
* <  I     NCHAR(MXSPEC)  -- Number of character header items.
* <  I     NDOUB(MXSPEC)  -- Number of double precision header items.
* <  I     NINTR(MXSPEC)  -- Number of integer items.
* <  I     NREAL(MXSPEC)  -- Number of real items.
* >  I     MXCHAR    -- Maximum number of character header items/spec
* >  I     MXDOUB    -- Maximum number of double precsion header items/spec
* >  I     MXINTR    -- Maximum number of integer header items/spec
* >  I     MXREAL    -- Maximum number of real headers items/spec
* >  C*(*) NMSCHAR(MXSCHAR)   -- Names of character selection items.
* >  C*(*) VSCHAR(MXSCHAR)    -- Values of character selection items.
* >  C*(*) NMSDOUB(MXSDOUB)   -- Names of double precision selection items.
* >  D     VSDOUB(2,MXSDOUB)  -- Values of double precision selection items.
* >  C*(*) NMSINTR(MXSINTR)   -- Names of integer selection items.
* >  I     VSINTR(2,MXSINTR)  -- Values of integer selection items.
* >  C*(*) NMSREAL(MXSREAL)   -- Names of real selection items.
* >  R     VSREAL(2,MXSREAL)  -- Values of real selection items.
* >  I     NSCHAR             -- Number of character selection items.
* >  I     NSDOUB             -- Number of double precsion selection items.
* >  I     NSINTR             -- Number of integer selection items.
* >  I     NSREAL             -- Number of real selection items.
* >  I     MXSCHAR            -- Dimension of NMSCHAR in calling routine.
* >  I     MXSDOUB            -- Dimension of NMSDOUB in calling routine.
* >  I     MXSINTR            -- Dimension of NMSINTR in calling routine.
* >  I     MXSREAL            -- Dimension of NMSREAL in calling routine.   
*    I     SLOTS(MXSLOTS)
*    I     MXSLOTS
*    R     WORK1(MXWORK)
*    R     WORK2(MXWORK)
*    R     WORK3(MXWORK)
*    D     DWORK1(MXWORK)
*    D     DWORK2(MXWORK)
*    I     MXWORK
* IFAIL)
*
      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INCLUDE 'DAT_PAR'
      INCLUDE 'PRM_PAR'
      INCLUDE 'CNF_PAR'
*
* Integer parameters
*
      INTEGER MXSPEC, MXBUFF, MAXPX, MXARC, MXCHAR, MXDOUB
      INTEGER MXINTR, MXREAL, MXSCHAR, MXSDOUB, MXSINTR
      INTEGER MXSREAL, NSCHAR, NSDOUB, NSINTR, NSREAL
      INTEGER NPIX(MXSPEC)
      INTEGER NARC(MXSPEC)
*
* Data arrays
*
      REAL COUNTS(MAXPX,MXBUFF/MAXPX)
      REAL ERRORS(MAXPX,MXBUFF/MAXPX)
      REAL FLUX(MAXPX,MXBUFF/MAXPX)
*
* Numbers of header items
*
      INTEGER NCHAR(MXSPEC)
      INTEGER NDOUB(MXSPEC)
      INTEGER NINTR(MXSPEC)
      INTEGER NREAL(MXSPEC)
*
* Names of header items
*
      CHARACTER*(*) NMCHAR(MXCHAR,MXSPEC)
      CHARACTER*(*) NMDOUB(MXDOUB,MXSPEC)
      CHARACTER*(*) NMINTR(MXINTR,MXSPEC)
      CHARACTER*(*) NMREAL(MXREAL,MXSPEC)
*
* Values of header items
*
      CHARACTER*(*)    HDCHAR(MXCHAR,MXSPEC)
      DOUBLE PRECISION HDDOUB(MXDOUB,MXSPEC)
      INTEGER          HDINTR(MXINTR,MXSPEC)
      REAL             HDREAL(MXREAL,MXSPEC)
*
* Arc coefficients
*
      DOUBLE PRECISION ARC(MXARC,MXSPEC)
*     
*     Command parameters
*
      INTEGER MXSPLIT, NSPLIT
      CHARACTER*(*) SPLIT(MXSPLIT)
*
*     Search parameters, names then values.
*
      CHARACTER*(*) NMSCHAR(MXSCHAR)
      CHARACTER*(*) NMSDOUB(MXSDOUB)
      CHARACTER*(*) NMSINTR(MXSINTR)
      CHARACTER*(*) NMSREAL(MXSREAL)
*
      CHARACTER*(*) VSCHAR(MXSCHAR)
      DOUBLE PRECISION VSDOUB(2,MXSDOUB)
      INTEGER VSINTR(2,MXSINTR)
      REAL VSREAL(2,MXSREAL)
*
*     Slot lists
*
      INTEGER MXSLOTS, NSLOTS, SLOT
      INTEGER SLOTS(MXSLOTS)
      INTEGER MXLIST
      PARAMETER (MXLIST=50)
      INTEGER NLIST, LIST(2,MXLIST)
      INTEGER MXWORK
      REAL WORK1(MXWORK), WORK2(MXWORK)
      REAL WORK3(MXWORK)
      DOUBLE PRECISION DWORK1(MXWORK), DWORK2(MXWORK)
*
*     Local variables
*
      DOUBLE PRECISION DVAL
      CHARACTER*64 FILE
      INTEGER SLOT1, SLOT2, IFAIL, I, J, NSPEC, STATUS
      INTEGER MAXSPEC, NSAME, NFIRST, NS, NCOM, PLACE
      INTEGER LBND(2), UBND(2), DPTR, EL, EPTR
      INTEGER DOPP
      LOGICAL SELECT, DEFAULT
      REAL GET_FLX, GET_ERF, FACTOR
      DOUBLE PRECISION HJD0, PERIOD
      CHARACTER*(DAT__SZLOC) LOC
C
      DATA SLOT1, SLOT2/1,1/
      DATA HJD0, PERIOD/2440000., 0.1/
      DATA FACTOR/-1.E6/
      DATA FILE/'mdopp'/
C
      MAXSPEC = MIN(MXBUFF/MAXPX, MXSPEC)
      DEFAULT = .FALSE.
      IFAIL = 0
      NCOM  = 0
      CALL CHAR_IN('File name', SPLIT, NSPLIT, MXSPLIT, NCOM,
     &     DEFAULT, FILE, IFAIL)
      CALL INTR_IN('First slot to dump', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT1, 0, MAXSPEC, IFAIL)
      SLOT2 = MAX(SLOT1, SLOT2)
      CALL INTR_IN('Last slot to dump', SPLIT, NSPLIT, 
     &     MXSPLIT, NCOM, DEFAULT, SLOT2, SLOT1, MAXSPEC, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
      IF(SLOT1.EQ.0 .AND. SLOT2.NE.0) THEN
         WRITE(*,*) 'Only 0,0 to get list option'
         GOTO 999
      ELSE IF(SLOT1.EQ.0 .AND. SLOT2.EQ.0) THEN
         IF(DEFAULT .AND. NLIST.GT.0) THEN
            CALL SETSLOT(LIST, NLIST, MXLIST, SLOTS, NSLOTS, MXSLOTS)
         ELSE
            WRITE(*,*) 'Enter list of spectra to dump'
            CALL GETLIS(LIST, NLIST, MXLIST, MAXSPEC, SLOTS, 
     &           NSLOTS, MXSLOTS)
         END IF
         IF(NSLOTS.EQ.0) THEN
            IFAIL = 1
            GOTO 999
         END IF
      ELSE
         CALL SETLIS(SLOT1, SLOT2, LIST, NLIST, MXLIST, SLOTS, 
     &        NSLOTS, MXSLOTS)
      END IF
C     
C     Check number of spectra to dump. All spectra must have same length
C     as well as passing selection criteria.
C     
      NSAME = 0
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
C     
C     Apply selection criteria
C     
         IF(NPIX(SLOT).LE.0 .OR. NARC(SLOT).EQ.0 .OR. 
     &        .NOT.SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, 
     &        HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &        NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &        MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, 
     &        VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &        NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN
            GOTO 200
         END IF
         IF(NSAME.EQ.0) THEN
            NSAME  = NPIX(SLOT)
            NFIRST = SLOT
            NSPEC  = 1
         ELSE
            IF(NSAME.NE.NPIX(SLOT)) THEN
               WRITE(*,*) 'Slot ',SLOT,' has ',NPIX(SLOT),' pixels'
               WRITE(*,*) 'incompatible with first valid spectrum'
               WRITE(*,*) 'which had ',NSAME,' pixels.'
               IFAIL = 1
               GOTO 999
            END IF
            NSPEC = NSPEC + 1
         END IF
 200     CONTINUE
      END DO
      IF(NSPEC.LT.1) THEN
         WRITE(*,*) 'No valid spectra found.'
         GOTO 999
      END IF
C
C     Look for orbital ephemeris as a default
C
      CALL HGETD('ZeroO', DVAL, NFIRST, MXSPEC, NMDOUB, HDDOUB,
     &     NDOUB, MXDOUB, IFAIL)
      IF(IFAIL.EQ.0) HJD0 = DVAL
      CALL HGETD('PeriodO', DVAL, NFIRST, MXSPEC, NMDOUB, HDDOUB,
     &     NDOUB, MXDOUB, IFAIL)
      IF(IFAIL.EQ.0) PERIOD = DVAL
      IFAIL = 0
      CALL DOUB_IN('HJD0', SPLIT, NSPLIT, MXSPLIT, NCOM,
     &     DEFAULT, HJD0, 2.D6, 3.D6, IFAIL)
      CALL DOUB_IN('PERIOD', SPLIT, NSPLIT, MXSPLIT, NCOM,
     &     DEFAULT, PERIOD, 0.D0, 1.D5, IFAIL)
      CALL REAL_IN('FACTOR', SPLIT, NSPLIT, MXSPLIT, NCOM,
     &     DEFAULT, FACTOR, -1.E15, 1.E15, IFAIL)
      IF(IFAIL.NE.0) GOTO 999
C
C     Create new NDF
C
      STATUS  = SAI__OK
      CALL NDF_OPEN(DAT__ROOT,FILE,'WRITE','NEW',DOPP,PLACE,STATUS)
      LBND(1) = 1
      LBND(2) = 1
      UBND(1) = NSAME
      UBND(2) = NSPEC
      CALL NDF_NEW('_REAL',2,LBND,UBND,PLACE,DOPP,STATUS)
C     
C     Create doppler data extension
C     
      CALL NDF_XNEW(DOPP,'DOPPLER_DATA','Ext',0,0,LOC,STATUS)
      CALL CMP_MOD(LOC, 'HJD',    '_DOUBLE', 1, NSPEC, STATUS)
      CALL CMP_MOD(LOC, 'DWELL' , '_REAL',   1, NSPEC, STATUS)
      CALL CMP_MOD(LOC, 'PHASES', '_DOUBLE', 1, NSPEC, STATUS)
      CALL CMP_MOD(LOC, 'NARC', '_INTEGER', 0, 0, STATUS)
      CALL CMP_MOD(LOC, 'ARC', '_DOUBLE', 1, ABS(NARC(NFIRST)), STATUS)
      CALL CMP_MOD(LOC, 'HJD0', '_DOUBLE', 0, 0, STATUS)
      CALL CMP_MOD(LOC, 'PERIOD', '_DOUBLE', 0, 0, STATUS)
C
C     Set values
C
      CALL CMP_PUT0I(LOC,'NARC',NARC(NFIRST),STATUS)
      CALL CMP_PUT1D(LOC,'ARC',ABS(NARC(NFIRST)),ARC(1,NFIRST),STATUS)
      CALL CMP_PUT0D(LOC,'HJD0',HJD0,STATUS)
      CALL CMP_PUT0D(LOC,'PERIOD',PERIOD,STATUS)
C
C Map data and errors
C
      CALL NDF_MAP(DOPP,'Data','_REAL','WRITE',DPTR,EL,STATUS)
      CALL NDF_MAP(DOPP,'Error','_REAL','WRITE',EPTR,EL,STATUS)
C
C     Dump image data
C
      NS = 0
      DO I = 1, NSLOTS
         SLOT = SLOTS(I)
C
C     Apply selection criteria
C
         IF(NPIX(SLOT).LE.0 .OR. NARC(SLOT).EQ.0 .OR. 
     &        .NOT.SELECT(SLOT, NMCHAR, NMDOUB, NMINTR, NMREAL, 
     &        HDCHAR, HDDOUB, HDINTR, HDREAL, NCHAR, NDOUB, 
     &        NINTR, NREAL, MXCHAR, MXDOUB, MXINTR, MXREAL, 
     &        MXSPEC, NMSCHAR, VSCHAR, NMSDOUB, VSDOUB, NMSINTR, 
     &        VSINTR, NMSREAL, VSREAL, NSCHAR, NSDOUB, NSINTR, 
     &        NSREAL, MXSCHAR, MXSDOUB, MXSINTR, MXSREAL)) THEN
            WRITE(*,*) 'Spectrum ',SLOT,' skipped.'
         ELSE
            NS = NS + 1
C
C     Load data into work arrays
C
            DO J = 1, NPIX(SLOT)
               WORK1(J) = GET_FLX(COUNTS(J,SLOT), FLUX(J,SLOT))
               WORK2(J) = GET_ERF(COUNTS(J,SLOT), ERRORS(J,SLOT), 
     &              FLUX(J,SLOT))
               IF(WORK2(J).LT.0.) WORK2(J) = FACTOR*WORK2(J)
            END DO
C
C     Transfer into output arrays
C     
            CALL DAT_TRANS(WORK1,%VAL(CNF_PVAL(DPTR)),
     :                     NSAME,NS,NSPEC,STATUS)
            CALL DAT_TRANS(WORK2,%VAL(CNF_PVAL(EPTR)),
     :                     NSAME,NS,NSPEC,STATUS)
C
C     Get HJD and DWELL, store in work arrays
C
            CALL HGETD('HJD', DWORK1(NS), SLOT, MXSPEC, NMDOUB, HDDOUB, 
     &           NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.NE.0) 
     &           WRITE(*,*) 'Failed to find HJD of slot ',SLOT
            CALL HGETD('Orbital phase', DWORK2(NS), SLOT, MXSPEC, 
     &           NMDOUB, HDDOUB, NDOUB, MXDOUB, IFAIL)
            IF(IFAIL.NE.0) 
     &           WRITE(*,*) 'Failed to find phase of slot ',SLOT
            CALL HGETR('Dwell', WORK3(NS), SLOT, MXSPEC, NMREAL, HDREAL,
     &           NREAL, MXREAL, IFAIL)
            IF(IFAIL.NE.0) 
     &           WRITE(*,*) 'Failed to find Dwell of slot ',SLOT
            WRITE(*,*) 'Spectrum ',SLOT,' dumped.'
         END IF
      END DO                  
C
C     Dump HJDs, phases, and dwells
C
      CALL CMP_PUT1D(LOC,'HJD',NSPEC,DWORK1,STATUS)
      CALL CMP_PUT1D(LOC,'PHASES',NSPEC,DWORK2,STATUS)
      CALL CMP_PUT1R(LOC,'DWELL',NSPEC,WORK3,STATUS)
C
C     Tidy up
C
      CALL DAT_ANNUL(LOC, STATUS)
      CALL NDF_ANNUL(DOPP, STATUS)
999   CONTINUE
      RETURN
      END	

      SUBROUTINE DAT_TRANS(INPUT, OUTPUT, NPIX, NS, NSPEC, STATUS)
C
C     Transfers data from one array to another
C     
      IMPLICIT NONE
      INCLUDE 'SAE_PAR'
      INTEGER NPIX, NSPEC, STATUS, I, NS, NOFF
      REAL INPUT(NPIX), OUTPUT(NPIX*NSPEC)
C
      IF(STATUS.NE.SAI__OK) RETURN
      NOFF = NPIX*(NS-1)
      DO I = 1, NPIX
        OUTPUT(NOFF+I) = INPUT(I)
      END DO
      RETURN
      END
